/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.config.ConnectivityEvent;
import com.singularity.ee.agent.commonservices.config.IConnectivityEventListener;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppMetricAggregatorFactory
extends AMetricAggregatorFactory
implements IConnectivityEventListener {
    private static final String LOG_APPD_METRIC_AGGREGATORS_AT_LIMIT = "appdynamics.agent.log.metric.aggregators.at.limit";
    private final ADConcurrentHashMap<AgentRawMetricIdentifier, IMetricAggregator> aggregators = new ADConcurrentHashMap();
    private final ADConcurrentHashMap<AgentRawMetricIdentifier, IMetricAggregator> derivedAggregators = new ADConcurrentHashMap();
    private final ADConcurrentHashMap<IMetricAggregator, AgentRawMetricIdentifier[]> aggregatorsReverseMap = new ADConcurrentHashMap();
    private final ADConcurrentHashMap<IMetricAggregator, String> unregAggregators = new ADConcurrentHashMap();
    private static final boolean logMetricsAtLimit = SystemUtils.getProperty((String)"appdynamics.agent.log.metric.aggregators.at.limit", (String)"false").equalsIgnoreCase("true");
    private boolean metricNamesLoggedAtLimit = false;
    private long previousMetricLogTime = 0L;

    public AppMetricAggregatorFactory(ILogger logger, IEventGenerationService egs, int maxMetricsAllowed) {
        super(logger, egs, maxMetricsAllowed);
    }

    @Override
    public AgentRawMetricIdentifier[] getRegisteredMetrics() {
        ArrayList<AgentRawMetricIdentifier> ids = new ArrayList<AgentRawMetricIdentifier>();
        ADIterator it = this.aggregatorsReverseMap.valuesIterator();
        while (it.hasNext()) {
            AgentRawMetricIdentifier[] identifiers;
            for (AgentRawMetricIdentifier identifier : identifiers = (AgentRawMetricIdentifier[])it.next()) {
                ids.add(identifier);
            }
        }
        return (AgentRawMetricIdentifier[])CollectionHelper.collectionToArray(ids, (Object[])new AgentRawMetricIdentifier[ids.size()]);
    }

    @Override
    public void unregisterAggregator(AgentRawMetricIdentifier metricIdentifier) {
        IMetricAggregator agg;
        if (metricIdentifier != null && (agg = (IMetricAggregator)this.aggregators.remove((Object)metricIdentifier)) != null) {
            this.aggregatorsReverseMap.remove((Object)agg);
        }
    }

    @Override
    public IMetricAggregator registerDerivedAggregator(AgentRawMetricIdentifier metricIdentifier, IMetricAggregator metricAggregator) {
        if (this.derivedAggregators.get((Object)metricIdentifier) == null) {
            this.derivedAggregators.putIfAbsent((Object)metricIdentifier, (Object)metricAggregator);
        }
        return (IMetricAggregator)this.derivedAggregators.get((Object)metricIdentifier);
    }

    @Override
    public IMetricAggregator unregisterDerivedAggregator(AgentRawMetricIdentifier metricIdentifier) {
        return (IMetricAggregator)this.derivedAggregators.remove((Object)metricIdentifier);
    }

    @Override
    public void unregisterAggregator(IMetricAggregator aggregator) {
        AgentRawMetricIdentifier[] ids;
        if (aggregator != null && (ids = (AgentRawMetricIdentifier[])this.aggregatorsReverseMap.get((Object)aggregator)) != null) {
            for (AgentRawMetricIdentifier id : ids) {
                this.unregisterAggregator(id);
            }
        }
    }

    @Override
    public void clearAllAggregators() {
        this.logger.info("Clearing all the aggregators ");
        this.aggregators.clear();
        this.aggregatorsReverseMap.clear();
    }

    @Override
    public void purge(AgentRawMetricIdentifier unregisteredMetricIdentifier) {
        IMetricAggregator aggregator = this.getMetricAggregator(unregisteredMetricIdentifier);
        this.purge(aggregator);
    }

    public void purge(IMetricAggregator aggregator) {
        if (aggregator != null) {
            this.unregisterAggregator(aggregator);
            this.unregAggregators.remove((Object)aggregator);
        }
    }

    @Override
    protected IMetricAggregator getMetricAggregator(AgentRawMetricIdentifier metricId) {
        return (IMetricAggregator)this.aggregators.get((Object)metricId);
    }

    @Override
    protected void registerNewAggregator(IMetricAggregator aggregator, AgentRawMetricIdentifier metricIdentifier, AgentRawMetricIdentifier[] otherNames) {
        if (this.aggregators.putIfAbsent((Object)metricIdentifier, (Object)aggregator) == null) {
            if (otherNames.length == 0) {
                this.aggregatorsReverseMap.put((Object)aggregator, (Object)new AgentRawMetricIdentifier[]{metricIdentifier});
            } else {
                AgentRawMetricIdentifier[] list = new AgentRawMetricIdentifier[otherNames.length + 1];
                list[0] = metricIdentifier;
                System.arraycopy(otherNames, 0, list, 1, otherNames.length);
                this.aggregatorsReverseMap.put((Object)aggregator, (Object)list);
                for (AgentRawMetricIdentifier otherName : otherNames) {
                    this.aggregators.putIfAbsent((Object)otherName, (Object)aggregator);
                }
            }
        } else {
            this.logger.info("Multiple aggregator attempt to track the same Identifier: [" + metricIdentifier + "]. The old one will be used");
        }
    }

    @Override
    protected void addUnregisteredAggregator(IMetricAggregator unregAggregator) {
        this.unregAggregators.put((Object)unregAggregator, (Object)"");
    }

    @Override
    protected IMetricAggregator moveMetricToRegistered(AgentRawMetricIdentifier metricIdentifier, IMetricAggregator metricAggregator) {
        if (this.getMetricAggregator(metricIdentifier) == null) {
            this.aggregators.putIfAbsent((Object)metricIdentifier, (Object)metricAggregator);
            this.aggregatorsReverseMap.putIfAbsent((Object)metricAggregator, (Object)new AgentRawMetricIdentifier[]{metricIdentifier});
        }
        if (this.unregAggregators.remove((Object)metricAggregator) == null && this.logger.isDebugEnabled()) {
            this.logger.debug("FAILED to remove from unreg" + metricIdentifier + metricAggregator);
        }
        return this.getMetricAggregator(metricIdentifier);
    }

    @Override
    protected void collateAllAggregators(List<AgentRawMetricData> registeredMetrics, List<AgentRawMetricData> unregisteredMetrics, ILogger logger) {
        ADIterator aggregatorKeys = this.aggregatorsReverseMap.keySetIterator();
        while (aggregatorKeys.hasNext()) {
            IMetricAggregator aggregator = (IMetricAggregator)aggregatorKeys.next();
            AppMetricAggregatorFactory.collateMetricWithIds(aggregator, CollectionHelper.asList((Object[])((Object[])this.aggregatorsReverseMap.get((Object)aggregator))), registeredMetrics, unregisteredMetrics, logger);
        }
        if (this.derivedAggregators.size() > 0) {
            Collection derivedAggregatorKeys = this.derivedAggregators.getAllKeys();
            for (AgentRawMetricIdentifier derivedAggregatorKey : derivedAggregatorKeys) {
                AppMetricAggregatorFactory.collateMetricWithIds((IMetricAggregator)this.derivedAggregators.get((Object)derivedAggregatorKey), CollectionHelper.asList((Object[])new AgentRawMetricIdentifier[]{derivedAggregatorKey}), registeredMetrics, unregisteredMetrics, logger);
            }
        }
    }

    @Override
    protected Collection<IMetricAggregator> getAllUnregisteredAggregators() {
        return this.unregAggregators.getAllKeys();
    }

    @Override
    protected int currentWeight() {
        int currentTotalWeight = this.aggregators.fastApproximateSize() + this.unregAggregators.fastApproximateSize();
        if (currentTotalWeight >= this.getMaxMetricsAllowed() && metricExtendedLogger.isDebugEnabled()) {
            long timeNow = System.currentTimeMillis();
            if (timeNow - this.previousMetricLogTime >= 60000L) {
                metricExtendedLogger.debug("The metric aggregators are at capacity [" + this.getMaxMetricsAllowed() + "].Registered [" + this.aggregators.fastApproximateSize() + "] and Unregistered [" + this.unregAggregators.fastApproximateSize() + "]");
                this.previousMetricLogTime = timeNow;
            }
            if (logMetricsAtLimit && !this.metricNamesLoggedAtLimit) {
                this.logMetricNamesOrAggregators();
                this.metricNamesLoggedAtLimit = true;
            }
        }
        return currentTotalWeight;
    }

    private void logMetricNamesOrAggregators() {
        StringBuilder regAggSb = new StringBuilder();
        regAggSb.append("Dumping Registered Metrics: \n");
        for (AgentRawMetricIdentifier metricIdentifier : this.aggregators.getAllKeys()) {
            regAggSb.append(metricIdentifier).append("\n");
        }
        regAggSb.append("End of Registered Metrics Dump.\n");
        StringBuilder unRegAggSb = new StringBuilder();
        unRegAggSb.append("Dumping Unregistered Metrics: \n");
        for (IMetricAggregator metricAggregator : this.unregAggregators.getAllKeys()) {
            unRegAggSb.append(metricAggregator).append("\n");
        }
        unRegAggSb.append("End of Unregistered Metrics Dump.\n");
        metricExtendedLogger.debug(regAggSb.toString());
        metricExtendedLogger.debug(unRegAggSb.toString());
    }

    private void forceMetricReporting() {
        for (IMetricAggregator aggregator : this.aggregators.getAllValues()) {
            if (!(aggregator instanceof AMetricAggregator)) continue;
            ((AMetricAggregator)aggregator).resetReportedIntervals();
        }
    }

    @Override
    public void notifyChannelListener(ConnectivityEvent connectivityEvent) {
        if (connectivityEvent == ConnectivityEvent.RECONNECTED) {
            this.forceMetricReporting();
        }
    }
}

