/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AdvancedAverageMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AvailabilityMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AverageMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.DummyAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.ObservationForeverIncreasingMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.ObservationMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.SumMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.RawMetrics;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricUnavailableException;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicBooleanImpl;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.reflect.ReflectionUtilityCommon;
import com.singularity.ee.util.spi.IAgentAtomicBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AMetricAggregatorFactory
implements IMetricAggregatorFactory {
    protected static final int METRIC_REG_LIMIT_REACHED_INTERVAL_MS = 900000;
    protected static final AgentRawMetricIdentifier[] NO_OTHER_NAMES = new AgentRawMetricIdentifier[0];
    private static final String CAPACITY_REACHED_MESSAGE = "Metric registration limit of %d reached";
    private int maxMetricsAllowed;
    private final IAgentAtomicBoolean hasFiredOverloadAlert = new AgentAtomicBooleanImpl(false);
    protected final ILogger logger;
    protected static final IADLogger metricExtendedLogger = ADLoggerFactory.getLogger("com.singularity.METRICS.extendedLogger");
    protected final IEventGenerationService egs;

    protected AMetricAggregatorFactory(ILogger logger, IEventGenerationService egs, int maxMetricsAllowed) {
        this.logger = logger;
        this.egs = egs;
        this.maxMetricsAllowed = maxMetricsAllowed;
    }

    public void setMaxMetricsAllowed(int maxMetricsAllowed) {
        this.logger.info("Current number of metrics is " + this.currentWeight());
        if (this.hasFiredOverloadAlert.compareAndSet(true, false)) {
            this.logger.info("Resetting metric limit alert logging threshold, agent will log if limit new limit is hit.");
        }
        this.maxMetricsAllowed = maxMetricsAllowed;
    }

    @VisibleForTesting
    public int getMaxMetricsAllowed() {
        return this.maxMetricsAllowed;
    }

    public final IMetricAggregator safeGetAggregator(AgentRawMetricIdentifier metricIdentifier) throws MetricReporterTypeMismatchException, MetricOverflowException {
        return this.safeGetAggregator(metricIdentifier, NO_OTHER_NAMES);
    }

    public IMetricAggregator safeGetAggregator(AgentRawMetricIdentifier metricIdentifier, AgentRawMetricIdentifier[] otherNames) throws MetricReporterTypeMismatchException, MetricOverflowException {
        IMetricAggregator aggregator = this.getMetricAggregator(metricIdentifier);
        if (aggregator == null) {
            if (this.isAtCapacity()) {
                return this.getEmptyAggregator();
            }
            aggregator = AMetricAggregatorFactory.createNewAggregator(metricIdentifier.getMetricAggregatorType());
            if (metricExtendedLogger.isDebugEnabled()) {
                metricExtendedLogger.debug("Created aggregator: " + aggregator + " for metricIdentifier " + metricIdentifier.toString());
            }
            this.registerNewAggregator(aggregator, metricIdentifier, otherNames);
            if (metricExtendedLogger.isDebugEnabled()) {
                metricExtendedLogger.debug("Registered aggregator: " + aggregator + " for metricIdentifier " + metricIdentifier.toString());
            }
        }
        if (!(aggregator = this.getMetricAggregator(metricIdentifier)).getType().equals((Object)metricIdentifier.getMetricAggregatorType())) {
            throw new MetricReporterTypeMismatchException("Aggregator of " + aggregator.getType() + " already exists for metric " + metricIdentifier);
        }
        return aggregator;
    }

    public final IMetricAggregator createAggregator(MetricAggregatorType type) {
        if (this.isAtCapacity()) {
            return this.getEmptyAggregator();
        }
        IMetricAggregator unregAggregator = AMetricAggregatorFactory.createNewAggregator(type);
        this.addUnregisteredAggregator(unregAggregator);
        return unregAggregator;
    }

    public final IMetricAggregator registerAggregator(AgentRawMetricIdentifier metricIdentifier, IMetricAggregator metricAggregator) {
        if (metricAggregator == DummyAggregator.getInstance()) {
            return metricAggregator;
        }
        return this.moveMetricToRegistered(metricIdentifier, metricAggregator);
    }

    public final IMetricAggregator getAggregator(AgentRawMetricIdentifier metricIdentifier) throws MetricUnavailableException {
        IMetricAggregator registeredAggregator = this.getMetricAggregator(metricIdentifier);
        if (registeredAggregator == null) {
            throw new MetricUnavailableException("Aggregator does not exist for metric " + metricIdentifier);
        }
        return registeredAggregator;
    }

    public final RawMetrics aggregateAll(int maxInactiveAllowed, ILogger logger) {
        ArrayList<AgentRawMetricData> registeredMetrics = new ArrayList<AgentRawMetricData>();
        ArrayList<AgentRawMetricData> unregisteredMetrics = new ArrayList<AgentRawMetricData>();
        this.collateAllAggregators(registeredMetrics, unregisteredMetrics, logger);
        this.notifyIfAtCapacity();
        for (IMetricAggregator aggregator : this.getAllUnregisteredAggregators()) {
            aggregator.aggregate();
        }
        return new RawMetrics((AgentRawMetricData[])CollectionHelper.collectionToArray(registeredMetrics, (Object[])new AgentRawMetricData[registeredMetrics.size()]), (AgentRawMetricData[])CollectionHelper.collectionToArray(unregisteredMetrics, (Object[])new AgentRawMetricData[unregisteredMetrics.size()]));
    }

    protected static void collateMetricWithIds(IMetricAggregator aggregator, Collection<? extends AgentRawMetricIdentifier> ids, List<AgentRawMetricData> registeredMetrics, List<AgentRawMetricData> unregisteredMetrics, ILogger logger) {
        boolean reportForRegistered = aggregator.isChanged();
        RawMetricValue rawMetricValue = aggregator.aggregate();
        if (rawMetricValue == null) {
            logger.warn("metric value null for: " + ids);
            return;
        }
        for (AgentRawMetricIdentifier agentRawMetricIdentifier : ids) {
            AMetricAggregatorFactory.collateMetricWithId(agentRawMetricIdentifier, aggregator, reportForRegistered, rawMetricValue, registeredMetrics, unregisteredMetrics, logger);
        }
    }

    protected IMetricAggregator getEmptyAggregator() {
        if (this.hasFiredOverloadAlert.compareAndSet(false, true)) {
            this.logMetricLimitReached();
        }
        return DummyAggregator.getInstance();
    }

    private void logMetricLimitReached() {
        String msg = "Maximum metrics limit reached [" + this.maxMetricsAllowed + "] no new metrics can be created. This exception will not repeat until restart.";
        this.logger.error(msg, (Throwable)new MetricOverflowException(msg));
    }

    private void notifyIfAtCapacity() {
        if (this.isAtCapacity() && this.egs.getInternalEventGenerator().lastEventTimedOut(EventType.AGENT_METRIC_REG_LIMIT_REACHED, 900000)) {
            this.egs.getInternalEventGenerator().throwCappedInternalEvent(EventType.AGENT_METRIC_REG_LIMIT_REACHED, String.format(CAPACITY_REACHED_MESSAGE, this.maxMetricsAllowed));
            this.logMetricLimitReached();
        }
    }

    protected boolean isAtCapacity() {
        return this.currentWeight() >= this.maxMetricsAllowed;
    }

    protected static IMetricAggregator createNewAggregator(MetricAggregatorType type) {
        switch (type) {
            case AVAILABILITY: {
                return new AvailabilityMetricAggregator();
            }
            case AVERAGE: {
                return new AverageMetricAggregator();
            }
            case ADVANCED_AVERAGE: {
                return new AdvancedAverageMetricAggregator();
            }
            case SUM: {
                return new SumMetricAggregator();
            }
            case OBSERVATION: {
                return new ObservationMetricAggregator();
            }
            case OBSERVATION_FOREVERINCREASING: {
                return new ObservationForeverIncreasingMetricAggregator();
            }
        }
        throw new IllegalArgumentException("Cannot create Aggregator of type" + type);
    }

    private static void collateMetricWithId(AgentRawMetricIdentifier id, IMetricAggregator aggregator, boolean reportForRegistered, RawMetricValue rawMetricValue, List<AgentRawMetricData> registeredMetrics, List<AgentRawMetricData> unregisteredMetrics, ILogger logger) {
        if (id.getId() == 0L) {
            AMetricAggregatorFactory.collateMetricIntoList(id, aggregator, rawMetricValue, unregisteredMetrics, logger, true);
        } else if (reportForRegistered) {
            AMetricAggregatorFactory.collateMetricIntoList(id, aggregator, rawMetricValue, registeredMetrics, logger, false);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(id.getId() + " " + id.getName() + " UNCHANGED " + aggregator.hashCode());
            }
            aggregator.resetLastAggregateValue();
        }
    }

    private static void collateMetricIntoList(AgentRawMetricIdentifier id, IMetricAggregator aggregator, RawMetricValue rawMetricValue, List<AgentRawMetricData> metricDataList, ILogger logger, boolean isUnregistered) {
        if (AMetricAggregatorFactory.isNotValid(rawMetricValue)) {
            String metricType = isUnregistered ? "Unregistered Metric " : "Registered Metric ";
            logger.debug(metricType + id + ", Value " + rawMetricValue + " being dropped");
            return;
        }
        AgentRawMetricData data = new AgentRawMetricData();
        data.setMetricIdentifier(id);
        data.setMetricValue(rawMetricValue);
        metricDataList.add(data);
        if (logger.isDebugEnabled()) {
            String unregisteredWarning = isUnregistered ? " UNREGISTERED " : " ";
            logger.debug(id.getId() + " " + id.getName() + " " + rawMetricValue.getCurrent() + unregisteredWarning + aggregator.hashCode());
        }
    }

    private static boolean isNotValid(RawMetricValue rawMetricValue) {
        return rawMetricValue.getCount() < 0L || rawMetricValue.getCurrent() < 0L || rawMetricValue.getMax() < 0L || rawMetricValue.getMin() < 0L || rawMetricValue.getSum() < 0L;
    }

    protected abstract IMetricAggregator getMetricAggregator(AgentRawMetricIdentifier var1);

    protected abstract void registerNewAggregator(IMetricAggregator var1, AgentRawMetricIdentifier var2, AgentRawMetricIdentifier[] var3);

    protected abstract void addUnregisteredAggregator(IMetricAggregator var1);

    protected abstract void collateAllAggregators(List<AgentRawMetricData> var1, List<AgentRawMetricData> var2, ILogger var3);

    protected abstract Collection<IMetricAggregator> getAllUnregisteredAggregators();

    protected abstract IMetricAggregator moveMetricToRegistered(AgentRawMetricIdentifier var1, IMetricAggregator var2);

    protected abstract int currentWeight();

    public abstract void purge(AgentRawMetricIdentifier var1);

    public abstract void unregisterAggregator(AgentRawMetricIdentifier var1);

    public abstract void unregisterAggregator(IMetricAggregator var1);

    public abstract void clearAllAggregators();

    public abstract AgentRawMetricIdentifier[] getRegisteredMetrics();

    public IMetricAggregator registerDerivedAggregator(AgentRawMetricIdentifier metricIdentifier, IMetricAggregator metricAggregator) {
        throw new IllegalStateException("registerDerivedAggregator not implemented for " + ReflectionUtilityCommon.getName(this.getClass()));
    }

    public IMetricAggregator unregisterDerivedAggregator(AgentRawMetricIdentifier metricIdentifier) {
        throw new IllegalStateException("unregisterDerivedAggregator not implemented for " + ReflectionUtilityCommon.getName(this.getClass()));
    }
}

