/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration;

import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.MetricsForTimeslice;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.RawMetrics;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.ControllerTimeSkewSnapshot;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.clock.ClockUtilsHelper;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.logging.ILogger;
import java.util.Date;
import java.util.Observable;

class MetricAggregator
extends Observable
implements IAgentRunnable {
    private static final int minTimeBetweenAggregationInMillis = 15000;
    private static final long METRIC_TIMESTAMP_ADJUSTMENT_FACTOR = 60000L;
    private final MetricGenerationService mgs;
    private long lastAggregatedTime = Long.MIN_VALUE;
    private ControllerTimeSkewSnapshot cachedSkewSnapshot = null;

    MetricAggregator(MetricGenerationService mgs) {
        this.mgs = mgs;
        this.cachedSkewSnapshot = mgs.getSkewHandler().getTimeSkewSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ILogger mgsLogger = this.mgs.getLogger();
        if (this.mgs.isBlockMetricDataAggregation()) {
            mgsLogger.trace("MetricGenerationService is disabled");
            return;
        }
        if (!this.mgs.isMetricDataAggregation()) {
            mgsLogger.debug("Metric aggregation is disabled");
            return;
        }
        if (ClockUtils.getCurrentTime() < this.lastAggregatedTime + 15000L) {
            return;
        }
        ControllerTimeSkewSnapshot oldSnapshot = this.cachedSkewSnapshot;
        ControllerTimeSkewSnapshot latestSnapshot = this.mgs.getSkewHandler().getTimeSkewSnapshot();
        try {
            long currentTime;
            this.setChanged();
            this.notifyObservers(MetricGenerationService.METRIC_AGGREGATOR_RUN_BEGIN);
            RawMetrics metrics = this.mgs.getMetricAggregatorFactory().aggregateAll(0, mgsLogger);
            this.lastAggregatedTime = currentTime = ClockUtils.getCurrentTime();
            long skewAdjustedTimesliceStartTimestamp = this.cachedSkewSnapshot.adjustForSkew(currentTime);
            Date timestamp = ClockUtilsHelper.getDateRoundedToMinute((long)(skewAdjustedTimesliceStartTimestamp -= 60000L));
            if (mgsLogger.isDebugEnabled()) {
                mgsLogger.debug("Running Metric Aggregator at agent time: " + ClockUtils.getFormattedTime() + " metric timestamp: " + timestamp + " current time: " + currentTime + " skewed current time: " + skewAdjustedTimesliceStartTimestamp);
            }
            if (mgsLogger.isTraceEnabled()) {
                mgsLogger.trace("MetricAggregator :: Putting " + metrics.getRegisteredMetrics().length + " registered metrics and " + metrics.getUnregisteredMetrics().length + " unregistered metrics to publish queue for the timeslice.");
            }
            this.mgs.getMetricReporter().collectMetrics(new MetricsForTimeslice(timestamp, metrics));
        }
        catch (Throwable e) {
            mgsLogger.error("Error aggregating metrics", e);
        }
        finally {
            this.setChanged();
            this.notifyObservers(MetricGenerationService.METRIC_AGGREGATOR_RUN_END);
            if (!oldSnapshot.equals(latestSnapshot)) {
                this.cachedSkewSnapshot = latestSnapshot;
                this.mgs.rescheduleAggregatorTask(latestSnapshot);
            }
        }
    }

    protected void clearLastAggregatedTime() {
        this.lastAggregatedTime = Long.MIN_VALUE;
    }
}

