/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.eventgeneration;

import com.singularity.ee.agent.commonservices.eventgeneration.EventGenerationServiceHelper;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.eventgeneration.events.EventsForTimeslice;
import com.singularity.ee.agent.commonservices.eventgeneration.events.IEventSubscriber;
import com.singularity.ee.agent.commonservices.eventgeneration.events.InternalEventGenerator;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.ControllerTimeSkewSnapshot;
import com.singularity.ee.agent.commonservices.timeskewhandling.spi.IControllerTimeSkewHandler;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.events.AgentEventData;
import com.singularity.ee.events.BTEventData;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.clock.ClockUtilsHelper;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.collections.ILinkedList;
import com.singularity.ee.util.collections.LinkedListImpl;
import com.singularity.ee.util.collections.bounded.SharedBoundedArrayList;
import com.singularity.ee.util.collections.bounded.SharedBoundedConcurrentLinkedQueue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.collections.ADConcurrentHashMap;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.AgentTimeUnit;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import com.singularity.ee.util.spi.IAgentScheduledFuture;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventGenerationService
implements IEventGenerationService {
    private final IADLogger logger;
    private final IADLogger infrequentLogger;
    private static final int MAX_EVENT_SIZE_FOR_TIMESLICE = 100;
    private static final int MAX_EVENT_SIZE_FOR_BT_FOR_TIMESLICE = 20;
    private static final String EVENT_CAP_REACHED_KEY = "eventLimitReached";
    private final ConcurrentLinkedQueue<AgentEventData> applicationEvents = new SharedBoundedConcurrentLinkedQueue(500);
    private final ADConcurrentHashMap<Long, IAgentAtomicInteger> btCounter = new ADConcurrentHashMap();
    private final ConcurrentLinkedQueue<BTEventData> btEvents = new SharedBoundedConcurrentLinkedQueue(500);
    private final ConcurrentLinkedQueue<MachineEventData> machineEvents = new SharedBoundedConcurrentLinkedQueue(500);
    private int maxEventSize;
    private int maxBTEventSize;
    private final InternalEventGenerator internalEventGenerator;
    private IEventSubscriber eventSubscriber;
    private final IControllerTimeSkewHandler skewHandler;
    private volatile boolean blockEventGeneration;
    private static final int MAX_TIMESLICES_TO_RETAIN_AND_RETRY = 5;
    private final ILinkedList<EventsForTimeslice> retentionQueue;
    private final EventPublisher eventPublisher;
    private final IAgentScheduledFuture eventPublisherFuture;

    public EventGenerationService(IADLogger logger, int publishFrequency, IAgentScheduledExecutorService scheduler, IControllerTimeSkewHandler skewHandler) {
        this(logger, -1, publishFrequency, scheduler, skewHandler);
    }

    public EventGenerationService(IADLogger logger, int maxEventSize, int publishFrequency, IAgentScheduledExecutorService scheduler, IControllerTimeSkewHandler skewHandler) {
        this.logger = logger;
        this.infrequentLogger = ADLoggerFactory.getRateLimitLogger(logger, 5, 60000L);
        this.skewHandler = skewHandler;
        this.maxEventSize = maxEventSize <= 0 ? SystemUtilsTranslateable.getIntProperty((String)"appdynamics.agent.maxEvents", (int)100) : maxEventSize;
        this.maxBTEventSize = 20;
        this.eventPublisher = new EventPublisher(this);
        this.eventPublisherFuture = scheduler.scheduleWithFixedDelay((IAgentRunnable)this.eventPublisher, (long)publishFrequency, (long)publishFrequency, AgentTimeUnit.MILLISECONDS);
        this.internalEventGenerator = new InternalEventGenerator(this);
        this.retentionQueue = new LinkedListImpl();
        if (logger.isDebugEnabled()) {
            logger.debug("Started Event Service Publish Frequency [" + publishFrequency + "], and max event size [" + maxEventSize + "]");
        }
    }

    @Override
    public void setEventSubscriber(IEventSubscriber eventSubscriber) {
        this.eventSubscriber = eventSubscriber;
    }

    @Override
    public void hotDisable() {
        this.blockEventGeneration = true;
        this.clearEventQueues();
    }

    @Override
    public void hotEnable() {
        this.blockEventGeneration = false;
    }

    private void clearEventQueues() {
        this.btEvents.clear();
        this.machineEvents.clear();
        this.applicationEvents.clear();
        this.btCounter.clear();
    }

    private int getTotalEventSize() {
        return CollectionHelper.queueSize(this.applicationEvents) + CollectionHelper.queueSize(this.btEvents) + CollectionHelper.queueSize(this.machineEvents);
    }

    @Override
    public int getMaxEventSize() {
        return this.maxEventSize;
    }

    @Override
    public void setMaxEventSize(int maxEventSize) {
        this.maxEventSize = maxEventSize;
    }

    @Override
    public int getMaxBTEventSize() {
        return this.maxBTEventSize;
    }

    @Override
    public void setMaxBTEventSize(int maxBTEventSize) {
        this.maxBTEventSize = maxBTEventSize;
    }

    @Override
    public boolean isEventQueueLimitReached() {
        return this.getTotalEventSize() > this.maxEventSize;
    }

    @Override
    public boolean isBTEventQueueLimitReached(long btID) {
        return this.getEventSizeForBT(btID).get() > this.maxBTEventSize;
    }

    @Override
    public InternalEventGenerator getInternalEventGenerator() {
        return this.internalEventGenerator;
    }

    private IAgentAtomicInteger getEventSizeForBT(long btID) {
        IAgentAtomicInteger size = (IAgentAtomicInteger)this.btCounter.get((Object)btID);
        if (size == null) {
            size = new AgentAtomicIntegerImpl(0);
            this.btCounter.put((Object)btID, (Object)size);
        }
        return size;
    }

    @Override
    public void addApplicationEventIgnoreLimits(AgentEventData agentEventData) {
        if (this.blockEventGeneration) {
            return;
        }
        this.applicationEvents.add(agentEventData);
    }

    @Override
    public void addApplicationEvent(AgentEventData agentEventData) {
        if (this.blockEventGeneration) {
            return;
        }
        if (this.getTotalEventSize() > this.maxEventSize) {
            this.infrequentLogger.warn("Dropping event as size exceeded the max events size for the timeslice [" + this.maxEventSize + "]");
            this.throwEventCapReachedEvent();
            return;
        }
        this.applicationEvents.add(agentEventData);
    }

    @Override
    public void addBTEventIgnoreLimits(long btID, BTEventData btEvent) {
        if (this.blockEventGeneration) {
            return;
        }
        this.btEvents.add(btEvent);
    }

    @Override
    public void addBTEvent(long btID, BTEventData btEvent) {
        if (this.blockEventGeneration) {
            return;
        }
        if (this.getTotalEventSize() > this.maxEventSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping event as size exceeded the max events size for the timeslice [" + this.maxEventSize + "]");
            }
            this.throwEventCapReachedEvent();
            return;
        }
        IAgentAtomicInteger eventSize = this.getEventSizeForBT(btID);
        if (eventSize.get() > this.maxBTEventSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Dropping event as size exceeded the max events size for the BT in this timeslice [" + this.maxBTEventSize + "]");
            }
            return;
        }
        eventSize.incrementAndGet();
        this.btEvents.add(btEvent);
    }

    @Override
    public void addMachineEvent(MachineEventData machineEventData) {
        if (this.blockEventGeneration) {
            return;
        }
        if (this.getTotalEventSize() > this.maxEventSize) {
            this.infrequentLogger.warn("Dropping event as size exceeded the max events size for the timeslice [" + this.maxEventSize + "]");
            this.throwEventCapReachedEvent();
            return;
        }
        this.machineEvents.add(machineEventData);
    }

    @Override
    public void throwEventCapReachedEvent() {
        if (this.internalEventGenerator.lastEventTimedOut(EVENT_CAP_REACHED_KEY)) {
            String EVENT_CAP_REACHED = "The limit of [" + this.maxEventSize + "] events/min for processing/sending events has been reached on this node.";
            this.logger.info("Sending event-cap-reached event as size exceeded the max events size for the timeslice [" + this.maxEventSize + "]");
            this.internalEventGenerator.throwCappedInternalEvent(EVENT_CAP_REACHED_KEY, EVENT_CAP_REACHED, null);
        }
    }

    @Override
    public void flush() {
        if (this.getTotalEventSize() > 0) {
            this.logger.info("Cancelling event publishing future before shutdown.");
            if (this.eventPublisherFuture.cancel(2000)) {
                this.logger.info("Flushing events");
                this.eventPublisher.run();
            } else {
                this.logger.warn("Wasn't able to send events before shutting down");
            }
        } else {
            this.logger.info("No events to flush.");
            this.eventPublisherFuture.cancel(false);
        }
    }

    static class EventPublisher
    implements IAgentRunnable {
        private final EventGenerationService egs;

        EventPublisher(EventGenerationService egs) {
            this.egs = egs;
        }

        public void run() {
            try {
                ControllerTimeSkewSnapshot timeSkewSnapshot = this.egs.skewHandler.getTimeSkewSnapshot();
                long timesliceEndTimestamp = timeSkewSnapshot.adjustForSkew(ClockUtils.getCurrentTime());
                Date timestamp = ClockUtilsHelper.getDateRoundedToMinute((long)timesliceEndTimestamp);
                if (this.egs.logger.isTraceEnabled()) {
                    this.egs.logger.trace("Publishing " + this.egs.getTotalEventSize() + " events for the timeslice.");
                }
                EventsForTimeslice eventsForTimeslice = new EventsForTimeslice(timestamp);
                if (!this.egs.applicationEvents.isEmpty()) {
                    SharedBoundedArrayList appEvents = new SharedBoundedArrayList(500);
                    EventGenerationServiceHelper.addToList(appEvents, this.egs.applicationEvents);
                    if (this.egs.logger.isDebugEnabled()) {
                        this.egs.logger.debug("Publishing " + appEvents.size() + " Application events for the timeslice.");
                    }
                    this.adjustEventDataTimeStampWithSkew((List<? extends AgentEventData>)appEvents, timeSkewSnapshot);
                    eventsForTimeslice.setApplicationEvents((List<AgentEventData>)appEvents);
                    this.egs.applicationEvents.clear();
                }
                if (!this.egs.btEvents.isEmpty()) {
                    SharedBoundedArrayList btEventList = new SharedBoundedArrayList(500);
                    EventGenerationServiceHelper.addToList(btEventList, this.egs.btEvents);
                    if (this.egs.logger.isDebugEnabled()) {
                        this.egs.logger.debug("Publishing " + btEventList.size() + " BT events for the timeslice.");
                    }
                    this.adjustEventDataTimeStampWithSkew((List<? extends AgentEventData>)btEventList, timeSkewSnapshot);
                    eventsForTimeslice.setBtEvents((List<BTEventData>)btEventList);
                    this.egs.btEvents.clear();
                    this.egs.btCounter.clear();
                }
                if (!this.egs.machineEvents.isEmpty()) {
                    SharedBoundedArrayList machineEventList = new SharedBoundedArrayList(500);
                    EventGenerationServiceHelper.addToList(machineEventList, this.egs.machineEvents);
                    if (this.egs.logger.isDebugEnabled()) {
                        this.egs.logger.debug("Publishing " + machineEventList.size() + " machine events for the timeslice.");
                    }
                    this.adjustEventDataTimeStampWithSkew((List<? extends AgentEventData>)machineEventList, timeSkewSnapshot);
                    eventsForTimeslice.setMachineEvents((List<MachineEventData>)machineEventList);
                    this.egs.machineEvents.clear();
                }
                if (this.egs.retentionQueue.size() >= 5) {
                    EventsForTimeslice evts = (EventsForTimeslice)this.egs.retentionQueue.poll();
                    this.egs.logger.warn("The retention queue is at full capacity [5]. Dropping events for timeslice [" + evts.getTimesliceEndTimestamp() + "] to accomodate events for timeslice [" + eventsForTimeslice.getTimesliceEndTimestamp() + "]");
                }
                this.egs.retentionQueue.offer((Object)eventsForTimeslice);
                while (!this.egs.retentionQueue.isEmpty()) {
                    EventsForTimeslice events = (EventsForTimeslice)this.egs.retentionQueue.peek();
                    boolean success = this.egs.eventSubscriber.publish(events);
                    if (success) {
                        this.egs.retentionQueue.poll();
                        continue;
                    }
                    if (this.egs.eventSubscriber.isReady()) {
                        this.egs.logger.warn("Failed to send events for timeslice [" + events.getTimesliceEndTimestamp() + "]. The agent will try to resend the events again during the next 1 min window.");
                    }
                    return;
                }
            }
            catch (Throwable e) {
                this.egs.logger.warn("Error publishing events", e);
            }
        }

        private void adjustEventDataTimeStampWithSkew(List<? extends AgentEventData> allEventData, ControllerTimeSkewSnapshot timeSkewSnapshot) {
            if (timeSkewSnapshot.isTimeSkewed) {
                for (AgentEventData agentEventData : allEventData) {
                    long skewAdjustedTimestamp = timeSkewSnapshot.adjustForSkew(agentEventData.getTimestamp());
                    agentEventData.setTimestamp(skewAdjustedTimestamp);
                    if (agentEventData.getEndTime() <= 0L) continue;
                    long skewAdjustedEndTime = timeSkewSnapshot.adjustForSkew(agentEventData.getEndTime());
                    agentEventData.setEndTime(skewAdjustedEndTime);
                }
            }
        }
    }
}

