/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.controller;

import com.singularity.ee.agent.AgentAccountInfoStore;
import com.singularity.ee.rest.RESTRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;
import java.util.HashMap;

public class JavaAgentReverseProxyUtil {
    public static final String REVERSE_PROXY_ENABLED = "appdynamics.reverse.proxy.enabled";
    public static final String APPDYNAMICS_REVERSE_PROXY_ENABLED_ENV_VAR = "APPDYNAMICS_REVERSE_PROXY_ENABLED";
    private static final String AUTH_HOST_HEADER_SUFFIX = ".appdynamics.com";
    private static final String CUSTOMER_HOST_SAAS_APPD_TEST = ".saas.appd-test.com";
    private static final String CUSTOMER_HOST_SAAS_APPD_PROD = ".saas.appdynamics.com";
    private static final String CUSTOMER_HOST_SAAS_APPD_PROD_INTERNAL = ".appd-int.com";
    private static final String HOST_HEADER = "Host";
    private static Boolean reverseProxyEnabled = null;
    private static String[] customerHostSaasMarkers = new String[]{".saas.appdynamics.com", ".appd-int.com", ".saas.appd-test.com"};

    private static boolean isReverseProxyEnabled(String controllerHost) {
        String controllerHostname = controllerHost;
        for (String marker : customerHostSaasMarkers) {
            if (!controllerHostname.contains(marker)) continue;
            return false;
        }
        return true;
    }

    public static void setReverseProxyConfiguration(Boolean bool) {
        reverseProxyEnabled = bool;
    }

    private static boolean checkReverseProxyEnabled(ILogger logger) {
        if (reverseProxyEnabled == null) {
            String envVarValue = SystemUtils.getenv((String)APPDYNAMICS_REVERSE_PROXY_ENABLED_ENV_VAR);
            if (envVarValue != null) {
                logger.debug("Found env variable [APPDYNAMICS_REVERSE_PROXY_ENABLED] equals " + envVarValue);
                reverseProxyEnabled = Boolean.parseBoolean(envVarValue);
            }
            reverseProxyEnabled = Boolean.getBoolean(REVERSE_PROXY_ENABLED);
        }
        return reverseProxyEnabled != false;
    }

    protected static void checkAndAddReverseProxyConfiguration(RESTRequest request, String controllerHost, ILogger logger) {
        if (JavaAgentReverseProxyUtil.isReverseProxyEnabled(controllerHost) && JavaAgentReverseProxyUtil.checkReverseProxyEnabled(logger)) {
            HashMap<String, Object> configRequestPayload = request.getPayload();
            if (configRequestPayload == null) {
                configRequestPayload = new HashMap<String, Object>();
            }
            Object reverseProxyHeader = JavaAgentReverseProxyUtil.getReverseProxyHeader(AgentAccountInfoStore.getInstance().getAccountName());
            configRequestPayload.put(HOST_HEADER, reverseProxyHeader);
            logger.debug("Reverse Proxy Enabled, Added host header : " + reverseProxyHeader);
        } else {
            logger.debug("To enable reverse proxy, use the node property or set env/system variables");
        }
    }

    private static Object getReverseProxyHeader(String accountName) {
        String hostHeader = accountName + AUTH_HOST_HEADER_SUFFIX;
        return hostHeader;
    }
}

