/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel.controller;

import com.singularity.ee.agent.appagent.kernel.AgentProperties;
import com.singularity.ee.agent.appagent.kernel.controller.JavaAgentReverseProxyUtil;
import com.singularity.ee.agent.appagent.kernel.nonboot.spi.IAgentRESTRequestFactory;
import com.singularity.ee.agent.commonservices.IResponsePiggyBackObjectHandler;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.events.ResponsePiggyBackObject;
import com.singularity.ee.rest.RESTRequest;
import com.singularity.ee.rest.ResponseReadException;
import com.singularity.ee.rest.controller.request.AppAgentConfigurationBinaryRequest;
import com.singularity.ee.rest.controller.request.AppAgentNodeNameRequest;
import com.singularity.ee.rest.controller.request.BTRegistrationBinaryRequest;
import com.singularity.ee.rest.controller.request.EventDataRequest;
import com.singularity.ee.rest.controller.request.FileUploadRequest;
import com.singularity.ee.rest.controller.request.GetCurrentTimeRequest;
import com.singularity.ee.rest.controller.request.MarkNodeHistoricalRequest;
import com.singularity.ee.rest.controller.request.MetricDataBinaryRequest;
import com.singularity.ee.rest.controller.request.MetricRegistrationRequest;
import com.singularity.ee.rest.controller.request.SnapshotDataBinaryRequest;
import com.singularity.ee.rest.controller.request.SystemAgentRegistrationRequest;
import com.singularity.ee.rest.controller.request.SystemAgentReregistrationRequest;
import com.singularity.ee.rest.controller.request.TopSummaryStatsBinaryRequest;
import com.singularity.ee.rest.controller.request.TransientEventDataRequest;
import com.singularity.ee.rest.controller.request.spi.IAgentRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentConfigurationRequest;
import com.singularity.ee.rest.controller.request.spi.IAppAgentNodeNameRequest;
import com.singularity.ee.rest.controller.request.spi.IBTRegistrationRequest;
import com.singularity.ee.rest.controller.request.spi.IEventDataRequest;
import com.singularity.ee.rest.controller.request.spi.IFileUploadRequest;
import com.singularity.ee.rest.controller.request.spi.IMetricDataRequest;
import com.singularity.ee.rest.controller.request.spi.IMetricRegistrationRequest;
import com.singularity.ee.rest.controller.request.spi.IMultiAppAppWideConfigurationRequest;
import com.singularity.ee.rest.controller.request.spi.ISnapshotDataRequest;
import com.singularity.ee.rest.controller.request.spi.ISystemAgentRegistrationRequest;
import com.singularity.ee.rest.controller.request.spi.ISystemAgentReregistrationRequest;
import com.singularity.ee.rest.controller.request.spi.ITransientEventDataRequest;
import com.singularity.ee.rest.controller.request.spi.controller.ITopSummaryStatsControllerRequest;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class JavaAgentRESTRequestFactory
implements IAgentRESTRequestFactory {
    private ConcurrentLinkedQueue<IResponsePiggyBackObjectHandler> piggyBackObjectHandlers = new ConcurrentLinkedQueue();
    private static final int BAD_RESPONSE_MAX_WARNINGS = 5;
    private int numBadResponseWarningsIssued = 0;
    private final Map<String, Boolean> agentSupportedFeatures = new HashMap<String, Boolean>();

    public JavaAgentRESTRequestFactory() {
        this.agentSupportedFeatures.put("backend-config-v2", true);
        this.agentSupportedFeatures.put("transaction-match-point-config-v2", true);
    }

    @Override
    public IAppAgentNodeNameRequest getAppAgentNodeNameRequest(String controllerHost, int port, String machineId, ILogger logger) {
        AppAgentNodeNameRequest configRequest = new AppAgentNodeNameRequest(logger, controllerHost, port, machineId);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public IAppAgentNodeNameRequest getAppAgentNodeNameResponse(IHttpExecutionResponse response, ILogger iLogger) {
        return new AppAgentNodeNameRequest(response, iLogger);
    }

    @Override
    public IAppAgentConfigurationRequest getAppAgentConfigurationRequest(String controllerHost, int port, String machineId, ILogger logger) {
        AppAgentConfigurationBinaryRequest configRequest = new AppAgentConfigurationBinaryRequest(logger, controllerHost, port, machineId);
        configRequest.setAgentType(AgentProperties.getInstance().getAgentType());
        configRequest.addOrUpdateSupportedFeatures(this.agentSupportedFeatures);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public IMetricRegistrationRequest getMetricRegistrationRequest(String controllerHost, int port, String machineId, ILogger logger) {
        MetricRegistrationRequest configRequest = new MetricRegistrationRequest(logger, controllerHost, port, machineId);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public IMetricDataRequest getMetricDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        MetricDataBinaryRequest configRequest = new MetricDataBinaryRequest(controllerHost, port, machineId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public IBTRegistrationRequest getBTRegistrationRequest(String controllerHost, int port, String machineId, ILogger logger) {
        BTRegistrationBinaryRequest configRequest = new BTRegistrationBinaryRequest(logger, controllerHost, port, machineId);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public ISnapshotDataRequest getSnapshotDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        SnapshotDataBinaryRequest configRequest = new SnapshotDataBinaryRequest(logger, controllerHost, port, machineId);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public IEventDataRequest getEventDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        EventDataRequest configRequest = new EventDataRequest(controllerHost, port, machineId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public ITransientEventDataRequest getTransientEventDataRequest(String controllerHost, int port, String machineId, ILogger logger) {
        TransientEventDataRequest configRequest = new TransientEventDataRequest(controllerHost, port, machineId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public ISystemAgentRegistrationRequest getSystemAgentRegistrationRequest(String controllerHost, int port, ILogger logger) {
        SystemAgentRegistrationRequest configRequest = new SystemAgentRegistrationRequest(controllerHost, port, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public ISystemAgentReregistrationRequest getSystemAgentReregistrationRequest(String controllerHost, int port, String machineId, ILogger logger) {
        SystemAgentReregistrationRequest configRequest = new SystemAgentReregistrationRequest(controllerHost, port, machineId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    @Override
    public ISystemAgentReregistrationRequest getSystemAgentReregistrationRequest(String controllerHost, int port, String machineId, String agentId, ILogger logger) {
        SystemAgentReregistrationRequest configRequest = new SystemAgentReregistrationRequest(controllerHost, port, machineId, agentId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    public static GetCurrentTimeRequest getCurrentTimeRequest(String controllerHost, int port, String machineId, ILogger logger) {
        GetCurrentTimeRequest configRequest = new GetCurrentTimeRequest(controllerHost, port, machineId, logger);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    public static GetCurrentTimeRequest getCurrentTimeResponse(String responseBody, ILogger logger) throws ResponseReadException {
        return new GetCurrentTimeRequest(responseBody, logger);
    }

    @Override
    public IAppAgentConfigurationRequest getAppAgentConfigurationResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return (IAppAgentConfigurationRequest)this.getResponseObj(AppAgentConfigurationBinaryRequest.class, response, logger);
    }

    @Override
    public IMetricRegistrationRequest getMetricRegistrationResponse(String responseBody, ILogger logger) throws ResponseReadException {
        return new MetricRegistrationRequest(responseBody, logger);
    }

    @Override
    public IMetricDataRequest getMetricDataResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return (IMetricDataRequest)this.getResponseObj(MetricDataBinaryRequest.class, response, logger);
    }

    @Override
    public IBTRegistrationRequest getBTRegistrationResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return (IBTRegistrationRequest)this.getResponseObj(BTRegistrationBinaryRequest.class, response, logger);
    }

    @Override
    public ISnapshotDataRequest getSnapshotDataResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return (ISnapshotDataRequest)this.getResponseObj(SnapshotDataBinaryRequest.class, response, logger);
    }

    @Override
    public IEventDataRequest getEventDataResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return (IEventDataRequest)this.getResponseObj(EventDataRequest.class, response, logger);
    }

    @Override
    public ITransientEventDataRequest getTransientEventDataResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return new TransientEventDataRequest(response, logger);
    }

    @Override
    public ISystemAgentRegistrationRequest getSystemAgentRegistrationResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return new SystemAgentRegistrationRequest(response.getResponseBody(), logger);
    }

    @Override
    public ISystemAgentReregistrationRequest getSystemAgentReregistrationResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return new SystemAgentReregistrationRequest(response.getResponseBody(), logger);
    }

    @Override
    public IFileUploadRequest getFileUploadRequest(String controllerHost, int port, String machineId, ILogger logger, List<NameValuePair> paramsList) {
        FileUploadRequest configRequest = new FileUploadRequest(controllerHost, port, machineId, logger, paramsList);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    public ITopSummaryStatsControllerRequest getTopSummaryStatsControllerRequest(ILogger logger, String controllerHost, int port, String machineId) {
        TopSummaryStatsBinaryRequest configRequest = new TopSummaryStatsBinaryRequest(logger, controllerHost, port, machineId);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }

    public ITopSummaryStatsControllerRequest getTopSummaryStatsControllerResponse(IHttpExecutionResponse response, ILogger logger) throws ResponseReadException {
        return new TopSummaryStatsBinaryRequest(response, logger);
    }

    @Override
    public void registerResponsePiggyBackObjectHandler(IResponsePiggyBackObjectHandler piggyBackObjectHandler) {
        this.piggyBackObjectHandlers.add(piggyBackObjectHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResponseObj(Class responseClz, IHttpExecutionResponse response, ILogger logger) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader agentClassLoader = JavaAgentRESTRequestFactory.class.getClassLoader();
        logger.debug("Setting AgentClassLoader as Context ClassLoader");
        Thread.currentThread().setContextClassLoader(agentClassLoader);
        try {
            Constructor ctor = responseClz.getConstructor(IHttpExecutionResponse.class, ILogger.class);
            Object responseObj = ctor.newInstance(response, logger);
            this.numBadResponseWarningsIssued = 0;
            ResponsePiggyBackObject responsePiggyBackObject = ((IAgentRequest)responseObj).getPiggyBackObject();
            if (null != responsePiggyBackObject) {
                if (logger.isDebugEnabled()) {
                    logger.debug("received piggyback from [" + responseClz + "]");
                }
                this.handlePiggyBackObject(responsePiggyBackObject);
            }
            Object t = responseObj;
            return t;
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof ResponseReadException) {
                if (this.numBadResponseWarningsIssued++ < 5) {
                    logger.warn("ResponseReadException creating Response Wrapper [" + responseClz.getSimpleName() + "], : " + t.toString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(t.toString(), t);
                }
            } else {
                logger.error("Error creating Response Wrapper [" + responseClz.getSimpleName() + "], : ", (Throwable)ite);
            }
        }
        catch (Throwable e) {
            logger.error("Error creating Response Wrapper [" + responseClz.getSimpleName() + "], : ", e);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Restoring Context ClassLoader to " + originalClassLoader);
            }
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    private void handlePiggyBackObject(ResponsePiggyBackObject responsePiggyBackObject) {
        Iterator<IResponsePiggyBackObjectHandler> it = this.piggyBackObjectHandlers.iterator();
        while (it.hasNext()) {
            it.next().handleResponsePiggyBackObject(responsePiggyBackObject);
        }
    }

    @Override
    public IMultiAppAppWideConfigurationRequest getMultiAppAppWideConfigurationRequest(String controllerHost, int controllerPort, String machineId, ILogger logger) {
        throw new UnsupportedOperationException("Java agent does not support getMultiAppAppWideConfigurationRequest");
    }

    @Override
    public IMultiAppAppWideConfigurationRequest getMultiAppAppWideConfigurationResponse(IHttpExecutionResponse response, ILogger logger) {
        throw new UnsupportedOperationException("Java agent does not support getMultiAppAppWideConfigurationResponse");
    }

    @Override
    public MarkNodeHistoricalRequest getMarkNodeHistoricalRequest(String controllerHost, int controllerPort, String machineId, String nodeIdString, ILogger logger) {
        MarkNodeHistoricalRequest configRequest = new MarkNodeHistoricalRequest(controllerHost, controllerPort, machineId, logger, nodeIdString);
        JavaAgentReverseProxyUtil.checkAndAddReverseProxyConfiguration((RESTRequest)configRequest, controllerHost, logger);
        return configRequest;
    }
}

