/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.appagent.kernel;

import com.singularity.ee.agent.appagent.kernel.controller.JavaAgentRESTRequestFactory;
import com.singularity.ee.agent.appagent.kernel.nonboot.spi.IAgentRESTRequestFactory;

public final class AgentRestRequestFactory {
    private static IAgentRESTRequestFactory restRequestFactory;

    private AgentRestRequestFactory() {
    }

    private static void initialize() {
        String requestFactoryClass = System.getProperty("rest.request.factory.class");
        if (requestFactoryClass != null) {
            try {
                Class<?> c = Class.forName(requestFactoryClass);
                restRequestFactory = (IAgentRESTRequestFactory)c.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        if (restRequestFactory == null) {
            restRequestFactory = new JavaAgentRESTRequestFactory();
        }
    }

    public static IAgentRESTRequestFactory getAgentRESTRequestFactory() {
        return restRequestFactory;
    }

    public static void setAgentRESTRequestFactory(IAgentRESTRequestFactory requestFactory) {
        restRequestFactory = requestFactory;
    }

    public static void resetAgentRESTRequestFactory() {
        restRequestFactory = null;
        AgentRestRequestFactory.initialize();
    }

    static {
        AgentRestRequestFactory.initialize();
    }
}

