/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class OperatorFilter<T>
implements Observable.Operator<T, T> {
    final Func1<? super T, Boolean> predicate;

    public OperatorFilter(Func1<? super T, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onCompleted() {
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onNext(T t) {
                try {
                    if (OperatorFilter.this.predicate.call(t).booleanValue()) {
                        child.onNext(t);
                    } else {
                        this.request(1L);
                    }
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, child, t);
                }
            }
        };
    }
}

