/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.util.HashSet;
import java.util.List;
import rx.Observer;
import rx.SingleSubscriber;
import rx.annotations.Experimental;
import rx.exceptions.CompositeException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.exceptions.OnErrorThrowable;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException propagate(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)t;
        }
        if (t instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)t;
        }
        if (t instanceof StackOverflowError) {
            throw (StackOverflowError)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    public static void addCause(Throwable e, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e = e.getCause()).getCause())) break;
            seenCauses.add(e.getCause());
        }
        try {
            e.initCause(cause);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public static Throwable getFinalCause(Throwable e) {
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e = e.getCause();
        }
        return e;
    }

    public static void throwIfAny(List<? extends Throwable> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                Throwable t = exceptions.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            throw new CompositeException("Multiple exceptions", exceptions);
        }
    }

    @Experimental
    public static void throwOrReport(Throwable t, Observer<?> o, Object value) {
        Exceptions.throwIfFatal(t);
        o.onError(OnErrorThrowable.addValueAsLastCause(t, value));
    }

    @Experimental
    public static void throwOrReport(Throwable t, Observer<?> o) {
        Exceptions.throwIfFatal(t);
        o.onError(t);
    }

    @Experimental
    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> subscriber) {
        Exceptions.throwIfFatal(throwable);
        subscriber.onError(throwable);
    }
}

