/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.log.throttle;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.log.throttle.ThrottlingAppender;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.FileAppenderFactory;
import io.dropwizard.logging.common.async.AsyncAppenderFactory;
import io.dropwizard.logging.common.filter.LevelFilterFactory;
import io.dropwizard.logging.common.layout.LayoutFactory;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="throttle-file")
public class ThrottlingFileAppenderFactory
extends FileAppenderFactory<ILoggingEvent> {
    @JsonProperty
    private boolean throttleEnabled = true;
    @Min(value=1L)
    @JsonProperty
    private @Min(value=1L) int cacheSize = 100;
    @Min(value=1L)
    @JsonProperty
    private @Min(value=1L) int summaryThreshold = 1;
    @Min(value=100L)
    @JsonProperty
    private @Min(value=100L) int summaryWarnThreshold = 1000;
    @NotNull
    @JsonProperty
    private TimeUnitConfiguration throttleTime = new TimeUnitConfiguration(1L, TimeUnit.MINUTES);
    @NotNull
    @JsonProperty
    private Set<String> templateThrottledExceptions = Collections.emptySet();
    @JsonIgnore
    private final CopyOnWriteArrayList<WeakReference<ThrottlingAppender>> appenders = new CopyOnWriteArrayList();

    List<WeakReference<ThrottlingAppender>> getAppenders() {
        return this.appenders;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layoutFactory, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        Appender delegate = super.build(context, applicationName, layoutFactory, levelFilterFactory, asyncAppenderFactory);
        if (!this.throttleEnabled) {
            return delegate;
        }
        ThrottlingAppender throttlingAppender = new ThrottlingAppender((Appender<ILoggingEvent>)delegate, this.cacheSize, this.summaryThreshold, this.summaryWarnThreshold, this.throttleTime, this.templateThrottledExceptions);
        throttlingAppender.start();
        this.appenders.add(new WeakReference<ThrottlingAppender>(throttlingAppender));
        return throttlingAppender;
    }
}

