/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.log.throttle;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.Constants;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.log.throttle.LogThrottlingModuleConfiguration;
import com.appdynamics.common.util.log.throttle.ThrottlingAppender;
import com.appdynamics.common.util.log.throttle.ThrottlingFileAppenderFactory;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.dropwizard.logging.common.AppenderFactory;
import io.dropwizard.logging.common.DefaultLoggingFactory;
import io.dropwizard.logging.common.LoggingFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogThrottlingModule
extends Module<LogThrottlingModuleConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogThrottlingModule.class);
    private volatile ScheduledExecutorService executorService;
    private volatile LoggingFactory factory;

    @Inject
    void start(AppConfiguration appConfiguration) {
        ThreadFactory tf = new ThreadFactoryBuilder().setDaemon(true).setPriority(1).setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error(Constants.DO_NOT_THROTTLE, "Error occurred while flushing throttled messages", e);
            }
        }).setNameFormat("throttled-message-flush-thread-%d").build();
        this.executorService = Executors.newSingleThreadScheduledExecutor(tf);
        TimeUnitConfiguration flushTaskSchedule = ((LogThrottlingModuleConfiguration)this.getConfiguration()).getFlushTaskSchedule();
        this.factory = appConfiguration.getLoggingFactory();
        this.executorService.scheduleAtFixedRate(new FlushTask(), flushTaskSchedule.getTime(), flushTaskSchedule.getTime(), flushTaskSchedule.getTimeUnit());
    }

    private List<ThrottlingAppender> getThrottlingAppenders() {
        ArrayList<ThrottlingAppender> throttlingAppenders = new ArrayList<ThrottlingAppender>();
        for (AppenderFactory appenderFactory : ((DefaultLoggingFactory)this.factory).getAppenders()) {
            if (!(appenderFactory instanceof ThrottlingFileAppenderFactory)) continue;
            ThrottlingFileAppenderFactory taf = (ThrottlingFileAppenderFactory)appenderFactory;
            List<WeakReference<ThrottlingAppender>> appenderReferences = taf.getAppenders();
            for (WeakReference<ThrottlingAppender> weakReference : appenderReferences) {
                ThrottlingAppender appender = (ThrottlingAppender)((Object)weakReference.get());
                throttlingAppenders.add(appender);
            }
        }
        return throttlingAppenders;
    }

    @PreDestroy
    void stop() {
        ConcurrencyHelper.stop((ExecutorService)this.executorService, (Logger)log);
        List<ThrottlingAppender> throttlingAppenders = this.getThrottlingAppenders();
        for (ThrottlingAppender throttlingAppender : throttlingAppenders) {
            throttlingAppender.close();
        }
    }

    private class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        @Override
        public void run() {
            List<ThrottlingAppender> throttlingAppenders = LogThrottlingModule.this.getThrottlingAppenders();
            for (ThrottlingAppender throttlingAppender : throttlingAppenders) {
                throttlingAppender.flush();
            }
        }
    }
}

