/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.log.throttle;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import com.appdynamics.common.util.datetime.TimeUnitConfiguration;
import com.appdynamics.common.util.log.throttle.Throttler;
import com.appdynamics.common.util.log.throttle.ThrottlerKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Set;
import java.util.concurrent.atomic.AtomicStampedReference;
import lombok.Generated;

class DefaultThrottler
implements Throttler {
    static final int MAX_MESSAGE_LENGTH = 1024;
    static final int MAX_STACK_TRACE_LENGTH = 4096;
    static final String SHORTENING_MESSAGE = " This is a shortened version of the original message.";
    private static final int SHORTENING_MESSAGE_LENGTH = " This is a shortened version of the original message.".length();
    private static final String AFFIX_SEPARATOR = "....";
    private static final int AFFIX_SEPARATOR_LENGTH = "....".length();
    private static final int MESSAGE_COMBINED_AFFIXES_LENGTH = 1024 - AFFIX_SEPARATOR_LENGTH;
    private static final int MESSAGE_PREFIX_LENGTH = MESSAGE_COMBINED_AFFIXES_LENGTH / 2;
    private static final int MESSAGE_SUFFIX_LENGTH = MESSAGE_COMBINED_AFFIXES_LENGTH - MESSAGE_PREFIX_LENGTH;
    private static final int STACK_TRACE_COMBINED_AFFIXES_LENGTH = 4096 - AFFIX_SEPARATOR_LENGTH;
    private static final int STACK_TRACE_PREFIX_LENGTH = STACK_TRACE_COMBINED_AFFIXES_LENGTH / 4;
    private static final int STACK_TRACE_SUFFIX_LENGTH = STACK_TRACE_COMBINED_AFFIXES_LENGTH - STACK_TRACE_PREFIX_LENGTH;
    private static final int RETRY_LIMIT = 5;
    private final Appender<ILoggingEvent> delegate;
    private final LoadingCache<ThrottlerKey, AtomicStampedReference<EntryState>> cache;
    private final int summaryThreshold;
    private final int summaryWarnThreshold;
    private final ExtendedThrowableProxyConverter converter;
    private final Set<String> templateThrottledExceptions;

    DefaultThrottler(Appender<ILoggingEvent> delegate, int cacheSize, int summaryThreshold, int summaryWarnThreshold, TimeUnitConfiguration throttleDuration, Set<String> templateThrottledExceptions) {
        this(delegate, (CacheBuilder<Object, Object>)CacheBuilder.newBuilder(), cacheSize, summaryThreshold, summaryWarnThreshold, throttleDuration, templateThrottledExceptions);
    }

    DefaultThrottler(Appender<ILoggingEvent> delegate, CacheBuilder<Object, Object> builder, int cacheSize, int summaryThreshold, int summaryWarnThreshold, TimeUnitConfiguration throttleDuration, Set<String> templateThrottledExceptions) {
        this.delegate = delegate;
        this.cache = builder.maximumSize((long)cacheSize).expireAfterWrite(throttleDuration.getTime(), throttleDuration.getTimeUnit()).removalListener((RemovalListener)new CacheRemovalListener()).build((CacheLoader)new CacheLoader<ThrottlerKey, AtomicStampedReference<EntryState>>(){

            public AtomicStampedReference<EntryState> load(ThrottlerKey key) {
                return new AtomicStampedReference<EntryState>(EntryState.VALID, 0);
            }
        });
        this.summaryThreshold = summaryThreshold;
        this.summaryWarnThreshold = summaryWarnThreshold;
        this.converter = new ExtendedThrowableProxyConverter();
        this.converter.start();
        this.templateThrottledExceptions = templateThrottledExceptions;
    }

    @Override
    public void throttle(ILoggingEvent loggingEvent) {
        int retryCount;
        ThrottlerKey key = this.buildThrottlerKey(loggingEvent);
        AtomicStampedReference stampedReference = (AtomicStampedReference)this.cache.getUnchecked((Object)key);
        int stamp = stampedReference.getStamp();
        for (retryCount = 0; retryCount < 5 && !stampedReference.compareAndSet(EntryState.VALID, EntryState.VALID, stamp, stamp + 1); ++retryCount) {
            stampedReference = (AtomicStampedReference)this.cache.getUnchecked((Object)key);
            stamp = stampedReference.getStamp();
        }
        if (stamp == 0 || retryCount == 5) {
            this.delegate.doAppend((Object)loggingEvent);
        }
    }

    @VisibleForTesting
    ThrottlerKey buildThrottlerKey(ILoggingEvent loggingEvent) {
        String className;
        Level level = loggingEvent.getLevel();
        String loggerName = loggingEvent.getLoggerName();
        IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
        String message = loggingEvent.getFormattedMessage();
        String stackTrace = this.converter.convert(loggingEvent);
        String msgToStoreInKey = message;
        String stackTraceToStoreInKey = stackTrace;
        boolean contentsShortened = false;
        if (message.length() > 1024) {
            msgToStoreInKey = DefaultThrottler.shortenMessage(message);
            contentsShortened = true;
        }
        if (stackTrace.length() > 4096) {
            stackTraceToStoreInKey = DefaultThrottler.shortenStackTrace(stackTrace);
            contentsShortened = true;
        }
        if (throwableProxy != null && this.templateThrottledExceptions.contains(className = throwableProxy.getClassName())) {
            String templateMessage;
            String templateMessageToStoreInKey = templateMessage = loggingEvent.getMessage();
            int templateMsgHash = 0;
            if (templateMessage.length() > 1024) {
                templateMsgHash = DefaultThrottler.calculateHash(templateMessage);
                templateMessageToStoreInKey = DefaultThrottler.shortenMessage(templateMessage);
                contentsShortened = true;
            }
            return new ThrottlerKey(level, loggerName, msgToStoreInKey, stackTraceToStoreInKey, templateMsgHash, contentsShortened, throwableProxy.getClassName(), templateMessageToStoreInKey);
        }
        int msgAndStackTraceHash = 0;
        if (contentsShortened) {
            msgAndStackTraceHash = DefaultThrottler.calculateHash(message, stackTrace);
        }
        return new ThrottlerKey(level, loggerName, msgToStoreInKey, stackTraceToStoreInKey, msgAndStackTraceHash, contentsShortened);
    }

    @VisibleForTesting
    static String shortenMessage(String message) {
        return DefaultThrottler.shortenString(message, MESSAGE_PREFIX_LENGTH, MESSAGE_SUFFIX_LENGTH, 1024);
    }

    @VisibleForTesting
    static String shortenStackTrace(String stackTrace) {
        return DefaultThrottler.shortenString(stackTrace, STACK_TRACE_PREFIX_LENGTH, STACK_TRACE_SUFFIX_LENGTH, 4096);
    }

    private static String shortenString(String str, int prefixLength, int suffixLength, int maxShortenedStringLength) {
        StringBuilder stringBuilder = new StringBuilder(maxShortenedStringLength);
        String prefix = str.substring(0, prefixLength);
        String suffix = str.substring(str.length() - suffixLength);
        return stringBuilder.append(prefix).append(AFFIX_SEPARATOR).append(suffix).toString();
    }

    private static int calculateHash(String str1, String str2) {
        int result = 17;
        result = 31 * result + DefaultThrottler.calculateHash(str1);
        result = 31 * result + DefaultThrottler.calculateHash(str2);
        return result;
    }

    private static int calculateHash(String str1) {
        return str1.hashCode();
    }

    @Override
    public void flush() {
        this.cache.cleanUp();
    }

    @Override
    public void close() {
        this.converter.stop();
        this.cache.invalidateAll();
        this.flush();
    }

    @Generated
    LoadingCache<ThrottlerKey, AtomicStampedReference<EntryState>> getCache() {
        return this.cache;
    }

    static {
        Preconditions.checkState((MESSAGE_COMBINED_AFFIXES_LENGTH + AFFIX_SEPARATOR_LENGTH == 1024 ? 1 : 0) != 0, (Object)"Message combined affixes length is not properly set");
        Preconditions.checkState((MESSAGE_PREFIX_LENGTH + MESSAGE_SUFFIX_LENGTH == MESSAGE_COMBINED_AFFIXES_LENGTH ? 1 : 0) != 0, (Object)"Message prefix and suffix lengths are not properly set");
        Preconditions.checkState((STACK_TRACE_COMBINED_AFFIXES_LENGTH + AFFIX_SEPARATOR_LENGTH == 4096 ? 1 : 0) != 0, (Object)"Stack trace combined affixes length is not properly set");
        Preconditions.checkState((STACK_TRACE_PREFIX_LENGTH + STACK_TRACE_SUFFIX_LENGTH == STACK_TRACE_COMBINED_AFFIXES_LENGTH ? 1 : 0) != 0, (Object)"Stack trace prefix and suffix lengths are not properly set");
    }

    private class CacheRemovalListener
    implements RemovalListener<ThrottlerKey, AtomicStampedReference<EntryState>> {
        private CacheRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ThrottlerKey, AtomicStampedReference<EntryState>> notification) {
            Object throttlingSummary;
            LoggingEvent event = new LoggingEvent();
            event.setTimeStamp(System.currentTimeMillis());
            ThrottlerKey key = (ThrottlerKey)notification.getKey();
            if (key == null) {
                event.setLoggerName(DefaultThrottler.class.getSimpleName());
                event.setLevel(Level.ERROR);
                event.setMessage("Key in removal notification is null. Cannot print statistics.");
                DefaultThrottler.this.delegate.doAppend((Object)event);
                return;
            }
            event.setLoggerName(key.getLoggerName());
            AtomicStampedReference value = (AtomicStampedReference)notification.getValue();
            if (value == null) {
                throttlingSummary = "Cannot get the throttled count for the following message : ";
                event.setLevel(key.getLevel());
            } else {
                int stamp = value.getStamp();
                while (!value.compareAndSet(EntryState.VALID, EntryState.INVALID, stamp, stamp)) {
                    stamp = value.getStamp();
                }
                int throttledCount = stamp - 1;
                if (throttledCount < DefaultThrottler.this.summaryThreshold) {
                    return;
                }
                String qualifier = key.getOptTemplateThrottlingQualifier();
                throttlingSummary = qualifier != null ? "Messages similar to the following were throttled [" + throttledCount + "] times: " : "This message was throttled [" + throttledCount + "] times: ";
                Level level = key.getLevel();
                if (throttledCount >= DefaultThrottler.this.summaryWarnThreshold && !level.isGreaterOrEqual(Level.WARN)) {
                    event.setLevel(Level.WARN);
                } else {
                    event.setLevel(level);
                }
            }
            String message = key.getMessage();
            String stackTrace = key.getExceptionStackTrace();
            boolean stackTraceNotEmpty = !stackTrace.isEmpty();
            boolean contentsShortened = key.isContentsShortened();
            int capacity = ((String)throttlingSummary).length() + message.length();
            if (stackTraceNotEmpty) {
                capacity = capacity + stackTrace.length() + 1;
            }
            if (contentsShortened) {
                capacity += SHORTENING_MESSAGE_LENGTH;
            }
            StringBuilder summaryAndMessageBuilder = new StringBuilder(capacity);
            summaryAndMessageBuilder.append((String)throttlingSummary).append(message);
            if (stackTraceNotEmpty) {
                summaryAndMessageBuilder.append("\n").append(stackTrace);
            }
            if (contentsShortened) {
                summaryAndMessageBuilder.append(DefaultThrottler.SHORTENING_MESSAGE);
            }
            event.setMessage(summaryAndMessageBuilder.toString());
            DefaultThrottler.this.delegate.doAppend((Object)event);
        }
    }

    static enum EntryState {
        VALID,
        INVALID;

    }
}

