/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.instrument.metrics.appd;

import com.appdynamics.common.util.instrument.metrics.Timer;
import com.appdynamics.common.util.instrument.metrics.TimerContext;
import com.appdynamics.common.util.instrument.metrics.appd.ADHistogram;
import com.codahale.metrics.Clock;
import java.util.concurrent.TimeUnit;

public class ADTimer
implements Timer {
    private final Clock clock;
    private final ADHistogram histogram;

    public ADTimer(String metricName) {
        this(metricName, Clock.defaultClock());
    }

    public ADTimer(String metricName, Clock clock) {
        this.clock = clock;
        this.histogram = new ADHistogram(metricName);
    }

    @Override
    public void record(long duration, TimeUnit timeUnit) {
        this.record(timeUnit.toMillis(duration));
    }

    private void record(long timeInMillis) {
        this.histogram.update(timeInMillis);
    }

    @Override
    public TimerContext time() {
        return new TimerContext(this, this.clock);
    }
}

