/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.instrument;

import com.appdynamics.common.util.instrument.ADMetric;
import com.appdynamics.sdk.ADAppAgent;
import com.appdynamics.sdk.NullADAppAgent;
import com.appdynamics.sdk.ReflectiveADAppAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ADMetricReporter {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(ADMetricReporter.class);
    private final ADAppAgent agent = this.createAppAgent();

    private ADAppAgent createAppAgent() {
        try {
            Class.forName("com.singularity.ee.agent.appagent.AgentEntryPoint");
        }
        catch (Exception ex) {
            this.log.warn("AgentEntryPoint class is not found. Reporting will be disabled");
            return new NullADAppAgent();
        }
        try {
            this.log.info("Retrying to enable reporting using the AD agent");
            return new ReflectiveADAppAgent(new ReflectiveADAppAgent.ErrorHandler(){

                public void reportingFailed(String message, Throwable ex) {
                    ADMetricReporter.this.log.debug(message, ex);
                }
            });
        }
        catch (ReflectiveADAppAgent.AgentConnectionException e) {
            this.log.warn("JVM is not instrumented with the AD Agent. Reporting will be disabled");
            return new NullADAppAgent();
        }
    }

    public void report(ADMetric metric, long measure) {
        this.agent.reportMetric(metric.name(), measure, metric.aggregationType(), metric.timeRollupType(), metric.clusterRollupType());
    }
}

