/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.PrecisionFormatter;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.core.setup.Environment;
import java.util.concurrent.TimeUnit;

public class TimerHealthCheck
extends SimpleHealthCheck {
    private final Timer timer;

    public TimerHealthCheck(String name, Environment environment) {
        super(name);
        this.timer = environment.metrics().timer(name);
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public HealthCheck.Result check() {
        Snapshot snapshot = this.timer.getSnapshot();
        String percentile50duration = this.nanoToSecondFormat(snapshot.getMedian());
        String percentile75duration = this.nanoToSecondFormat(snapshot.get75thPercentile());
        String percentile95duration = this.nanoToSecondFormat(snapshot.get95thPercentile());
        String percentile99duration = this.nanoToSecondFormat(snapshot.get99thPercentile());
        String meanDuration = this.nanoToSecondFormat(snapshot.getMean());
        String count = PrecisionFormatter.format(this.timer.getCount());
        String message = String.format("Duration in seconds percentile distribution, 50%%: [%s], 75%%: [%s], 95%%: [%s], 99%%: [%s], mean: [%s], count: [%s]", percentile50duration, percentile75duration, percentile95duration, percentile99duration, meanDuration, count);
        return HealthCheck.Result.healthy((String)message);
    }

    private String nanoToSecondFormat(double nanoseconds) {
        return PrecisionFormatter.format(TimeUnit.NANOSECONDS.toSeconds((long)nanoseconds));
    }
}

