/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.HealthCheckable;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;

public abstract class SimpleHealthCheck
extends HealthCheck
implements HealthCheckable {
    private final String name;

    protected SimpleHealthCheck(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract HealthCheck.Result check();

    public static HealthCheck.Result callAndCheck(Runnable runnable) {
        try {
            runnable.run();
            return HealthCheck.Result.healthy();
        }
        catch (Throwable t) {
            Throwable root = Throwables.getRootCause((Throwable)t);
            String message = root.getMessage();
            if (message == null) {
                message = Throwables.getStackTraceAsString((Throwable)root);
            }
            return HealthCheck.Result.unhealthy((String)message);
        }
    }
}

