/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.MeteredHealthStrategy;
import com.appdynamics.common.util.health.PrecisionFormatter;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import io.dropwizard.core.setup.Environment;
import org.apache.commons.lang3.StringUtils;

public class MeteredPredicateHealthCheck
extends SimpleHealthCheck {
    public static final String MSG_FORMAT = "Rates (Avg per second. Avg of last 5 min); %s: [%s], %s: [%s]";
    private final Meter predicateSatisfiedMeter;
    private final Meter predicateNotSatisfiedMeter;
    private final String predicateSatisfiedMessage;
    private final String predicateNotSatisfiedMessage;
    private final MeteredHealthStrategy meteredHealthStrategy;

    public MeteredPredicateHealthCheck(String name, Environment environment, String predicateSatisfiedMessage, String predicateNotSatisfiedMessage) {
        this(name, environment, predicateSatisfiedMessage, predicateNotSatisfiedMessage, (successRate, errorRate) -> true);
    }

    public MeteredPredicateHealthCheck(String name, Environment environment, String predicateSatisfiedMessage, String predicateNotSatisfiedMessage, MeteredHealthStrategy healthStrategy) {
        super(name);
        Preconditions.checkNotNull((Object)environment);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)predicateSatisfiedMessage));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)predicateNotSatisfiedMessage));
        Preconditions.checkNotNull((Object)healthStrategy);
        this.predicateSatisfiedMessage = predicateSatisfiedMessage;
        this.predicateNotSatisfiedMessage = predicateNotSatisfiedMessage;
        this.meteredHealthStrategy = healthStrategy;
        this.predicateSatisfiedMeter = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"predicate.satisfied"}));
        this.predicateNotSatisfiedMeter = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"predicate.not.satisfied"}));
    }

    public void markPredicateSatisfied() {
        this.predicateSatisfiedMeter.mark();
    }

    public void markPredicateNotSatisfied() {
        this.predicateNotSatisfiedMeter.mark();
    }

    @Override
    public HealthCheck.Result check() {
        double successRate = this.predicateSatisfiedMeter.getFiveMinuteRate();
        String success = PrecisionFormatter.format(successRate);
        double failureRate = this.predicateNotSatisfiedMeter.getFiveMinuteRate();
        String failure = PrecisionFormatter.format(failureRate);
        String msg = String.format(MSG_FORMAT, this.predicateSatisfiedMessage, success, this.predicateNotSatisfiedMessage, failure);
        if (this.meteredHealthStrategy.isHealthy(successRate, failureRate)) {
            return HealthCheck.Result.healthy((String)msg);
        }
        return HealthCheck.Result.unhealthy((String)msg);
    }
}

