/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.MeteredHealthStrategy;
import com.appdynamics.common.util.health.PrecisionFormatter;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.core.setup.Environment;

public class MeteredHealthCheck
extends SimpleHealthCheck {
    private final Meter meterSuccess;
    private final Meter meterUserError;
    private final Meter meterTimeout;
    private final Meter meterError;
    private final MeteredHealthStrategy meteredHealthStrategy;

    public MeteredHealthCheck(String name, Environment environment) {
        this(name, environment, (successRate, errorRate) -> true);
    }

    public MeteredHealthCheck(String name, Environment environment, MeteredHealthStrategy healthStrategy) {
        super(name);
        this.meteredHealthStrategy = healthStrategy;
        this.meterSuccess = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"success"}));
        this.meterUserError = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"user-error"}));
        this.meterTimeout = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"timeout"}));
        this.meterError = environment.metrics().meter(MetricRegistry.name((String)name, (String[])new String[]{"error"}));
    }

    public Meter getMeterSuccess() {
        return this.meterSuccess;
    }

    public Meter getMeterUserError() {
        return this.meterUserError;
    }

    public Meter getMeterTimeout() {
        return this.meterTimeout;
    }

    public Meter getMeterError() {
        return this.meterError;
    }

    @Override
    public HealthCheck.Result check() {
        double successRate = this.meterSuccess.getFiveMinuteRate();
        String success = PrecisionFormatter.format(successRate);
        String userError = PrecisionFormatter.format(this.meterUserError.getFiveMinuteRate());
        String timeout = PrecisionFormatter.format(this.meterTimeout.getFiveMinuteRate());
        double errorRate = this.meterError.getFiveMinuteRate();
        String error = PrecisionFormatter.format(errorRate);
        String msg = String.format("Rates (Avg per second. Avg of last 5 min) success: [%s], user error: [%s], timeout: [%s], error: [%s]", success, userError, timeout, error);
        if (this.meteredHealthStrategy.isHealthy(successRate, errorRate)) {
            return HealthCheck.Result.healthy((String)msg);
        }
        return HealthCheck.Result.unhealthy((String)msg);
    }
}

