/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class HistogramHealthCheck
extends SimpleHealthCheck {
    public static final String MEAN_KEY = "mean";
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";
    public static final String MEDIAN_KEY = "median";
    public static final String PERCENTILE_75TH_KEY = "75th Percentile";
    public static final String PERCENTILE_95TH_KEY = "95th Percentile";
    public static final String PERCENTILE_99TH_KEY = "99th Percentile";
    private final String message;
    private final Histogram histogram;

    public HistogramHealthCheck(String name, String message, Histogram histogram) {
        super(name);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)message), (Object)"message can't be blank");
        Preconditions.checkNotNull((Object)histogram, (Object)"histogram can't be null");
        this.message = message;
        this.histogram = histogram;
    }

    @Override
    public HealthCheck.Result check() {
        Snapshot snapshot = this.histogram.getSnapshot();
        return HealthCheck.Result.builder().healthy().withMessage(this.message).withDetail(MEAN_KEY, (Object)String.format("%.2f", snapshot.getMean())).withDetail(MIN_KEY, (Object)String.format("%d", snapshot.getMin())).withDetail(MAX_KEY, (Object)String.format("%d", snapshot.getMax())).withDetail(MEDIAN_KEY, (Object)String.format("%.2f", snapshot.getMedian())).withDetail(PERCENTILE_75TH_KEY, (Object)String.format("%.2f", snapshot.get75thPercentile())).withDetail(PERCENTILE_95TH_KEY, (Object)String.format("%.2f", snapshot.get95thPercentile())).withDetail(PERCENTILE_99TH_KEY, (Object)String.format("%.2f", snapshot.get99thPercentile())).build();
    }

    public void update(long value) {
        this.histogram.update(value);
    }
}

