/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.health;

import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConsolidatedHealthCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsolidatedHealthCheck.class);
    final String name;
    final HealthCheckRegistry registry;
    final ConcurrentHashMap<String, HealthCheckable> componentHealthChecks;

    public ConsolidatedHealthCheck(String name, HealthCheckRegistry registry) {
        this.name = name;
        this.registry = registry;
        this.componentHealthChecks = new ConcurrentHashMap();
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, HealthCheckable> getComponents() {
        return ImmutableMap.copyOf(this.componentHealthChecks);
    }

    final String makeQualifiedHealthCheckName(String componentHealthCheckName) {
        return this.getName() + " / " + componentHealthCheckName;
    }

    public void register(HealthCheckable componentHealthCheck) {
        String qualifiedHealthCheckName = this.makeQualifiedHealthCheckName(componentHealthCheck.getName());
        this.componentHealthChecks.put(qualifiedHealthCheckName, componentHealthCheck);
        this.registry.unregister(qualifiedHealthCheckName);
        this.registry.register(qualifiedHealthCheckName, ConsolidatedHealthCheck.asHealthCheck(componentHealthCheck));
    }

    public boolean exists(String healthCheckName) {
        return this.componentHealthChecks.containsKey(this.makeQualifiedHealthCheckName(healthCheckName));
    }

    static HealthCheck asHealthCheck(final HealthCheckable healthCheckable) {
        return healthCheckable instanceof HealthCheck ? (HealthCheck)healthCheckable : new SimpleHealthCheck(healthCheckable.getName()){

            @Override
            public HealthCheck.Result check() {
                return ConsolidatedHealthCheck.safeCheck(healthCheckable);
            }
        };
    }

    static HealthCheck.Result safeCheck(HealthCheckable healthCheckable) {
        try {
            return healthCheckable.check();
        }
        catch (Throwable t) {
            return HealthCheck.Result.unhealthy((Throwable)t);
        }
    }

    public final void unregister(String componentHealthCheckName) {
        String qualifiedHealthCheckName = this.makeQualifiedHealthCheckName(componentHealthCheckName);
        this.internalUnregister(qualifiedHealthCheckName);
    }

    private void internalUnregister(String qualifiedHealthCheckName) {
        this.registry.unregister(qualifiedHealthCheckName);
        this.componentHealthChecks.remove(qualifiedHealthCheckName);
    }

    public final HealthCheck.Result checkComponents() {
        for (HealthCheckable child : this.componentHealthChecks.values()) {
            HealthCheck.Result result = ConsolidatedHealthCheck.safeCheck(child);
            if (result.isHealthy()) continue;
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    public final void discard() {
        LinkedList names = new LinkedList(this.componentHealthChecks.keySet());
        for (String s : names) {
            this.internalUnregister(s);
        }
    }
}

