/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.configuration.property.DynamicProperty;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationPropertiesHealthCheck
extends SimpleHealthCheck {
    private static final String KEY_PATTERNS_TO_REDACT = "key";
    private static final String REDACTED_VALUE = "REDACTED";
    private final ConfigurationProperties configurationProperties;

    public ConfigurationPropertiesHealthCheck(ConfigurationProperties configurationProperties) {
        super("Configuration properties");
        Preconditions.checkNotNull((Object)configurationProperties, (Object)"configurationProperties can't be null");
        this.configurationProperties = configurationProperties;
    }

    @Override
    public HealthCheck.Result check() {
        StringBuilder messageBuilder = new StringBuilder("Dynamic properties: [");
        boolean isFirst = true;
        for (Map.Entry dynamicPropertyEntry : this.configurationProperties.getAllDynamicProperties().entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                messageBuilder.append(", ");
            }
            String key = (String)dynamicPropertyEntry.getKey();
            messageBuilder.append(key).append('=');
            if (this.shouldHide(key)) {
                messageBuilder.append(REDACTED_VALUE);
                continue;
            }
            messageBuilder.append(((DynamicProperty)dynamicPropertyEntry.getValue()).get());
        }
        messageBuilder.append(']');
        return HealthCheck.Result.healthy((String)messageBuilder.toString());
    }

    private boolean shouldHide(String key) {
        return StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)KEY_PATTERNS_TO_REDACT);
    }
}

