/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.io.server;

import com.appdynamics.common.io.server.Server;
import com.appdynamics.common.util.item.Items;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servers
extends Items<String, Server>
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Servers.class);

    Servers(String itemNickName) {
        super(itemNickName);
        log.info("Started [{}]", (Object)itemNickName);
    }

    @Override
    @PreDestroy
    public void close() {
        log.info("Stopping all [{}]", (Object)this.itemNickName);
        for (String serverId : this.getIds()) {
            Server server = (Server)this.get(serverId);
            if (server != null) {
                try {
                    server.close();
                }
                catch (Exception e) {
                    log.warn("Error occurred while closing [" + serverId + "]", (Throwable)e);
                }
                continue;
            }
            log.warn("Server with id [{}] was removed before it could be closed", (Object)serverId);
        }
        log.info("Stopped all [{}]", (Object)this.itemNickName);
    }
}

