/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.framework.util;

import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.ConstraintMappingFactory;
import com.appdynamics.common.framework.util.AppLifecycleLogger;
import com.appdynamics.common.framework.util.VersionedAppConfiguration;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.var.SystemPropertyResolver;
import com.appdynamics.common.util.var.SystemVariableResolver;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.primitives.Ints;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.servlet.jakarta.exporter.MetricsServlet;
import jakarta.servlet.Servlet;
import jakarta.validation.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FrameworkHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrameworkHelper.class);

    private FrameworkHelper() {
    }

    public static void createPidFile(String fileNamePrefix) {
        long pid = SystemVariableResolver.getProcessId();
        String appHome = SystemPropertyResolver.INSTANCE.resolve("APPLICATION_HOME");
        if (appHome == null) {
            log.warn("Environment variable [{}] is null. Process id file will not be created", (Object)"APPLICATION_HOME");
            return;
        }
        String pidFileName = fileNamePrefix + ".id";
        Path path = Paths.get(appHome, pidFileName);
        if (Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException("Unable to create file [" + path.toAbsolutePath().toString() + "] to store the process id because it already exists. Please stop any currently running process and delete the process id file");
        }
        try {
            File pidFile = Files.createFile(path, new FileAttribute[0]).toFile();
            pidFile.deleteOnExit();
            log.info("Process id [{}] is stored in file [{}]", (Object)pid, (Object)pidFile.getAbsolutePath());
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pidFile), Charsets.UTF_8));){
                writer.println(pid);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create file [" + path.toAbsolutePath().toString() + "] to store the process id", e);
        }
    }

    public static void recordHttpServerPort(Environment env) {
        env.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

            public void serverStarted(Server server) {
                for (Connector connector : server.getConnectors()) {
                    if (System.getProperty("ad.dw.http.port") != null) {
                        return;
                    }
                    if (!"application".equals(connector.getName())) continue;
                    int port = ((ServerConnector)connector).getPort();
                    System.setProperty("ad.dw.http.port", String.valueOf(port));
                }
            }
        });
    }

    public static void startJmxReporter(Environment env) {
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)env.metrics()).inDomain("Application").filter(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return !name.startsWith("jvm.");
            }
        }).build();
        reporter.start();
    }

    public static void registerAndExposePrometheusMetrics(Environment env) {
        CollectorRegistry.defaultRegistry.register((Collector)new DropwizardExports(env.metrics()));
        env.admin().addServlet(MetricsServlet.class.getName(), (Servlet)new MetricsServlet(CollectorRegistry.defaultRegistry)).addMapping(new String[]{"/metrics/prometheus"});
    }

    public static void addLifecycleLogger(AppConfiguration conf, Environment env, Logger log) {
        env.lifecycle().addEventListener((LifeCycle.Listener)new AppLifecycleLogger(log, conf.getName()));
    }

    public static void checkVersionsMatch(int expectedVersion, VersionedAppConfiguration versionedAppCfg, ConfigurationProperties configurationProperties, Optional<String> versionPropertyName) {
        if (versionedAppCfg.getVersion() != expectedVersion) {
            throw new IllegalStateException("The current application version is [" + expectedVersion + "] but the YML file seems to be from version [" + versionedAppCfg.getVersion() + "]");
        }
        if (versionPropertyName.isPresent()) {
            String configPropStr = ConfigurationHelper.resolveProperty((String)((String)versionPropertyName.get()), (String)"");
            Integer configPropInt = Ints.tryParse((String)configPropStr);
            if (configPropInt == null || configPropInt != expectedVersion) {
                throw new IllegalStateException("The current application version is [" + expectedVersion + "] but the properties file seems to be from version [" + configPropStr + "]");
            }
            int configurationPropertiesVersion = configurationProperties.getInt((String)versionPropertyName.get(), -1);
            if (configurationPropertiesVersion != expectedVersion) {
                throw new IllegalStateException("The current application version is [" + expectedVersion + "] but the ConfigurationProperties object was initialized with version [" + configurationPropertiesVersion + "]");
            }
            log.info("Application configuration version is [{}], the YML file version is [{}], the properties file version is [{}] and the ConfigurationProperties object version is [{}]", new Object[]{expectedVersion, versionedAppCfg.getVersion(), configPropInt, configurationPropertiesVersion});
        } else {
            log.info("Application configuration version is [{}] and the YML file version is [{}]", (Object)expectedVersion, (Object)versionedAppCfg.getVersion());
        }
    }

    public static <T extends AppConfiguration> Validator buildCustomValidator(T conf) {
        HibernateValidatorConfiguration validatorConfiguration = Validators.newConfiguration();
        List<String> factoryClassNames = conf.getConstraintMappers();
        if (factoryClassNames != null) {
            for (String factoryClassName : factoryClassNames) {
                log.info("Loading custom constraint mapper from factory: [{}].", (Object)factoryClassName);
                validatorConfiguration.addMapping(FrameworkHelper.instantiateFactory(factoryClassName).getInstance());
            }
        }
        return validatorConfiguration.buildValidatorFactory().getValidator();
    }

    private static ConstraintMappingFactory instantiateFactory(String factoryClassName) {
        try {
            return (ConstraintMappingFactory)Class.forName(factoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error while instantiating custom constraint mapper: " + factoryClassName, e);
        }
    }
}

