/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.rest;

import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.rest.api.AgentRestApi;
import com.appdynamics.sim.agent.extensions.rest.api.EventData;
import com.appdynamics.sim.agent.extensions.rest.api.MetricData;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentResource
implements AgentRestApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentResource.class);
    private final MetricsService metricsService;
    private final EventsService eventsService;

    public AgentResource(MetricsService metricsService, EventsService eventsService) {
        this.metricsService = metricsService;
        this.eventsService = eventsService;
    }

    @Override
    public void writeMetrics(List<MetricData> metricData) {
        for (MetricData metricDataItem : metricData) {
            this.metricsService.reportMetric(metricDataItem.getMetricName(), metricDataItem.getAggregatorType(), metricDataItem.getValue());
        }
    }

    @Override
    public void writeEvents(List<EventData> eventData) {
        for (EventData eventDataItem : eventData) {
            this.eventsService.reportCustomEvent(eventDataItem.getEventSeverity(), eventDataItem.getType(), eventDataItem.getSummaryMessage(), eventDataItem.getProperties(), eventDataItem.getDetails());
        }
    }

    @Override
    public void ping() {
        log.debug("Pinged!");
    }
}

