/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import lombok.Generated;
import lombok.NonNull;

public class RawDataRateCalculatorUtil {
    private RawDataLong previousValue;
    private RawDataLong previousTime;
    private RawDataLong lastResult;
    private final RawDataFactory factory;

    public RawDataRateCalculatorUtil(@NonNull RawDataFactory factory) {
        this(null, null, null, factory);
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
    }

    public RawDataRateCalculatorUtil(RawDataLong previousValue, RawDataLong previousTime, RawDataLong lastResult, @NonNull RawDataFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.factory = factory;
        this.previousValue = this.createZeroLongValueIfNeeded(previousValue);
        this.previousTime = this.createZeroLongValueIfNeeded(previousTime);
        this.lastResult = this.createZeroLongValueIfNeeded(lastResult);
    }

    public RawDataLong calculate(RawDataLong currentValue, RawDataLong currentTime) {
        currentValue = this.createZeroLongValueIfNeeded(currentValue);
        currentTime = this.createZeroLongValueIfNeeded(currentTime);
        long currentLongValue = currentValue.get();
        long currentLongTime = currentTime.get();
        long previousLongValue = this.previousValue.get();
        long previousLongTime = this.previousTime.get();
        if (currentLongTime != previousLongTime) {
            long resultLong = Math.round(1.0 * (double)(currentLongValue - previousLongValue) / (double)(currentLongTime - previousLongTime));
            this.lastResult = this.factory.createLong(Long.valueOf(resultLong));
        }
        this.previousValue = currentValue;
        this.previousTime = currentTime;
        return this.lastResult;
    }

    private RawDataLong createZeroLongValueIfNeeded(RawDataLong value) {
        if (value == null || !value.isPresent()) {
            return this.factory.createLong(Long.valueOf(0L));
        }
        return value;
    }

    @Generated
    public static RawDataRateCalculatorUtilBuilder builder() {
        return new RawDataRateCalculatorUtilBuilder();
    }

    @Generated
    public RawDataLong getLastResult() {
        return this.lastResult;
    }

    @Generated
    public static class RawDataRateCalculatorUtilBuilder {
        @Generated
        private RawDataLong previousValue;
        @Generated
        private RawDataLong previousTime;
        @Generated
        private RawDataLong lastResult;
        @Generated
        private RawDataFactory factory;

        @Generated
        RawDataRateCalculatorUtilBuilder() {
        }

        @Generated
        public RawDataRateCalculatorUtilBuilder previousValue(RawDataLong previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        @Generated
        public RawDataRateCalculatorUtilBuilder previousTime(RawDataLong previousTime) {
            this.previousTime = previousTime;
            return this;
        }

        @Generated
        public RawDataRateCalculatorUtilBuilder lastResult(RawDataLong lastResult) {
            this.lastResult = lastResult;
            return this;
        }

        @Generated
        public RawDataRateCalculatorUtilBuilder factory(RawDataFactory factory) {
            this.factory = factory;
            return this;
        }

        @Generated
        public RawDataRateCalculatorUtil build() {
            return new RawDataRateCalculatorUtil(this.previousValue, this.previousTime, this.lastResult, this.factory);
        }

        @Generated
        public String toString() {
            return "RawDataRateCalculatorUtil.RawDataRateCalculatorUtilBuilder(previousValue=" + String.valueOf(this.previousValue) + ", previousTime=" + String.valueOf(this.previousTime) + ", lastResult=" + String.valueOf(this.lastResult) + ", factory=" + String.valueOf(this.factory) + ")";
        }
    }
}

