/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import lombok.Generated;
import lombok.NonNull;

public class RawDataDeltaCalculatorUtil {
    private static final String UNKNOWN_VALUE = "Unknown value";
    private RawDataLong previousValue;
    private RawDataLong lastResult;
    private final RawDataFactory factory;

    RawDataDeltaCalculatorUtil(RawDataLong previousValue, RawDataLong lastResult, @NonNull RawDataFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.factory = factory;
        this.previousValue = this.createZeroLongValueIfNeeded(previousValue);
        this.lastResult = this.createZeroLongValueIfNeeded(lastResult);
    }

    public RawDataLong calculate(RawDataLong currentValue) {
        currentValue = this.createZeroLongValueIfNeeded(currentValue);
        this.lastResult = currentValue.subtract(this.previousValue);
        this.previousValue = currentValue;
        return this.lastResult;
    }

    private RawDataLong createZeroLongValueIfNeeded(RawDataLong value) {
        if (value == null || !value.isPresent()) {
            return RawDataConstants.ZERO_LONG;
        }
        return value;
    }

    @Generated
    public static RawDataDeltaCalculatorUtilBuilder builder() {
        return new RawDataDeltaCalculatorUtilBuilder();
    }

    @Generated
    public RawDataLong getLastResult() {
        return this.lastResult;
    }

    @Generated
    public static class RawDataDeltaCalculatorUtilBuilder {
        @Generated
        private RawDataLong previousValue;
        @Generated
        private RawDataLong lastResult;
        @Generated
        private RawDataFactory factory;

        @Generated
        RawDataDeltaCalculatorUtilBuilder() {
        }

        @Generated
        public RawDataDeltaCalculatorUtilBuilder previousValue(RawDataLong previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        @Generated
        public RawDataDeltaCalculatorUtilBuilder lastResult(RawDataLong lastResult) {
            this.lastResult = lastResult;
            return this;
        }

        @Generated
        public RawDataDeltaCalculatorUtilBuilder factory(RawDataFactory factory) {
            this.factory = factory;
            return this;
        }

        @Generated
        public RawDataDeltaCalculatorUtil build() {
            return new RawDataDeltaCalculatorUtil(this.previousValue, this.lastResult, this.factory);
        }

        @Generated
        public String toString() {
            return "RawDataDeltaCalculatorUtil.RawDataDeltaCalculatorUtilBuilder(previousValue=" + String.valueOf(this.previousValue) + ", lastResult=" + String.valueOf(this.lastResult) + ", factory=" + String.valueOf(this.factory) + ")";
        }
    }
}

