/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.agent.extensions.servers.util.WraparoundCalculator;
import java.math.BigInteger;
import lombok.Generated;

public class PerfCounterBulkCount {
    private BigInteger previousVal;
    private BigInteger previousTicks;
    private final WraparoundCalculator inputCalculator;
    private long lastCookedResult;

    public long calculate(BigInteger inputVal, BigInteger inputTicks, BigInteger ticksPerSec) {
        if (UnknownValueUtil.isUnknownValue(inputVal, inputTicks, ticksPerSec)) {
            this.lastCookedResult = UnknownValueUtil.getUnknownValue();
            return this.lastCookedResult;
        }
        if (this.previousVal != null) {
            if (inputTicks.equals(this.previousTicks)) {
                return this.lastCookedResult;
            }
            BigInteger inputDifference = this.inputCalculator.calculateDifference(inputVal, this.previousVal);
            BigInteger baseDifference = inputTicks.subtract(this.previousTicks);
            this.lastCookedResult = ticksPerSec.multiply(inputDifference).divide(baseDifference).longValue();
        }
        this.previousVal = inputVal;
        this.previousTicks = inputTicks;
        return this.lastCookedResult;
    }

    @Generated
    public String toString() {
        return "PerfCounterBulkCount(previousVal=" + String.valueOf(this.previousVal) + ", previousTicks=" + String.valueOf(this.previousTicks) + ", inputCalculator=" + String.valueOf(this.inputCalculator) + ", lastCookedResult=" + this.getLastCookedResult() + ")";
    }

    @Generated
    public PerfCounterBulkCount(WraparoundCalculator inputCalculator) {
        this.inputCalculator = inputCalculator;
    }

    @Generated
    public long getLastCookedResult() {
        return this.lastCookedResult;
    }
}

