/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NixUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NixUtils.class);
    private static final Pattern ETIME_PATTERN = Pattern.compile("((\\d){0,20}-)?(([0-1]\\d|2[0-3]):)?(([0-5]\\d):([0-5]\\d)){1}");
    private static final long PAIR_LENGTH = 2L;
    @VisibleForTesting
    static final String NO_COMM_AVAILABLE = "no command available";
    @VisibleForTesting
    static final String NO_ETIME_AVAILABLE = "00:00";
    @VisibleForTesting
    static final String NO_ARGS_AVAILABLE = "no args available";
    private static final String[] ACCEPTED_TIME_FORMATS = new String[]{"hh:mm:ss", "mm:ss"};
    private static final String[] ACCEPTED_DAY_TIME_FORMAT = new String[]{"dd-hh:mm:ss"};

    public static SeparatedCommEtimeArgs separateCommEtimeArgs(@NonNull String commEtimeArgs) {
        if (commEtimeArgs == null) {
            throw new NullPointerException("commEtimeArgs is marked non-null but is null");
        }
        Matcher m = ETIME_PATTERN.matcher(commEtimeArgs);
        String comm = NO_COMM_AVAILABLE;
        String etime = NO_ETIME_AVAILABLE;
        String args = NO_ARGS_AVAILABLE;
        if (m.find()) {
            etime = m.group(0);
            int etimeIndex = m.start(0);
            comm = commEtimeArgs.substring(0, etimeIndex).trim();
            args = commEtimeArgs.substring(etimeIndex + etime.length(), commEtimeArgs.length()).trim();
        } else {
            log.debug("Was not able to accurately separate the process command line, elapsed time, and command arguments: {}", (Object)commEtimeArgs);
        }
        return new SeparatedCommEtimeArgs(comm, etime, args);
    }

    public static long getTimeInMilis(@NonNull String dateString) throws IllegalArgumentException {
        if (dateString == null) {
            throw new NullPointerException("dateString is marked non-null but is null");
        }
        Date date = DateUtils.parseDate((String)dateString, (String[])ACCEPTED_TIME_FORMATS);
        if (date == null) {
            date = DateUtils.parseDate((String)dateString, (String[])ACCEPTED_DAY_TIME_FORMAT);
            if (date == null) {
                throw new IllegalArgumentException("Invalid timestamp " + dateString);
            }
            return date.getTime() + TimeUnit.DAYS.toMillis(1L);
        }
        return date.getTime();
    }

    public static Optional<String> getFirstWordOfPair(String string, int secondWordIndex, String secondWord) {
        String[] words = string.split("\\W+");
        if (secondWordIndex < 0) {
            secondWordIndex += words.length;
        }
        if (secondWordIndex > 0 && secondWordIndex < words.length && (long)words.length >= 2L && words[secondWordIndex].equals(secondWord)) {
            return Optional.of((Object)words[secondWordIndex - 1]);
        }
        return Optional.absent();
    }

    public static class SeparatedCommEtimeArgs {
        private final String command;
        private final String elapsedTime;
        private final String args;

        @Generated
        public SeparatedCommEtimeArgs(String command, String elapsedTime, String args) {
            this.command = command;
            this.elapsedTime = elapsedTime;
            this.args = args;
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public String getElapsedTime() {
            return this.elapsedTime;
        }

        @Generated
        public String getArgs() {
            return this.args;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SeparatedCommEtimeArgs)) {
                return false;
            }
            SeparatedCommEtimeArgs other = (SeparatedCommEtimeArgs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$elapsedTime = this.getElapsedTime();
            String other$elapsedTime = other.getElapsedTime();
            if (this$elapsedTime == null ? other$elapsedTime != null : !this$elapsedTime.equals(other$elapsedTime)) {
                return false;
            }
            String this$args = this.getArgs();
            String other$args = other.getArgs();
            return !(this$args == null ? other$args != null : !this$args.equals(other$args));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SeparatedCommEtimeArgs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $elapsedTime = this.getElapsedTime();
            result = result * 59 + ($elapsedTime == null ? 43 : $elapsedTime.hashCode());
            String $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : $args.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NixUtils.SeparatedCommEtimeArgs(command=" + this.getCommand() + ", elapsedTime=" + this.getElapsedTime() + ", args=" + this.getArgs() + ")";
        }
    }
}

