/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class UrlMonitoringConfigsDecider
implements TagsConfigsDecider {
    private static final long DEFAULT_URL_MONITORING_POLLING_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;

    @Inject
    public UrlMonitoringConfigsDecider(ServersMonitorConfigResolver serversMonitorConfigResolver) {
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
    }

    public boolean isTagEnabled() {
        return this.serversMonitorConfigResolver.isUrlMonitoringConfigEnabled();
    }

    public long getUrlMonitoringPollingInterval() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getUrlMonitoringConfig() == null) {
            return this.getDefaultUrlMonitoringPollingInterval();
        }
        return (Long)this.serversMonitorConfigResolver.getUrlMonitoringConfig().getSamplingInterval().get();
    }

    @VisibleForTesting
    long getDefaultUrlMonitoringPollingInterval() {
        return DEFAULT_URL_MONITORING_POLLING_INTERVAL;
    }

    public List<String> getUrlMonitoringUrlsList() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getUrlMonitoringConfig() == null) {
            return Collections.emptyList();
        }
        return this.serversMonitorConfigResolver.getUrlMonitoringConfig().getUrlList();
    }
}

