/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.SmartAgentTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartAgentTagsScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartAgentTagsScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private final Scheduler scheduler;
    private final MachineTags machineTags;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final SmartAgentTagsConfigsDecider smartAgentTagsConfigsDecider;
    private final SmartAgentTagsSupplier smartAgentTagsSupplier;
    private Optional<Long> currentPollingInterval = Optional.absent();
    private volatile ScheduledFuture<?> future;

    @Inject
    public SmartAgentTagsScheduledRunner(Scheduler scheduler, MachineTags machineTags, SmartAgentTagsConfigsDecider smartAgentTagsConfigsDecider, SmartAgentTagsSupplier smartAgentTagsSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.machineTags = machineTags;
        this.smartAgentTagsConfigsDecider = smartAgentTagsConfigsDecider;
        this.smartAgentTagsSupplier = smartAgentTagsSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart()");
            if (this.smartAgentTagsConfigsDecider.isTagEnabled()) {
                log.debug("Started Smart Agent tags scheduled runner to poll for tags");
                this.scheduler.schedule((Runnable)this, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.smartAgentTagsConfigsDecider.isTagEnabled()) {
                if (this.future != null) {
                    this.future.cancel(true);
                    this.future = null;
                    log.debug("Stopped Smart Agent tags scheduled runner");
                }
                this.machineTags.updateTagMap(MachineTagMapName.SMART_AGENT_INTEGRATION_TAG_MAP, EMPTY_TAG_MAP);
            }
        }
    }

    @Override
    public void run() {
        if (this.smartAgentTagsConfigsDecider.isTagEnabled()) {
            log.debug("inside run() of smart agent scheduled runner");
            SetMultimap<String, String> smartAgentTagsMap = null;
            try {
                smartAgentTagsMap = this.smartAgentTagsSupplier.fetchLabels();
            }
            catch (Exception e) {
                log.debug("Error while fetching labels: " + String.valueOf(e));
            }
            for (Map.Entry entry : smartAgentTagsMap.entries()) {
                log.debug((String)entry.getKey() + ": " + (String)entry.getValue());
            }
            this.machineTags.updateTagMap(MachineTagMapName.SMART_AGENT_INTEGRATION_TAG_MAP, smartAgentTagsMap);
        }
    }

    private long getSmartAgentPollingInterval() {
        long smartAgentPollingInterval = this.smartAgentTagsConfigsDecider.getSmartAgentPollingInterval();
        log.debug("Setting the smart agent tags polling interval to {}", (Object)smartAgentPollingInterval);
        return smartAgentPollingInterval;
    }
}

