/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsConfigDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowTagsScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTagsScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private final Scheduler scheduler;
    private final MachineTags machineTags;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final ServiceNowTagsConfigDecider serviceNowTagsConfigDecider;
    private final ServiceNowTagsSupplier serviceNowTagsSupplier;
    private Optional<Long> currentPollingInterval;
    private volatile ScheduledFuture<?> future;

    @Inject
    public ServiceNowTagsScheduledRunner(Scheduler scheduler, MachineTags machineTags, ServiceNowTagsConfigDecider serviceNowTagsConfigDecider, ServiceNowTagsSupplier serviceNowTagsSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        log.debug(String.format("ServiceNow Scheduler Init host: '%s' cmdb url: '%s'", machineTags.toString(), serviceNowTagsConfigDecider.getCMDBURL()));
        this.currentPollingInterval = Optional.absent();
        this.scheduler = scheduler;
        this.machineTags = machineTags;
        this.serviceNowTagsConfigDecider = serviceNowTagsConfigDecider;
        this.serviceNowTagsSupplier = serviceNowTagsSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart():Started ServiceNow tags scheduled runner to poll for tags");
            if (this.serviceNowTagsConfigDecider.isTagEnabled()) {
                long scheduledInterval = this.getServiceNowPollingInterval();
                if (this.future == null) {
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.debug("Started ServiceNow tags scheduled runner to poll for tags");
                } else if (this.currentPollingInterval.isPresent() && scheduledInterval != (Long)this.currentPollingInterval.get()) {
                    this.future.cancel(true);
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.debug("Restarted ServiceNow tags scheduled runner with new polling interval");
                }
            }
        }
    }

    private long getServiceNowPollingInterval() {
        long pollingInterval = this.serviceNowTagsConfigDecider.getServiceNowPollingInterval();
        log.debug("Setting the ServiceNow tags polling interval to {}", (Object)pollingInterval);
        return pollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.serviceNowTagsConfigDecider.isTagEnabled()) {
                if (this.future != null) {
                    this.future.cancel(true);
                    this.future = null;
                    log.debug("Stopped ServiceNow tags scheduled runner");
                }
                this.machineTags.updateTagMap(MachineTagMapName.SNOW_INTEGRATION_TAG_MAP, EMPTY_TAG_MAP);
            }
        }
    }

    @Override
    public void run() {
        if (this.serviceNowTagsConfigDecider.isTagEnabled()) {
            log.debug("inside run() of ServiceNow scheduled runner {}", (Object)this.serviceNowTagsConfigDecider);
            this.serviceNowTagsSupplier.setConfig(this.serviceNowTagsConfigDecider);
            SetMultimap<String, String> snowTagsMap = this.serviceNowTagsSupplier.get();
            this.machineTags.updateTagMap(MachineTagMapName.SNOW_INTEGRATION_TAG_MAP, snowTagsMap);
        } else {
            this.repetitiveLogger.debug(log, "Polling for ServiceNow tags disabled. Skipping polling.", new Object[0]);
        }
    }
}

