/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.encryption.DecryptionService;
import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.servers.config.EncryptedConfigString;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowTagsConfigDecider
implements TagsConfigsDecider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTagsConfigDecider.class);
    private static final long DEFAULT_SNOW_TAGS_POLLING_INTERVAL = TimeUnit.MINUTES.toMillis(20L);
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;
    private final DecryptionService decryptionService;
    private final String systemHostID;

    @Inject
    public ServiceNowTagsConfigDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, ServersMonitorConfigResolver serversMonitorConfigResolver, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider, @HostId String hostId, @NonNull DecryptionService decryptionService) {
        if (decryptionService == null) {
            throw new NullPointerException("decryptionService is marked non-null but is null");
        }
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
        this.systemHostID = hostId;
        this.decryptionService = decryptionService;
    }

    public boolean isTagEnabled() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return false;
        }
        return this.serversMonitorConfigResolver.isServiceNowTagsEnabled();
    }

    public long getServiceNowPollingInterval() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return DEFAULT_SNOW_TAGS_POLLING_INTERVAL;
        }
        return (Long)this.serversMonitorConfigResolver.getServiceNowTagsConfig().getSamplingInterval().get();
    }

    long getDefaultServiceNowTagsPollingInterval() {
        return DEFAULT_SNOW_TAGS_POLLING_INTERVAL;
    }

    public String getOAuthURL() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return "";
        }
        return this.serversMonitorConfigResolver.getServiceNowTagsConfig().getOauthURL();
    }

    public String getOAuthClientId() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return "";
        }
        return this.serversMonitorConfigResolver.getServiceNowTagsConfig().getClientId();
    }

    public String getOAuthClientSecret() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return "";
        }
        EncryptedConfigString clientSecret = this.serversMonitorConfigResolver.getServiceNowTagsConfig().getClientSecret();
        if (clientSecret.getEncrypted().booleanValue()) {
            try {
                return (String)this.decryptionService.decryptInputStream((InputStream)new ByteArrayInputStream(clientSecret.getValue().getBytes("UTF8"))).or((Object)"");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Error in decrypting client secret for ServiceNow OAuth token retrieval, Exception: {}", (Throwable)e);
                return "";
            }
        }
        return clientSecret.getValue();
    }

    public String getOAuthClientScope() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return "";
        }
        return this.serversMonitorConfigResolver.getServiceNowTagsConfig().getClientScope();
    }

    public String getCMDBURL() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getServiceNowTagsConfig() == null) {
            return "";
        }
        return this.serversMonitorConfigResolver.getServiceNowTagsConfig().getCmdburl();
    }

    public String getHostId() {
        String hostname = null;
        if (this.serversMonitorConfigResolver != null && this.serversMonitorConfigResolver.getServiceNowTagsConfig() != null) {
            hostname = this.serversMonitorConfigResolver.getServiceNowTagsConfig().getHostname();
        }
        log.debug(String.format("Configured hostname: '%s' system hostid: '%s'", hostname, this.systemHostID));
        if (hostname == null || hostname.isEmpty()) {
            hostname = this.systemHostID;
        }
        return hostname;
    }

    public String toString() {
        return String.format("%s isTagEnabled(%s) getServiceNowPollingInterval(%s) oauthUrl(%s) cmdb_url(%s) hostId(%s)", this.getClass().getName(), this.isTagEnabled(), this.getServiceNowPollingInterval(), this.getOAuthURL(), this.getCMDBURL(), this.getHostId());
    }
}

