/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.sim.agent.extensions.servers.tags.OAuthToken;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsConfigDecider;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowTagsCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTagsCollector.class);
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private String cmdb_url = null;
    private OAuthToken token = null;
    private Map<String, Object> reqMap = new LinkedHashMap<String, Object>();

    public ServiceNowTagsCollector() {
        this.reqMap.put("sysparm_display_value", "true");
        this.reqMap.put("sysparm_exclude_reference_link", "true");
        this.reqMap.put("sysparm_limit", "1");
        log.debug("Initialized ServiceNow Tags Collector");
    }

    public SetMultimap<String, String> getAllCMDBTags(String hostId) throws Exception {
        if (this.cmdb_url == null || this.token == null) {
            log.debug(String.format("can not run cmdb query, because one or both are null cmdb_url: '%s' token: '%s'", this.cmdb_url, this.token));
            return EMPTY_TAG_MAP;
        }
        log.debug(String.format("getAllCMDBTags host: %s", hostId));
        StringBuilder requestURL = new StringBuilder(this.cmdb_url);
        StringBuilder paramData = new StringBuilder("?sysparm_query=name%3D" + hostId);
        for (Map.Entry<String, Object> param : this.reqMap.entrySet()) {
            if (paramData.length() == 0) {
                paramData.append('?');
            } else {
                paramData.append('&');
            }
            paramData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            paramData.append('=');
            paramData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        requestURL.append((CharSequence)paramData);
        log.debug(String.format("getAllCMDBTags url: %s", requestURL.toString()));
        HashMultimap metadata = HashMultimap.create();
        try {
            URL url = new URL(requestURL.toString());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Authorization", "Bearer " + this.token.getToken());
            conn.setRequestProperty("Accept", "application/json");
            InputStream content = conn.getInputStream();
            JSONTokener tokener = new JSONTokener(content);
            JSONObject json = new JSONObject(tokener);
            JSONArray resultArray = json.getJSONArray("result");
            if (!resultArray.isEmpty()) {
                JSONObject result = resultArray.getJSONObject(0);
                for (String key : result.keySet()) {
                    String value;
                    if (result.get(key) == null || (value = String.valueOf(result.get(key))).isEmpty() || value.equalsIgnoreCase("[null]") || value.equalsIgnoreCase("null")) continue;
                    metadata.put((Object)key, (Object)value);
                    log.debug(String.format("ServiceNow Tag: '%s'='%s'", key, value));
                }
            }
            conn.disconnect();
            return metadata;
        }
        catch (IOException e) {
            log.debug(String.format("Exception searching CMDB for host %s, request '%s' Exception: %s", hostId, requestURL.toString(), e), (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }

    public void setConfig(ServiceNowTagsConfigDecider config) {
        log.debug(String.format("Set Config with ServiceNowTagsConfigDecider %s, %s", config.getOAuthURL(), config.getCMDBURL()));
        this.token = new OAuthToken(config.getOAuthURL(), config.getOAuthClientId(), config.getOAuthClientSecret(), config.getOAuthClientScope());
        this.cmdb_url = config.getCMDBURL();
    }

    public void setConfig(String oAuthURL, String client_id, String client_secret, String client_scope, String cMDBURL) {
        log.debug(String.format("Set Config with Strings %s, %s", oAuthURL, cMDBURL));
        this.token = new OAuthToken(oAuthURL, client_id, client_secret, client_scope);
        this.cmdb_url = cMDBURL;
    }
}

