/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sTagsScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sTagsScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Scheduler scheduler;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final K8sTagsConfigsDecider k8sTagsConfigsDecider;
    private final K8sTagsSupplier k8sTagsSupplier;
    private long currentPollingInterval;
    private volatile ScheduledFuture<?> future;

    @Inject
    public K8sTagsScheduledRunner(Scheduler scheduler, K8sTagsConfigsDecider k8sTagsConfigsDecider, K8sTagsSupplier k8sTagsSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.k8sTagsConfigsDecider = k8sTagsConfigsDecider;
        this.k8sTagsSupplier = k8sTagsSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart():Started K8s tags scheduled runner to poll for tags");
            if (this.k8sTagsConfigsDecider.isTagEnabled()) {
                long scheduledInterval = this.getK8sPollingInterval();
                if (this.future == null) {
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    log.info("Started K8s tags scheduled runner to poll for tags");
                } else if (scheduledInterval != this.currentPollingInterval) {
                    this.future.cancel(true);
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    log.info("Restarted K8s tags scheduled runner with new polling interval");
                }
                this.currentPollingInterval = scheduledInterval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.k8sTagsConfigsDecider.isTagEnabled()) {
                if (this.future != null) {
                    this.future.cancel(true);
                    this.future = null;
                    log.info("Stopped K8s tags scheduled runner");
                }
                this.k8sTagsSupplier.clearTags();
            }
        }
    }

    @Override
    public void run() {
        if (this.k8sTagsConfigsDecider.isTagEnabled()) {
            this.k8sTagsSupplier.updateTags();
        } else {
            this.repetitiveLogger.debug(log, "Polling for K8s tags disabled. Skipping polling.", new Object[0]);
        }
    }

    private long getK8sPollingInterval() {
        long k8sPollingInterval = this.k8sTagsConfigsDecider.getK8sPollingInterval();
        log.debug("Setting the K8s tags polling interval to {}", (Object)k8sPollingInterval);
        return k8sPollingInterval;
    }
}

