/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sNodeTagsSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sNodeTagsSupplier.class);
    private static final String MASTER_KEY = "node-role.kubernetes.io/master";
    private static final String WORKER_KEY = "node-role.kubernetes.io/worker";
    private static final String INFRA_KEY = "node-role.kubernetes.io/infra";

    public SetMultimap<String, String> fetchLabels() {
        String nodeName = System.getenv("HOSTNAME");
        String serviceHost = System.getenv("KUBERNETES_SERVICE_HOST");
        String servicePort = System.getenv("KUBERNETES_SERVICE_PORT_HTTPS");
        String apiURL = "https://" + serviceHost + ":" + servicePort + "/api/v1/nodes/" + nodeName;
        String tokenPath = "/var/run/secrets/kubernetes.io/serviceaccount/token";
        HashMultimap multimap = HashMultimap.create();
        String token = K8sNodeTagsSupplier.readToken(tokenPath);
        JSONObject jsonObject = K8sNodeTagsSupplier.sendHttpGetRequest(apiURL, token);
        JSONObject metadata = jsonObject.getJSONObject("metadata");
        JSONObject labels = metadata.getJSONObject("labels");
        if (labels.has(MASTER_KEY)) {
            multimap.put((Object)"Cluster Node", (Object)"Master");
        } else if (labels.has(WORKER_KEY) && labels.has(INFRA_KEY)) {
            multimap.put((Object)"Cluster Node", (Object)"Worker-Infra");
        } else if (labels.has(WORKER_KEY)) {
            multimap.put((Object)"Cluster Node", (Object)"Worker");
        } else if (labels.has(INFRA_KEY)) {
            multimap.put((Object)"Cluster Node", (Object)"Infra");
        } else {
            log.debug("Error! Cannot find type of Cluster Node!");
        }
        return multimap;
    }

    private static String readToken(String filePath) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0])));
            StringBuilder token = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                token.append(line);
            }
            reader.close();
            return token.toString();
        }
        catch (IOException e) {
            log.debug("Error occurred while reading the token file: " + String.valueOf(e));
            return "";
        }
    }

    private static JSONObject sendHttpGetRequest(String apiUrl, String token) {
        try {
            K8sNodeTagsSupplier.disableCertificateValidation();
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + token);
            InputStream content = connection.getInputStream();
            JSONTokener tokener = new JSONTokener(content);
            JSONObject jsonObject = new JSONObject(tokener);
            connection.disconnect();
            return jsonObject;
        }
        catch (IOException e) {
            log.debug("HTTP Request failed: " + String.valueOf(e));
            return new JSONObject();
        }
    }

    private static void disableCertificateValidation() {
        try {
            TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustAllCertificates, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            log.debug("Error occurred while disabling Certificate Validation: ", (Throwable)e);
        }
    }
}

