/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.K8sNodeTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sNodeTagsScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sNodeTagsScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private final Scheduler scheduler;
    private final MachineTags machineTags;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final K8sNodeTagsConfigsDecider k8sNodeTagsConfigsDecider;
    private final K8sNodeTagsSupplier k8sNodeTagsSupplier;
    private Optional<Long> currentPollingInterval = Optional.absent();
    private volatile ScheduledFuture<?> future;

    @Inject
    public K8sNodeTagsScheduledRunner(Scheduler scheduler, MachineTags machineTags, K8sNodeTagsConfigsDecider k8sNodeTagsConfigsDecider, K8sNodeTagsSupplier k8sNodeTagsSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.machineTags = machineTags;
        this.k8sNodeTagsConfigsDecider = k8sNodeTagsConfigsDecider;
        this.k8sNodeTagsSupplier = k8sNodeTagsSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart()");
            if (this.k8sNodeTagsConfigsDecider.isTagEnabled()) {
                log.debug("Started K8sNode tags scheduled runner to poll for tags");
                this.scheduler.schedule((Runnable)this, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.k8sNodeTagsConfigsDecider.isTagEnabled()) {
                if (this.future != null) {
                    this.future.cancel(true);
                    this.future = null;
                    log.debug("Stopped K8SNODE tags scheduled runner");
                }
                this.machineTags.updateTagMap(MachineTagMapName.K8SNODE_INTEGRATION_TAG_MAP, EMPTY_TAG_MAP);
            }
        }
    }

    @Override
    public void run() {
        if (this.k8sNodeTagsConfigsDecider.isTagEnabled()) {
            log.debug("inside run() of k8s scheduled runner");
            SetMultimap<String, String> k8sNodeTagsMap = null;
            try {
                k8sNodeTagsMap = this.k8sNodeTagsSupplier.fetchLabels();
            }
            catch (Exception e) {
                log.debug("Error while fetching labels: " + String.valueOf(e));
            }
            for (Map.Entry entry : k8sNodeTagsMap.entries()) {
                log.debug((String)entry.getKey() + ": " + (String)entry.getValue());
            }
            this.machineTags.updateTagMap(MachineTagMapName.K8SNODE_INTEGRATION_TAG_MAP, k8sNodeTagsMap);
        }
    }

    private long getk8sNodePollingInterval() {
        long k8sNodePollingInterval = this.k8sNodeTagsConfigsDecider.getK8sNodePollingInterval();
        log.debug("Setting the k8s node tags polling interval to {}", (Object)k8sNodePollingInterval);
        return k8sNodePollingInterval;
    }
}

