/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;

public class AzureTagsConfigsDecider
implements TagsConfigsDecider {
    private static final long DEFAULT_AZURE_TAGS_POLLING_INTERVAL = TimeUnit.HOURS.toMillis(6L);
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    @Inject
    public AzureTagsConfigsDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, ServersMonitorConfigResolver serversMonitorConfigResolver, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    public boolean isTagEnabled() {
        return this.globalTagsConfigsDecider.isTagEnabled() && this.serversMonitorConfigResolver.isAzureTagsEnabled();
    }

    public long getAzurePollingInterval() {
        Optional controllerServerMonitoringConfig = Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()));
        if (!controllerServerMonitoringConfig.isPresent()) {
            return this.getAzureTagsPollingInterval();
        }
        Optional azurePollingInterval = ((AgentMonitorConfig)controllerServerMonitoringConfig.get()).getAzurePollingInterval();
        return (Long)azurePollingInterval.or((Object)this.getAzureTagsPollingInterval());
    }

    long getDefaultAzureTagsPollingInterval() {
        return DEFAULT_AZURE_TAGS_POLLING_INTERVAL;
    }

    long getAzureTagsPollingInterval() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getAzureTagsConfig() == null) {
            return this.getDefaultAzureTagsPollingInterval();
        }
        return (Long)this.serversMonitorConfigResolver.getAzureTagsConfig().getSamplingInterval().get();
    }
}

