/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureTagsCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureTagsCollector.class);
    private static final Map<String, String> EMPTY_TAG_MAP = new HashMap<String, String>();
    public static final String AzureServer = "http://169.254.169.254";
    public static final String InstanceEndpoint = "http://169.254.169.254/metadata/instance";
    public static final String AZURE_VM_LOCATION = "location";
    public static final String AZURE_VMID_TAG = "vmId";
    public static final String AZURE_CUSTOM_TAGS = "tags";

    public String getcustomtags() {
        return this.instancemetadata().get(AZURE_CUSTOM_TAGS);
    }

    public String getlocation() {
        return this.instancemetadata().get(AZURE_VM_LOCATION);
    }

    public String getvmid() {
        return this.instancemetadata().get(AZURE_VMID_TAG);
    }

    public Map<String, String> instancemetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String apiVersion = "2021-02-01";
        String azureurl = "http://169.254.169.254/metadata/instance?api-version=" + apiVersion;
        try {
            URL url = new URL(azureurl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Metadata", "true");
            InputStream content = conn.getInputStream();
            JSONTokener tokener = new JSONTokener(content);
            JSONObject json = new JSONObject(tokener);
            JSONObject compute = json.getJSONObject("compute");
            String Tags = compute.getString(AZURE_CUSTOM_TAGS);
            String VMId = compute.getString(AZURE_VMID_TAG);
            String location = compute.getString(AZURE_VM_LOCATION);
            metadata.put(AZURE_CUSTOM_TAGS, Tags);
            metadata.put(AZURE_VMID_TAG, VMId);
            metadata.put(AZURE_VM_LOCATION, location);
            conn.disconnect();
            return metadata;
        }
        catch (IOException e) {
            return EMPTY_TAG_MAP;
        }
    }
}

