/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import lombok.Generated;
import lombok.NonNull;

class WindowsVolume
extends Volume<WindowsRawData> {
    private WindowsRawData.LogicalDisk volume;

    @Inject
    private WindowsVolume(@Assisted @NonNull String mountPoint, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataFactory factory, @NonNull RawDataItemUtil dataItemUtil) {
        super(mountPoint, metricsService, machineProperties, factory, dataItemUtil);
        if (mountPoint == null) {
            throw new NullPointerException("mountPoint is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (dataItemUtil == null) {
            throw new NullPointerException("dataItemUtil is marked non-null but is null");
        }
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.volume = rawData.getLogicalDisks().get(this.getMountPoint());
    }

    @Override
    protected RawDataString getPartition() {
        return this.getFactory().createString(Optional.of((Object)this.volume.getName()));
    }

    @Override
    protected RawDataLong getSizeMb() {
        long resultSizeMb = CalculationUtils.bytesToMegabytes(this.volume.getSizeBytes());
        if (UnknownValueUtil.isUnknownValue(resultSizeMb)) {
            return RawDataConstants.ABSENT_LONG;
        }
        return this.getFactory().createLong(Long.valueOf(resultSizeMb));
    }

    @Override
    protected RawDataLong getUsedMb() {
        long sizeBytes = this.volume.getSizeBytes();
        long freeSpaceBytes = this.volume.getFreeSpaceBytes();
        long calculated = CalculationUtils.bytesToMegabytes(sizeBytes - freeSpaceBytes);
        long resultUsedMb = UnknownValueUtil.calculatedValueOrUnknown(sizeBytes, freeSpaceBytes, calculated);
        if (UnknownValueUtil.isUnknownValue(resultUsedMb)) {
            return RawDataConstants.ABSENT_LONG;
        }
        return this.getFactory().createLong(Long.valueOf(resultUsedMb));
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsVolume(super=" + super.toString() + ", volume=" + String.valueOf(this.volume) + ")";
    }
}

