/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.voltron.utils.annotations.Nullable;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

class WindowsRawData {
    @NonNull
    private Map<String, PerfLogicalDisk> perfLogicalDisks = Collections.emptyMap();
    @NonNull
    private Map<String, LogicalDisk> logicalDisks = Collections.emptyMap();
    @NonNull
    private Map<String, Cpu> cpus = Collections.emptyMap();
    @NonNull
    private Map<String, CpuPerf> cpusPerf = Collections.emptyMap();
    @NonNull
    private Map<String, NetworkAdapter> networkAdapters = Collections.emptyMap();
    @NonNull
    private Map<String, NetworkAdapterConfig> networkAdapterConfigs = Collections.emptyMap();
    @NonNull
    private Map<String, TcpipInterface> tcpipInterfaces = Collections.emptyMap();
    @NonNull
    private Map<String, NetworkInterfaceInfo> networkInterfaceInfo = new HashMap<String, NetworkInterfaceInfo>();
    @NonNull
    private Map<String, WinProcess> processes = Collections.emptyMap();
    @NonNull
    private Map<String, PerfWinProcess> perfProcesses = Collections.emptyMap();
    @NonNull
    private List<PhysicalMemory> physicalMemory = Collections.emptyList();
    @NonNull
    private ListMultimap<String, WinProcessRawData> procData = ArrayListMultimap.create();
    @NonNull
    private List<String> missingProperties = Collections.emptyList();
    @NonNull
    private List<String> missingWmiClasses = Collections.emptyList();
    @NonNull
    private List<String> emptyProperties = Collections.emptyList();
    @Nullable
    private OperatingSystem operatingSystem;
    @Nullable
    private Memory memory;
    @Nullable
    private ComputerSystem computerSystem;
    @Nullable
    private Load load;
    private long physicalMemoryCapacityBytes;
    private int totalNumLogicalProcessors;

    public WindowsRawData(Map<String, PerfLogicalDisk> perfLogicalDisks, Map<String, LogicalDisk> logicalDisks, Map<String, Cpu> cpus, Map<String, CpuPerf> cpusPerf, Map<String, NetworkAdapter> networkAdapters, Map<String, NetworkAdapterConfig> networkAdapterConfigs, Map<String, TcpipInterface> tcpipInterfaces, Map<String, NetworkInterfaceInfo> networkInterfaceInfo, Map<String, WinProcess> processes, Map<String, PerfWinProcess> perfProcesses, List<PhysicalMemory> physicalMemory, OperatingSystem operatingSystem, Memory memory, ComputerSystem computerSystem, Load load) {
        this.perfLogicalDisks = perfLogicalDisks;
        this.logicalDisks = logicalDisks;
        this.cpus = cpus;
        this.cpusPerf = cpusPerf;
        this.networkAdapters = networkAdapters;
        this.networkAdapterConfigs = networkAdapterConfigs;
        this.tcpipInterfaces = tcpipInterfaces;
        this.networkInterfaceInfo = networkInterfaceInfo;
        this.processes = processes;
        this.perfProcesses = perfProcesses;
        this.physicalMemory = physicalMemory;
        this.operatingSystem = operatingSystem;
        this.memory = memory;
        this.computerSystem = computerSystem;
        this.load = load;
    }

    @NonNull
    @Generated
    public Map<String, PerfLogicalDisk> getPerfLogicalDisks() {
        return this.perfLogicalDisks;
    }

    @NonNull
    @Generated
    public Map<String, LogicalDisk> getLogicalDisks() {
        return this.logicalDisks;
    }

    @NonNull
    @Generated
    public Map<String, Cpu> getCpus() {
        return this.cpus;
    }

    @NonNull
    @Generated
    public Map<String, CpuPerf> getCpusPerf() {
        return this.cpusPerf;
    }

    @NonNull
    @Generated
    public Map<String, NetworkAdapter> getNetworkAdapters() {
        return this.networkAdapters;
    }

    @NonNull
    @Generated
    public Map<String, NetworkAdapterConfig> getNetworkAdapterConfigs() {
        return this.networkAdapterConfigs;
    }

    @NonNull
    @Generated
    public Map<String, TcpipInterface> getTcpipInterfaces() {
        return this.tcpipInterfaces;
    }

    @NonNull
    @Generated
    public Map<String, NetworkInterfaceInfo> getNetworkInterfaceInfo() {
        return this.networkInterfaceInfo;
    }

    @NonNull
    @Generated
    public Map<String, WinProcess> getProcesses() {
        return this.processes;
    }

    @NonNull
    @Generated
    public Map<String, PerfWinProcess> getPerfProcesses() {
        return this.perfProcesses;
    }

    @NonNull
    @Generated
    public List<PhysicalMemory> getPhysicalMemory() {
        return this.physicalMemory;
    }

    @NonNull
    @Generated
    public ListMultimap<String, WinProcessRawData> getProcData() {
        return this.procData;
    }

    @NonNull
    @Generated
    public List<String> getMissingProperties() {
        return this.missingProperties;
    }

    @NonNull
    @Generated
    public List<String> getMissingWmiClasses() {
        return this.missingWmiClasses;
    }

    @NonNull
    @Generated
    public List<String> getEmptyProperties() {
        return this.emptyProperties;
    }

    @Generated
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @Generated
    public ComputerSystem getComputerSystem() {
        return this.computerSystem;
    }

    @Generated
    public Load getLoad() {
        return this.load;
    }

    @Generated
    public long getPhysicalMemoryCapacityBytes() {
        return this.physicalMemoryCapacityBytes;
    }

    @Generated
    public int getTotalNumLogicalProcessors() {
        return this.totalNumLogicalProcessors;
    }

    @Generated
    public void setPerfLogicalDisks(@NonNull Map<String, PerfLogicalDisk> perfLogicalDisks) {
        if (perfLogicalDisks == null) {
            throw new NullPointerException("perfLogicalDisks is marked non-null but is null");
        }
        this.perfLogicalDisks = perfLogicalDisks;
    }

    @Generated
    public void setLogicalDisks(@NonNull Map<String, LogicalDisk> logicalDisks) {
        if (logicalDisks == null) {
            throw new NullPointerException("logicalDisks is marked non-null but is null");
        }
        this.logicalDisks = logicalDisks;
    }

    @Generated
    public void setCpus(@NonNull Map<String, Cpu> cpus) {
        if (cpus == null) {
            throw new NullPointerException("cpus is marked non-null but is null");
        }
        this.cpus = cpus;
    }

    @Generated
    public void setCpusPerf(@NonNull Map<String, CpuPerf> cpusPerf) {
        if (cpusPerf == null) {
            throw new NullPointerException("cpusPerf is marked non-null but is null");
        }
        this.cpusPerf = cpusPerf;
    }

    @Generated
    public void setNetworkAdapters(@NonNull Map<String, NetworkAdapter> networkAdapters) {
        if (networkAdapters == null) {
            throw new NullPointerException("networkAdapters is marked non-null but is null");
        }
        this.networkAdapters = networkAdapters;
    }

    @Generated
    public void setNetworkAdapterConfigs(@NonNull Map<String, NetworkAdapterConfig> networkAdapterConfigs) {
        if (networkAdapterConfigs == null) {
            throw new NullPointerException("networkAdapterConfigs is marked non-null but is null");
        }
        this.networkAdapterConfigs = networkAdapterConfigs;
    }

    @Generated
    public void setTcpipInterfaces(@NonNull Map<String, TcpipInterface> tcpipInterfaces) {
        if (tcpipInterfaces == null) {
            throw new NullPointerException("tcpipInterfaces is marked non-null but is null");
        }
        this.tcpipInterfaces = tcpipInterfaces;
    }

    @Generated
    public void setNetworkInterfaceInfo(@NonNull Map<String, NetworkInterfaceInfo> networkInterfaceInfo) {
        if (networkInterfaceInfo == null) {
            throw new NullPointerException("networkInterfaceInfo is marked non-null but is null");
        }
        this.networkInterfaceInfo = networkInterfaceInfo;
    }

    @Generated
    public void setProcesses(@NonNull Map<String, WinProcess> processes) {
        if (processes == null) {
            throw new NullPointerException("processes is marked non-null but is null");
        }
        this.processes = processes;
    }

    @Generated
    public void setPerfProcesses(@NonNull Map<String, PerfWinProcess> perfProcesses) {
        if (perfProcesses == null) {
            throw new NullPointerException("perfProcesses is marked non-null but is null");
        }
        this.perfProcesses = perfProcesses;
    }

    @Generated
    public void setPhysicalMemory(@NonNull List<PhysicalMemory> physicalMemory) {
        if (physicalMemory == null) {
            throw new NullPointerException("physicalMemory is marked non-null but is null");
        }
        this.physicalMemory = physicalMemory;
    }

    @Generated
    public void setProcData(@NonNull ListMultimap<String, WinProcessRawData> procData) {
        if (procData == null) {
            throw new NullPointerException("procData is marked non-null but is null");
        }
        this.procData = procData;
    }

    @Generated
    public void setMissingProperties(@NonNull List<String> missingProperties) {
        if (missingProperties == null) {
            throw new NullPointerException("missingProperties is marked non-null but is null");
        }
        this.missingProperties = missingProperties;
    }

    @Generated
    public void setMissingWmiClasses(@NonNull List<String> missingWmiClasses) {
        if (missingWmiClasses == null) {
            throw new NullPointerException("missingWmiClasses is marked non-null but is null");
        }
        this.missingWmiClasses = missingWmiClasses;
    }

    @Generated
    public void setEmptyProperties(@NonNull List<String> emptyProperties) {
        if (emptyProperties == null) {
            throw new NullPointerException("emptyProperties is marked non-null but is null");
        }
        this.emptyProperties = emptyProperties;
    }

    @Generated
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    @Generated
    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    @Generated
    public void setComputerSystem(ComputerSystem computerSystem) {
        this.computerSystem = computerSystem;
    }

    @Generated
    public void setLoad(Load load) {
        this.load = load;
    }

    @Generated
    public void setPhysicalMemoryCapacityBytes(long physicalMemoryCapacityBytes) {
        this.physicalMemoryCapacityBytes = physicalMemoryCapacityBytes;
    }

    @Generated
    public void setTotalNumLogicalProcessors(int totalNumLogicalProcessors) {
        this.totalNumLogicalProcessors = totalNumLogicalProcessors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowsRawData)) {
            return false;
        }
        WindowsRawData other = (WindowsRawData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPhysicalMemoryCapacityBytes() != other.getPhysicalMemoryCapacityBytes()) {
            return false;
        }
        if (this.getTotalNumLogicalProcessors() != other.getTotalNumLogicalProcessors()) {
            return false;
        }
        Map<String, PerfLogicalDisk> this$perfLogicalDisks = this.getPerfLogicalDisks();
        Map<String, PerfLogicalDisk> other$perfLogicalDisks = other.getPerfLogicalDisks();
        if (this$perfLogicalDisks == null ? other$perfLogicalDisks != null : !((Object)this$perfLogicalDisks).equals(other$perfLogicalDisks)) {
            return false;
        }
        Map<String, LogicalDisk> this$logicalDisks = this.getLogicalDisks();
        Map<String, LogicalDisk> other$logicalDisks = other.getLogicalDisks();
        if (this$logicalDisks == null ? other$logicalDisks != null : !((Object)this$logicalDisks).equals(other$logicalDisks)) {
            return false;
        }
        Map<String, Cpu> this$cpus = this.getCpus();
        Map<String, Cpu> other$cpus = other.getCpus();
        if (this$cpus == null ? other$cpus != null : !((Object)this$cpus).equals(other$cpus)) {
            return false;
        }
        Map<String, CpuPerf> this$cpusPerf = this.getCpusPerf();
        Map<String, CpuPerf> other$cpusPerf = other.getCpusPerf();
        if (this$cpusPerf == null ? other$cpusPerf != null : !((Object)this$cpusPerf).equals(other$cpusPerf)) {
            return false;
        }
        Map<String, NetworkAdapter> this$networkAdapters = this.getNetworkAdapters();
        Map<String, NetworkAdapter> other$networkAdapters = other.getNetworkAdapters();
        if (this$networkAdapters == null ? other$networkAdapters != null : !((Object)this$networkAdapters).equals(other$networkAdapters)) {
            return false;
        }
        Map<String, NetworkAdapterConfig> this$networkAdapterConfigs = this.getNetworkAdapterConfigs();
        Map<String, NetworkAdapterConfig> other$networkAdapterConfigs = other.getNetworkAdapterConfigs();
        if (this$networkAdapterConfigs == null ? other$networkAdapterConfigs != null : !((Object)this$networkAdapterConfigs).equals(other$networkAdapterConfigs)) {
            return false;
        }
        Map<String, TcpipInterface> this$tcpipInterfaces = this.getTcpipInterfaces();
        Map<String, TcpipInterface> other$tcpipInterfaces = other.getTcpipInterfaces();
        if (this$tcpipInterfaces == null ? other$tcpipInterfaces != null : !((Object)this$tcpipInterfaces).equals(other$tcpipInterfaces)) {
            return false;
        }
        Map<String, NetworkInterfaceInfo> this$networkInterfaceInfo = this.getNetworkInterfaceInfo();
        Map<String, NetworkInterfaceInfo> other$networkInterfaceInfo = other.getNetworkInterfaceInfo();
        if (this$networkInterfaceInfo == null ? other$networkInterfaceInfo != null : !((Object)this$networkInterfaceInfo).equals(other$networkInterfaceInfo)) {
            return false;
        }
        Map<String, WinProcess> this$processes = this.getProcesses();
        Map<String, WinProcess> other$processes = other.getProcesses();
        if (this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes)) {
            return false;
        }
        Map<String, PerfWinProcess> this$perfProcesses = this.getPerfProcesses();
        Map<String, PerfWinProcess> other$perfProcesses = other.getPerfProcesses();
        if (this$perfProcesses == null ? other$perfProcesses != null : !((Object)this$perfProcesses).equals(other$perfProcesses)) {
            return false;
        }
        List<PhysicalMemory> this$physicalMemory = this.getPhysicalMemory();
        List<PhysicalMemory> other$physicalMemory = other.getPhysicalMemory();
        if (this$physicalMemory == null ? other$physicalMemory != null : !((Object)this$physicalMemory).equals(other$physicalMemory)) {
            return false;
        }
        ListMultimap<String, WinProcessRawData> this$procData = this.getProcData();
        ListMultimap<String, WinProcessRawData> other$procData = other.getProcData();
        if (this$procData == null ? other$procData != null : !this$procData.equals(other$procData)) {
            return false;
        }
        List<String> this$missingProperties = this.getMissingProperties();
        List<String> other$missingProperties = other.getMissingProperties();
        if (this$missingProperties == null ? other$missingProperties != null : !((Object)this$missingProperties).equals(other$missingProperties)) {
            return false;
        }
        List<String> this$missingWmiClasses = this.getMissingWmiClasses();
        List<String> other$missingWmiClasses = other.getMissingWmiClasses();
        if (this$missingWmiClasses == null ? other$missingWmiClasses != null : !((Object)this$missingWmiClasses).equals(other$missingWmiClasses)) {
            return false;
        }
        List<String> this$emptyProperties = this.getEmptyProperties();
        List<String> other$emptyProperties = other.getEmptyProperties();
        if (this$emptyProperties == null ? other$emptyProperties != null : !((Object)this$emptyProperties).equals(other$emptyProperties)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)this$operatingSystem).equals(other$operatingSystem)) {
            return false;
        }
        Memory this$memory = this.getMemory();
        Memory other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        ComputerSystem this$computerSystem = this.getComputerSystem();
        ComputerSystem other$computerSystem = other.getComputerSystem();
        if (this$computerSystem == null ? other$computerSystem != null : !((Object)this$computerSystem).equals(other$computerSystem)) {
            return false;
        }
        Load this$load = this.getLoad();
        Load other$load = other.getLoad();
        return !(this$load == null ? other$load != null : !((Object)this$load).equals(other$load));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowsRawData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $physicalMemoryCapacityBytes = this.getPhysicalMemoryCapacityBytes();
        result = result * 59 + (int)($physicalMemoryCapacityBytes >>> 32 ^ $physicalMemoryCapacityBytes);
        result = result * 59 + this.getTotalNumLogicalProcessors();
        Map<String, PerfLogicalDisk> $perfLogicalDisks = this.getPerfLogicalDisks();
        result = result * 59 + ($perfLogicalDisks == null ? 43 : ((Object)$perfLogicalDisks).hashCode());
        Map<String, LogicalDisk> $logicalDisks = this.getLogicalDisks();
        result = result * 59 + ($logicalDisks == null ? 43 : ((Object)$logicalDisks).hashCode());
        Map<String, Cpu> $cpus = this.getCpus();
        result = result * 59 + ($cpus == null ? 43 : ((Object)$cpus).hashCode());
        Map<String, CpuPerf> $cpusPerf = this.getCpusPerf();
        result = result * 59 + ($cpusPerf == null ? 43 : ((Object)$cpusPerf).hashCode());
        Map<String, NetworkAdapter> $networkAdapters = this.getNetworkAdapters();
        result = result * 59 + ($networkAdapters == null ? 43 : ((Object)$networkAdapters).hashCode());
        Map<String, NetworkAdapterConfig> $networkAdapterConfigs = this.getNetworkAdapterConfigs();
        result = result * 59 + ($networkAdapterConfigs == null ? 43 : ((Object)$networkAdapterConfigs).hashCode());
        Map<String, TcpipInterface> $tcpipInterfaces = this.getTcpipInterfaces();
        result = result * 59 + ($tcpipInterfaces == null ? 43 : ((Object)$tcpipInterfaces).hashCode());
        Map<String, NetworkInterfaceInfo> $networkInterfaceInfo = this.getNetworkInterfaceInfo();
        result = result * 59 + ($networkInterfaceInfo == null ? 43 : ((Object)$networkInterfaceInfo).hashCode());
        Map<String, WinProcess> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        Map<String, PerfWinProcess> $perfProcesses = this.getPerfProcesses();
        result = result * 59 + ($perfProcesses == null ? 43 : ((Object)$perfProcesses).hashCode());
        List<PhysicalMemory> $physicalMemory = this.getPhysicalMemory();
        result = result * 59 + ($physicalMemory == null ? 43 : ((Object)$physicalMemory).hashCode());
        ListMultimap<String, WinProcessRawData> $procData = this.getProcData();
        result = result * 59 + ($procData == null ? 43 : $procData.hashCode());
        List<String> $missingProperties = this.getMissingProperties();
        result = result * 59 + ($missingProperties == null ? 43 : ((Object)$missingProperties).hashCode());
        List<String> $missingWmiClasses = this.getMissingWmiClasses();
        result = result * 59 + ($missingWmiClasses == null ? 43 : ((Object)$missingWmiClasses).hashCode());
        List<String> $emptyProperties = this.getEmptyProperties();
        result = result * 59 + ($emptyProperties == null ? 43 : ((Object)$emptyProperties).hashCode());
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)$operatingSystem).hashCode());
        Memory $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        ComputerSystem $computerSystem = this.getComputerSystem();
        result = result * 59 + ($computerSystem == null ? 43 : ((Object)$computerSystem).hashCode());
        Load $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : ((Object)$load).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WindowsRawData(perfLogicalDisks=" + String.valueOf(this.getPerfLogicalDisks()) + ", logicalDisks=" + String.valueOf(this.getLogicalDisks()) + ", cpus=" + String.valueOf(this.getCpus()) + ", cpusPerf=" + String.valueOf(this.getCpusPerf()) + ", networkAdapters=" + String.valueOf(this.getNetworkAdapters()) + ", networkAdapterConfigs=" + String.valueOf(this.getNetworkAdapterConfigs()) + ", tcpipInterfaces=" + String.valueOf(this.getTcpipInterfaces()) + ", networkInterfaceInfo=" + String.valueOf(this.getNetworkInterfaceInfo()) + ", processes=" + String.valueOf(this.getProcesses()) + ", perfProcesses=" + String.valueOf(this.getPerfProcesses()) + ", physicalMemory=" + String.valueOf(this.getPhysicalMemory()) + ", procData=" + String.valueOf(this.getProcData()) + ", missingProperties=" + String.valueOf(this.getMissingProperties()) + ", missingWmiClasses=" + String.valueOf(this.getMissingWmiClasses()) + ", emptyProperties=" + String.valueOf(this.getEmptyProperties()) + ", operatingSystem=" + String.valueOf(this.getOperatingSystem()) + ", memory=" + String.valueOf(this.getMemory()) + ", computerSystem=" + String.valueOf(this.getComputerSystem()) + ", load=" + String.valueOf(this.getLoad()) + ", physicalMemoryCapacityBytes=" + this.getPhysicalMemoryCapacityBytes() + ", totalNumLogicalProcessors=" + this.getTotalNumLogicalProcessors() + ")";
    }

    @Generated
    protected WindowsRawData() {
    }

    static class OperatingSystem {
        @NonNull
        private String name;
        @NonNull
        private String release;
        @NonNull
        private String architecture;

        @Generated
        public static OperatingSystemBuilder builder() {
            return new OperatingSystemBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public String getRelease() {
            return this.release;
        }

        @NonNull
        @Generated
        public String getArchitecture() {
            return this.architecture;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setRelease(@NonNull String release) {
            if (release == null) {
                throw new NullPointerException("release is marked non-null but is null");
            }
            this.release = release;
        }

        @Generated
        public void setArchitecture(@NonNull String architecture) {
            if (architecture == null) {
                throw new NullPointerException("architecture is marked non-null but is null");
            }
            this.architecture = architecture;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatingSystem)) {
                return false;
            }
            OperatingSystem other = (OperatingSystem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$release = this.getRelease();
            String other$release = other.getRelease();
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            String this$architecture = this.getArchitecture();
            String other$architecture = other.getArchitecture();
            return !(this$architecture == null ? other$architecture != null : !this$architecture.equals(other$architecture));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperatingSystem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            String $architecture = this.getArchitecture();
            result = result * 59 + ($architecture == null ? 43 : $architecture.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.OperatingSystem(name=" + this.getName() + ", release=" + this.getRelease() + ", architecture=" + this.getArchitecture() + ")";
        }

        @Generated
        public OperatingSystem(@NonNull String name, @NonNull String release, @NonNull String architecture) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (release == null) {
                throw new NullPointerException("release is marked non-null but is null");
            }
            if (architecture == null) {
                throw new NullPointerException("architecture is marked non-null but is null");
            }
            this.name = name;
            this.release = release;
            this.architecture = architecture;
        }

        @Generated
        protected OperatingSystem() {
        }

        @Generated
        public static class OperatingSystemBuilder {
            @Generated
            private String name;
            @Generated
            private String release;
            @Generated
            private String architecture;

            @Generated
            OperatingSystemBuilder() {
            }

            @Generated
            public OperatingSystemBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public OperatingSystemBuilder release(@NonNull String release) {
                if (release == null) {
                    throw new NullPointerException("release is marked non-null but is null");
                }
                this.release = release;
                return this;
            }

            @Generated
            public OperatingSystemBuilder architecture(@NonNull String architecture) {
                if (architecture == null) {
                    throw new NullPointerException("architecture is marked non-null but is null");
                }
                this.architecture = architecture;
                return this;
            }

            @Generated
            public OperatingSystem build() {
                return new OperatingSystem(this.name, this.release, this.architecture);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.OperatingSystem.OperatingSystemBuilder(name=" + this.name + ", release=" + this.release + ", architecture=" + this.architecture + ")";
            }
        }
    }

    static class Memory {
        private long visibleTotal;
        private long physicalFree;
        private long swapTotal;
        private long swapFree;

        @Generated
        public static MemoryBuilder builder() {
            return new MemoryBuilder();
        }

        @Generated
        public long getVisibleTotal() {
            return this.visibleTotal;
        }

        @Generated
        public long getPhysicalFree() {
            return this.physicalFree;
        }

        @Generated
        public long getSwapTotal() {
            return this.swapTotal;
        }

        @Generated
        public long getSwapFree() {
            return this.swapFree;
        }

        @Generated
        public void setVisibleTotal(long visibleTotal) {
            this.visibleTotal = visibleTotal;
        }

        @Generated
        public void setPhysicalFree(long physicalFree) {
            this.physicalFree = physicalFree;
        }

        @Generated
        public void setSwapTotal(long swapTotal) {
            this.swapTotal = swapTotal;
        }

        @Generated
        public void setSwapFree(long swapFree) {
            this.swapFree = swapFree;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Memory)) {
                return false;
            }
            Memory other = (Memory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVisibleTotal() != other.getVisibleTotal()) {
                return false;
            }
            if (this.getPhysicalFree() != other.getPhysicalFree()) {
                return false;
            }
            if (this.getSwapTotal() != other.getSwapTotal()) {
                return false;
            }
            return this.getSwapFree() == other.getSwapFree();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Memory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $visibleTotal = this.getVisibleTotal();
            result = result * 59 + (int)($visibleTotal >>> 32 ^ $visibleTotal);
            long $physicalFree = this.getPhysicalFree();
            result = result * 59 + (int)($physicalFree >>> 32 ^ $physicalFree);
            long $swapTotal = this.getSwapTotal();
            result = result * 59 + (int)($swapTotal >>> 32 ^ $swapTotal);
            long $swapFree = this.getSwapFree();
            result = result * 59 + (int)($swapFree >>> 32 ^ $swapFree);
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.Memory(visibleTotal=" + this.getVisibleTotal() + ", physicalFree=" + this.getPhysicalFree() + ", swapTotal=" + this.getSwapTotal() + ", swapFree=" + this.getSwapFree() + ")";
        }

        @Generated
        public Memory(long visibleTotal, long physicalFree, long swapTotal, long swapFree) {
            this.visibleTotal = visibleTotal;
            this.physicalFree = physicalFree;
            this.swapTotal = swapTotal;
            this.swapFree = swapFree;
        }

        @Generated
        protected Memory() {
        }

        @Generated
        public static class MemoryBuilder {
            @Generated
            private long visibleTotal;
            @Generated
            private long physicalFree;
            @Generated
            private long swapTotal;
            @Generated
            private long swapFree;

            @Generated
            MemoryBuilder() {
            }

            @Generated
            public MemoryBuilder visibleTotal(long visibleTotal) {
                this.visibleTotal = visibleTotal;
                return this;
            }

            @Generated
            public MemoryBuilder physicalFree(long physicalFree) {
                this.physicalFree = physicalFree;
                return this;
            }

            @Generated
            public MemoryBuilder swapTotal(long swapTotal) {
                this.swapTotal = swapTotal;
                return this;
            }

            @Generated
            public MemoryBuilder swapFree(long swapFree) {
                this.swapFree = swapFree;
                return this;
            }

            @Generated
            public Memory build() {
                return new Memory(this.visibleTotal, this.physicalFree, this.swapTotal, this.swapFree);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.Memory.MemoryBuilder(visibleTotal=" + this.visibleTotal + ", physicalFree=" + this.physicalFree + ", swapTotal=" + this.swapTotal + ", swapFree=" + this.swapFree + ")";
            }
        }
    }

    static class ComputerSystem {
        @NonNull
        private String model;
        private long physicalTotal;

        @Generated
        public static ComputerSystemBuilder builder() {
            return new ComputerSystemBuilder();
        }

        @NonNull
        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public long getPhysicalTotal() {
            return this.physicalTotal;
        }

        @Generated
        public void setModel(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
        }

        @Generated
        public void setPhysicalTotal(long physicalTotal) {
            this.physicalTotal = physicalTotal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComputerSystem)) {
                return false;
            }
            ComputerSystem other = (ComputerSystem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPhysicalTotal() != other.getPhysicalTotal()) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            return !(this$model == null ? other$model != null : !this$model.equals(other$model));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComputerSystem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $physicalTotal = this.getPhysicalTotal();
            result = result * 59 + (int)($physicalTotal >>> 32 ^ $physicalTotal);
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.ComputerSystem(model=" + this.getModel() + ", physicalTotal=" + this.getPhysicalTotal() + ")";
        }

        @Generated
        public ComputerSystem(@NonNull String model, long physicalTotal) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            this.physicalTotal = physicalTotal;
        }

        @Generated
        protected ComputerSystem() {
        }

        @Generated
        public static class ComputerSystemBuilder {
            @Generated
            private String model;
            @Generated
            private long physicalTotal;

            @Generated
            ComputerSystemBuilder() {
            }

            @Generated
            public ComputerSystemBuilder model(@NonNull String model) {
                if (model == null) {
                    throw new NullPointerException("model is marked non-null but is null");
                }
                this.model = model;
                return this;
            }

            @Generated
            public ComputerSystemBuilder physicalTotal(long physicalTotal) {
                this.physicalTotal = physicalTotal;
                return this;
            }

            @Generated
            public ComputerSystem build() {
                return new ComputerSystem(this.model, this.physicalTotal);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.ComputerSystem.ComputerSystemBuilder(model=" + this.model + ", physicalTotal=" + this.physicalTotal + ")";
            }
        }
    }

    static class Load {
        private long processorQueueLength;

        @Generated
        public long getProcessorQueueLength() {
            return this.processorQueueLength;
        }

        @Generated
        public void setProcessorQueueLength(long processorQueueLength) {
            this.processorQueueLength = processorQueueLength;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Load)) {
                return false;
            }
            Load other = (Load)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getProcessorQueueLength() == other.getProcessorQueueLength();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Load;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $processorQueueLength = this.getProcessorQueueLength();
            result = result * 59 + (int)($processorQueueLength >>> 32 ^ $processorQueueLength);
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.Load(processorQueueLength=" + this.getProcessorQueueLength() + ")";
        }

        @Generated
        public Load(long processorQueueLength) {
            this.processorQueueLength = processorQueueLength;
        }

        @Generated
        protected Load() {
        }
    }

    static class WinProcessRawData {
        @NonNull
        private final ProcessClassIdCreator.ProcessClass procClass;
        @NonNull
        private final PerfWinProcess perfData;
        @NonNull
        private final WinProcess metaData;

        @NonNull
        @Generated
        public ProcessClassIdCreator.ProcessClass getProcClass() {
            return this.procClass;
        }

        @NonNull
        @Generated
        public PerfWinProcess getPerfData() {
            return this.perfData;
        }

        @NonNull
        @Generated
        public WinProcess getMetaData() {
            return this.metaData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WinProcessRawData)) {
                return false;
            }
            WinProcessRawData other = (WinProcessRawData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProcessClassIdCreator.ProcessClass this$procClass = this.getProcClass();
            ProcessClassIdCreator.ProcessClass other$procClass = other.getProcClass();
            if (this$procClass == null ? other$procClass != null : !((Object)this$procClass).equals(other$procClass)) {
                return false;
            }
            PerfWinProcess this$perfData = this.getPerfData();
            PerfWinProcess other$perfData = other.getPerfData();
            if (this$perfData == null ? other$perfData != null : !((Object)this$perfData).equals(other$perfData)) {
                return false;
            }
            WinProcess this$metaData = this.getMetaData();
            WinProcess other$metaData = other.getMetaData();
            return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WinProcessRawData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProcessClassIdCreator.ProcessClass $procClass = this.getProcClass();
            result = result * 59 + ($procClass == null ? 43 : ((Object)$procClass).hashCode());
            PerfWinProcess $perfData = this.getPerfData();
            result = result * 59 + ($perfData == null ? 43 : ((Object)$perfData).hashCode());
            WinProcess $metaData = this.getMetaData();
            result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.WinProcessRawData(procClass=" + String.valueOf(this.getProcClass()) + ", perfData=" + String.valueOf(this.getPerfData()) + ", metaData=" + String.valueOf(this.getMetaData()) + ")";
        }

        @Generated
        public WinProcessRawData(@NonNull ProcessClassIdCreator.ProcessClass procClass, @NonNull PerfWinProcess perfData, @NonNull WinProcess metaData) {
            if (procClass == null) {
                throw new NullPointerException("procClass is marked non-null but is null");
            }
            if (perfData == null) {
                throw new NullPointerException("perfData is marked non-null but is null");
            }
            if (metaData == null) {
                throw new NullPointerException("metaData is marked non-null but is null");
            }
            this.procClass = procClass;
            this.perfData = perfData;
            this.metaData = metaData;
        }
    }

    static class PhysicalMemory {
        private long capacity;

        @Generated
        public long getCapacity() {
            return this.capacity;
        }

        @Generated
        public void setCapacity(long capacity) {
            this.capacity = capacity;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhysicalMemory)) {
                return false;
            }
            PhysicalMemory other = (PhysicalMemory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getCapacity() == other.getCapacity();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PhysicalMemory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $capacity = this.getCapacity();
            result = result * 59 + (int)($capacity >>> 32 ^ $capacity);
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.PhysicalMemory(capacity=" + this.getCapacity() + ")";
        }

        @Generated
        public PhysicalMemory(long capacity) {
            this.capacity = capacity;
        }

        @Generated
        protected PhysicalMemory() {
        }
    }

    static class WinProcess {
        private int pid;
        private int ppid;
        @NonNull
        private String commandLine;
        @NonNull
        private String name;
        @NonNull
        private String owner;

        @Generated
        public static WinProcessBuilder builder() {
            return new WinProcessBuilder();
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public int getPpid() {
            return this.ppid;
        }

        @NonNull
        @Generated
        public String getCommandLine() {
            return this.commandLine;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public String getOwner() {
            return this.owner;
        }

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public void setPpid(int ppid) {
            this.ppid = ppid;
        }

        @Generated
        public void setCommandLine(@NonNull String commandLine) {
            if (commandLine == null) {
                throw new NullPointerException("commandLine is marked non-null but is null");
            }
            this.commandLine = commandLine;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setOwner(@NonNull String owner) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.owner = owner;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WinProcess)) {
                return false;
            }
            WinProcess other = (WinProcess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPid() != other.getPid()) {
                return false;
            }
            if (this.getPpid() != other.getPpid()) {
                return false;
            }
            String this$commandLine = this.getCommandLine();
            String other$commandLine = other.getCommandLine();
            if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$owner = this.getOwner();
            String other$owner = other.getOwner();
            return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WinProcess;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPid();
            result = result * 59 + this.getPpid();
            String $commandLine = this.getCommandLine();
            result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.WinProcess(pid=" + this.getPid() + ", ppid=" + this.getPpid() + ", commandLine=" + this.getCommandLine() + ", name=" + this.getName() + ", owner=" + this.getOwner() + ")";
        }

        @Generated
        public WinProcess(int pid, int ppid, @NonNull String commandLine, @NonNull String name, @NonNull String owner) {
            if (commandLine == null) {
                throw new NullPointerException("commandLine is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.pid = pid;
            this.ppid = ppid;
            this.commandLine = commandLine;
            this.name = name;
            this.owner = owner;
        }

        @Generated
        protected WinProcess() {
        }

        @Generated
        public static class WinProcessBuilder {
            @Generated
            private int pid;
            @Generated
            private int ppid;
            @Generated
            private String commandLine;
            @Generated
            private String name;
            @Generated
            private String owner;

            @Generated
            WinProcessBuilder() {
            }

            @Generated
            public WinProcessBuilder pid(int pid) {
                this.pid = pid;
                return this;
            }

            @Generated
            public WinProcessBuilder ppid(int ppid) {
                this.ppid = ppid;
                return this;
            }

            @Generated
            public WinProcessBuilder commandLine(@NonNull String commandLine) {
                if (commandLine == null) {
                    throw new NullPointerException("commandLine is marked non-null but is null");
                }
                this.commandLine = commandLine;
                return this;
            }

            @Generated
            public WinProcessBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public WinProcessBuilder owner(@NonNull String owner) {
                if (owner == null) {
                    throw new NullPointerException("owner is marked non-null but is null");
                }
                this.owner = owner;
                return this;
            }

            @Generated
            public WinProcess build() {
                return new WinProcess(this.pid, this.ppid, this.commandLine, this.name, this.owner);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.WinProcess.WinProcessBuilder(pid=" + this.pid + ", ppid=" + this.ppid + ", commandLine=" + this.commandLine + ", name=" + this.name + ", owner=" + this.owner + ")";
            }
        }
    }

    static class PerfWinProcess {
        private int pid;
        private long elapsedTime;
        private double cpuPercent;
        private long workingSet;
        private long threadCount;
        private long virtualBytes;

        @Generated
        public static PerfWinProcessBuilder builder() {
            return new PerfWinProcessBuilder();
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public long getElapsedTime() {
            return this.elapsedTime;
        }

        @Generated
        public double getCpuPercent() {
            return this.cpuPercent;
        }

        @Generated
        public long getWorkingSet() {
            return this.workingSet;
        }

        @Generated
        public long getThreadCount() {
            return this.threadCount;
        }

        @Generated
        public long getVirtualBytes() {
            return this.virtualBytes;
        }

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        @Generated
        public void setCpuPercent(double cpuPercent) {
            this.cpuPercent = cpuPercent;
        }

        @Generated
        public void setWorkingSet(long workingSet) {
            this.workingSet = workingSet;
        }

        @Generated
        public void setThreadCount(long threadCount) {
            this.threadCount = threadCount;
        }

        @Generated
        public void setVirtualBytes(long virtualBytes) {
            this.virtualBytes = virtualBytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PerfWinProcess)) {
                return false;
            }
            PerfWinProcess other = (PerfWinProcess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPid() != other.getPid()) {
                return false;
            }
            if (this.getElapsedTime() != other.getElapsedTime()) {
                return false;
            }
            if (Double.compare(this.getCpuPercent(), other.getCpuPercent()) != 0) {
                return false;
            }
            if (this.getWorkingSet() != other.getWorkingSet()) {
                return false;
            }
            if (this.getThreadCount() != other.getThreadCount()) {
                return false;
            }
            return this.getVirtualBytes() == other.getVirtualBytes();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PerfWinProcess;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPid();
            long $elapsedTime = this.getElapsedTime();
            result = result * 59 + (int)($elapsedTime >>> 32 ^ $elapsedTime);
            long $cpuPercent = Double.doubleToLongBits(this.getCpuPercent());
            result = result * 59 + (int)($cpuPercent >>> 32 ^ $cpuPercent);
            long $workingSet = this.getWorkingSet();
            result = result * 59 + (int)($workingSet >>> 32 ^ $workingSet);
            long $threadCount = this.getThreadCount();
            result = result * 59 + (int)($threadCount >>> 32 ^ $threadCount);
            long $virtualBytes = this.getVirtualBytes();
            result = result * 59 + (int)($virtualBytes >>> 32 ^ $virtualBytes);
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.PerfWinProcess(pid=" + this.getPid() + ", elapsedTime=" + this.getElapsedTime() + ", cpuPercent=" + this.getCpuPercent() + ", workingSet=" + this.getWorkingSet() + ", threadCount=" + this.getThreadCount() + ", virtualBytes=" + this.getVirtualBytes() + ")";
        }

        @Generated
        public PerfWinProcess(int pid, long elapsedTime, double cpuPercent, long workingSet, long threadCount, long virtualBytes) {
            this.pid = pid;
            this.elapsedTime = elapsedTime;
            this.cpuPercent = cpuPercent;
            this.workingSet = workingSet;
            this.threadCount = threadCount;
            this.virtualBytes = virtualBytes;
        }

        @Generated
        protected PerfWinProcess() {
        }

        @Generated
        public static class PerfWinProcessBuilder {
            @Generated
            private int pid;
            @Generated
            private long elapsedTime;
            @Generated
            private double cpuPercent;
            @Generated
            private long workingSet;
            @Generated
            private long threadCount;
            @Generated
            private long virtualBytes;

            @Generated
            PerfWinProcessBuilder() {
            }

            @Generated
            public PerfWinProcessBuilder pid(int pid) {
                this.pid = pid;
                return this;
            }

            @Generated
            public PerfWinProcessBuilder elapsedTime(long elapsedTime) {
                this.elapsedTime = elapsedTime;
                return this;
            }

            @Generated
            public PerfWinProcessBuilder cpuPercent(double cpuPercent) {
                this.cpuPercent = cpuPercent;
                return this;
            }

            @Generated
            public PerfWinProcessBuilder workingSet(long workingSet) {
                this.workingSet = workingSet;
                return this;
            }

            @Generated
            public PerfWinProcessBuilder threadCount(long threadCount) {
                this.threadCount = threadCount;
                return this;
            }

            @Generated
            public PerfWinProcessBuilder virtualBytes(long virtualBytes) {
                this.virtualBytes = virtualBytes;
                return this;
            }

            @Generated
            public PerfWinProcess build() {
                return new PerfWinProcess(this.pid, this.elapsedTime, this.cpuPercent, this.workingSet, this.threadCount, this.virtualBytes);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.PerfWinProcess.PerfWinProcessBuilder(pid=" + this.pid + ", elapsedTime=" + this.elapsedTime + ", cpuPercent=" + this.cpuPercent + ", workingSet=" + this.workingSet + ", threadCount=" + this.threadCount + ", virtualBytes=" + this.virtualBytes + ")";
            }
        }
    }

    static class NetworkInterfaceInfo {
        @NonNull
        private String name;
        private int availability;
        private int netConnectionStatus;
        private long speed;
        @NonNull
        private String netEnabled;
        @NonNull
        private String fullDuplex;
        @NonNull
        private String macAddress;
        @NonNull
        private String ipAddress;
        @NonNull
        private String ipSubnet;
        @NonNull
        private String defaultIpGateway;
        private long mtu;
        private long bytesIncomingPerSec;
        private long bytesOutgoingPerSec;
        private long packetsIncomingPerSec;
        private long packetsOutgoingPerSec;
        private long packetsIncomingErrors;
        private long packetsOutgoingErrors;
        private BigInteger bytesTotalPerSec;
        private BigInteger perfTicksPerSec;
        private BigInteger timestamp;
        private BigInteger timestampTicksPerSec;

        @Generated
        public static NetworkInterfaceInfoBuilder builder() {
            return new NetworkInterfaceInfoBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public int getAvailability() {
            return this.availability;
        }

        @Generated
        public int getNetConnectionStatus() {
            return this.netConnectionStatus;
        }

        @Generated
        public long getSpeed() {
            return this.speed;
        }

        @NonNull
        @Generated
        public String getNetEnabled() {
            return this.netEnabled;
        }

        @NonNull
        @Generated
        public String getFullDuplex() {
            return this.fullDuplex;
        }

        @NonNull
        @Generated
        public String getMacAddress() {
            return this.macAddress;
        }

        @NonNull
        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @NonNull
        @Generated
        public String getIpSubnet() {
            return this.ipSubnet;
        }

        @NonNull
        @Generated
        public String getDefaultIpGateway() {
            return this.defaultIpGateway;
        }

        @Generated
        public long getMtu() {
            return this.mtu;
        }

        @Generated
        public long getBytesIncomingPerSec() {
            return this.bytesIncomingPerSec;
        }

        @Generated
        public long getBytesOutgoingPerSec() {
            return this.bytesOutgoingPerSec;
        }

        @Generated
        public long getPacketsIncomingPerSec() {
            return this.packetsIncomingPerSec;
        }

        @Generated
        public long getPacketsOutgoingPerSec() {
            return this.packetsOutgoingPerSec;
        }

        @Generated
        public long getPacketsIncomingErrors() {
            return this.packetsIncomingErrors;
        }

        @Generated
        public long getPacketsOutgoingErrors() {
            return this.packetsOutgoingErrors;
        }

        @Generated
        public BigInteger getBytesTotalPerSec() {
            return this.bytesTotalPerSec;
        }

        @Generated
        public BigInteger getPerfTicksPerSec() {
            return this.perfTicksPerSec;
        }

        @Generated
        public BigInteger getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public BigInteger getTimestampTicksPerSec() {
            return this.timestampTicksPerSec;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setAvailability(int availability) {
            this.availability = availability;
        }

        @Generated
        public void setNetConnectionStatus(int netConnectionStatus) {
            this.netConnectionStatus = netConnectionStatus;
        }

        @Generated
        public void setSpeed(long speed) {
            this.speed = speed;
        }

        @Generated
        public void setNetEnabled(@NonNull String netEnabled) {
            if (netEnabled == null) {
                throw new NullPointerException("netEnabled is marked non-null but is null");
            }
            this.netEnabled = netEnabled;
        }

        @Generated
        public void setFullDuplex(@NonNull String fullDuplex) {
            if (fullDuplex == null) {
                throw new NullPointerException("fullDuplex is marked non-null but is null");
            }
            this.fullDuplex = fullDuplex;
        }

        @Generated
        public void setMacAddress(@NonNull String macAddress) {
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            this.macAddress = macAddress;
        }

        @Generated
        public void setIpAddress(@NonNull String ipAddress) {
            if (ipAddress == null) {
                throw new NullPointerException("ipAddress is marked non-null but is null");
            }
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setIpSubnet(@NonNull String ipSubnet) {
            if (ipSubnet == null) {
                throw new NullPointerException("ipSubnet is marked non-null but is null");
            }
            this.ipSubnet = ipSubnet;
        }

        @Generated
        public void setDefaultIpGateway(@NonNull String defaultIpGateway) {
            if (defaultIpGateway == null) {
                throw new NullPointerException("defaultIpGateway is marked non-null but is null");
            }
            this.defaultIpGateway = defaultIpGateway;
        }

        @Generated
        public void setMtu(long mtu) {
            this.mtu = mtu;
        }

        @Generated
        public void setBytesIncomingPerSec(long bytesIncomingPerSec) {
            this.bytesIncomingPerSec = bytesIncomingPerSec;
        }

        @Generated
        public void setBytesOutgoingPerSec(long bytesOutgoingPerSec) {
            this.bytesOutgoingPerSec = bytesOutgoingPerSec;
        }

        @Generated
        public void setPacketsIncomingPerSec(long packetsIncomingPerSec) {
            this.packetsIncomingPerSec = packetsIncomingPerSec;
        }

        @Generated
        public void setPacketsOutgoingPerSec(long packetsOutgoingPerSec) {
            this.packetsOutgoingPerSec = packetsOutgoingPerSec;
        }

        @Generated
        public void setPacketsIncomingErrors(long packetsIncomingErrors) {
            this.packetsIncomingErrors = packetsIncomingErrors;
        }

        @Generated
        public void setPacketsOutgoingErrors(long packetsOutgoingErrors) {
            this.packetsOutgoingErrors = packetsOutgoingErrors;
        }

        @Generated
        public void setBytesTotalPerSec(BigInteger bytesTotalPerSec) {
            this.bytesTotalPerSec = bytesTotalPerSec;
        }

        @Generated
        public void setPerfTicksPerSec(BigInteger perfTicksPerSec) {
            this.perfTicksPerSec = perfTicksPerSec;
        }

        @Generated
        public void setTimestamp(BigInteger timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setTimestampTicksPerSec(BigInteger timestampTicksPerSec) {
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkInterfaceInfo)) {
                return false;
            }
            NetworkInterfaceInfo other = (NetworkInterfaceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAvailability() != other.getAvailability()) {
                return false;
            }
            if (this.getNetConnectionStatus() != other.getNetConnectionStatus()) {
                return false;
            }
            if (this.getSpeed() != other.getSpeed()) {
                return false;
            }
            if (this.getMtu() != other.getMtu()) {
                return false;
            }
            if (this.getBytesIncomingPerSec() != other.getBytesIncomingPerSec()) {
                return false;
            }
            if (this.getBytesOutgoingPerSec() != other.getBytesOutgoingPerSec()) {
                return false;
            }
            if (this.getPacketsIncomingPerSec() != other.getPacketsIncomingPerSec()) {
                return false;
            }
            if (this.getPacketsOutgoingPerSec() != other.getPacketsOutgoingPerSec()) {
                return false;
            }
            if (this.getPacketsIncomingErrors() != other.getPacketsIncomingErrors()) {
                return false;
            }
            if (this.getPacketsOutgoingErrors() != other.getPacketsOutgoingErrors()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$netEnabled = this.getNetEnabled();
            String other$netEnabled = other.getNetEnabled();
            if (this$netEnabled == null ? other$netEnabled != null : !this$netEnabled.equals(other$netEnabled)) {
                return false;
            }
            String this$fullDuplex = this.getFullDuplex();
            String other$fullDuplex = other.getFullDuplex();
            if (this$fullDuplex == null ? other$fullDuplex != null : !this$fullDuplex.equals(other$fullDuplex)) {
                return false;
            }
            String this$macAddress = this.getMacAddress();
            String other$macAddress = other.getMacAddress();
            if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$ipSubnet = this.getIpSubnet();
            String other$ipSubnet = other.getIpSubnet();
            if (this$ipSubnet == null ? other$ipSubnet != null : !this$ipSubnet.equals(other$ipSubnet)) {
                return false;
            }
            String this$defaultIpGateway = this.getDefaultIpGateway();
            String other$defaultIpGateway = other.getDefaultIpGateway();
            if (this$defaultIpGateway == null ? other$defaultIpGateway != null : !this$defaultIpGateway.equals(other$defaultIpGateway)) {
                return false;
            }
            BigInteger this$bytesTotalPerSec = this.getBytesTotalPerSec();
            BigInteger other$bytesTotalPerSec = other.getBytesTotalPerSec();
            if (this$bytesTotalPerSec == null ? other$bytesTotalPerSec != null : !((Object)this$bytesTotalPerSec).equals(other$bytesTotalPerSec)) {
                return false;
            }
            BigInteger this$perfTicksPerSec = this.getPerfTicksPerSec();
            BigInteger other$perfTicksPerSec = other.getPerfTicksPerSec();
            if (this$perfTicksPerSec == null ? other$perfTicksPerSec != null : !((Object)this$perfTicksPerSec).equals(other$perfTicksPerSec)) {
                return false;
            }
            BigInteger this$timestamp = this.getTimestamp();
            BigInteger other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            BigInteger this$timestampTicksPerSec = this.getTimestampTicksPerSec();
            BigInteger other$timestampTicksPerSec = other.getTimestampTicksPerSec();
            return !(this$timestampTicksPerSec == null ? other$timestampTicksPerSec != null : !((Object)this$timestampTicksPerSec).equals(other$timestampTicksPerSec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkInterfaceInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAvailability();
            result = result * 59 + this.getNetConnectionStatus();
            long $speed = this.getSpeed();
            result = result * 59 + (int)($speed >>> 32 ^ $speed);
            long $mtu = this.getMtu();
            result = result * 59 + (int)($mtu >>> 32 ^ $mtu);
            long $bytesIncomingPerSec = this.getBytesIncomingPerSec();
            result = result * 59 + (int)($bytesIncomingPerSec >>> 32 ^ $bytesIncomingPerSec);
            long $bytesOutgoingPerSec = this.getBytesOutgoingPerSec();
            result = result * 59 + (int)($bytesOutgoingPerSec >>> 32 ^ $bytesOutgoingPerSec);
            long $packetsIncomingPerSec = this.getPacketsIncomingPerSec();
            result = result * 59 + (int)($packetsIncomingPerSec >>> 32 ^ $packetsIncomingPerSec);
            long $packetsOutgoingPerSec = this.getPacketsOutgoingPerSec();
            result = result * 59 + (int)($packetsOutgoingPerSec >>> 32 ^ $packetsOutgoingPerSec);
            long $packetsIncomingErrors = this.getPacketsIncomingErrors();
            result = result * 59 + (int)($packetsIncomingErrors >>> 32 ^ $packetsIncomingErrors);
            long $packetsOutgoingErrors = this.getPacketsOutgoingErrors();
            result = result * 59 + (int)($packetsOutgoingErrors >>> 32 ^ $packetsOutgoingErrors);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $netEnabled = this.getNetEnabled();
            result = result * 59 + ($netEnabled == null ? 43 : $netEnabled.hashCode());
            String $fullDuplex = this.getFullDuplex();
            result = result * 59 + ($fullDuplex == null ? 43 : $fullDuplex.hashCode());
            String $macAddress = this.getMacAddress();
            result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $ipSubnet = this.getIpSubnet();
            result = result * 59 + ($ipSubnet == null ? 43 : $ipSubnet.hashCode());
            String $defaultIpGateway = this.getDefaultIpGateway();
            result = result * 59 + ($defaultIpGateway == null ? 43 : $defaultIpGateway.hashCode());
            BigInteger $bytesTotalPerSec = this.getBytesTotalPerSec();
            result = result * 59 + ($bytesTotalPerSec == null ? 43 : ((Object)$bytesTotalPerSec).hashCode());
            BigInteger $perfTicksPerSec = this.getPerfTicksPerSec();
            result = result * 59 + ($perfTicksPerSec == null ? 43 : ((Object)$perfTicksPerSec).hashCode());
            BigInteger $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            BigInteger $timestampTicksPerSec = this.getTimestampTicksPerSec();
            result = result * 59 + ($timestampTicksPerSec == null ? 43 : ((Object)$timestampTicksPerSec).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.NetworkInterfaceInfo(name=" + this.getName() + ", availability=" + this.getAvailability() + ", netConnectionStatus=" + this.getNetConnectionStatus() + ", speed=" + this.getSpeed() + ", netEnabled=" + this.getNetEnabled() + ", fullDuplex=" + this.getFullDuplex() + ", macAddress=" + this.getMacAddress() + ", ipAddress=" + this.getIpAddress() + ", ipSubnet=" + this.getIpSubnet() + ", defaultIpGateway=" + this.getDefaultIpGateway() + ", mtu=" + this.getMtu() + ", bytesIncomingPerSec=" + this.getBytesIncomingPerSec() + ", bytesOutgoingPerSec=" + this.getBytesOutgoingPerSec() + ", packetsIncomingPerSec=" + this.getPacketsIncomingPerSec() + ", packetsOutgoingPerSec=" + this.getPacketsOutgoingPerSec() + ", packetsIncomingErrors=" + this.getPacketsIncomingErrors() + ", packetsOutgoingErrors=" + this.getPacketsOutgoingErrors() + ", bytesTotalPerSec=" + String.valueOf(this.getBytesTotalPerSec()) + ", perfTicksPerSec=" + String.valueOf(this.getPerfTicksPerSec()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", timestampTicksPerSec=" + String.valueOf(this.getTimestampTicksPerSec()) + ")";
        }

        @Generated
        public NetworkInterfaceInfo(@NonNull String name, int availability, int netConnectionStatus, long speed, @NonNull String netEnabled, @NonNull String fullDuplex, @NonNull String macAddress, @NonNull String ipAddress, @NonNull String ipSubnet, @NonNull String defaultIpGateway, long mtu, long bytesIncomingPerSec, long bytesOutgoingPerSec, long packetsIncomingPerSec, long packetsOutgoingPerSec, long packetsIncomingErrors, long packetsOutgoingErrors, BigInteger bytesTotalPerSec, BigInteger perfTicksPerSec, BigInteger timestamp, BigInteger timestampTicksPerSec) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (netEnabled == null) {
                throw new NullPointerException("netEnabled is marked non-null but is null");
            }
            if (fullDuplex == null) {
                throw new NullPointerException("fullDuplex is marked non-null but is null");
            }
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            if (ipAddress == null) {
                throw new NullPointerException("ipAddress is marked non-null but is null");
            }
            if (ipSubnet == null) {
                throw new NullPointerException("ipSubnet is marked non-null but is null");
            }
            if (defaultIpGateway == null) {
                throw new NullPointerException("defaultIpGateway is marked non-null but is null");
            }
            this.name = name;
            this.availability = availability;
            this.netConnectionStatus = netConnectionStatus;
            this.speed = speed;
            this.netEnabled = netEnabled;
            this.fullDuplex = fullDuplex;
            this.macAddress = macAddress;
            this.ipAddress = ipAddress;
            this.ipSubnet = ipSubnet;
            this.defaultIpGateway = defaultIpGateway;
            this.mtu = mtu;
            this.bytesIncomingPerSec = bytesIncomingPerSec;
            this.bytesOutgoingPerSec = bytesOutgoingPerSec;
            this.packetsIncomingPerSec = packetsIncomingPerSec;
            this.packetsOutgoingPerSec = packetsOutgoingPerSec;
            this.packetsIncomingErrors = packetsIncomingErrors;
            this.packetsOutgoingErrors = packetsOutgoingErrors;
            this.bytesTotalPerSec = bytesTotalPerSec;
            this.perfTicksPerSec = perfTicksPerSec;
            this.timestamp = timestamp;
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        protected NetworkInterfaceInfo() {
        }

        @Generated
        public static class NetworkInterfaceInfoBuilder {
            @Generated
            private String name;
            @Generated
            private int availability;
            @Generated
            private int netConnectionStatus;
            @Generated
            private long speed;
            @Generated
            private String netEnabled;
            @Generated
            private String fullDuplex;
            @Generated
            private String macAddress;
            @Generated
            private String ipAddress;
            @Generated
            private String ipSubnet;
            @Generated
            private String defaultIpGateway;
            @Generated
            private long mtu;
            @Generated
            private long bytesIncomingPerSec;
            @Generated
            private long bytesOutgoingPerSec;
            @Generated
            private long packetsIncomingPerSec;
            @Generated
            private long packetsOutgoingPerSec;
            @Generated
            private long packetsIncomingErrors;
            @Generated
            private long packetsOutgoingErrors;
            @Generated
            private BigInteger bytesTotalPerSec;
            @Generated
            private BigInteger perfTicksPerSec;
            @Generated
            private BigInteger timestamp;
            @Generated
            private BigInteger timestampTicksPerSec;

            @Generated
            NetworkInterfaceInfoBuilder() {
            }

            @Generated
            public NetworkInterfaceInfoBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder availability(int availability) {
                this.availability = availability;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder netConnectionStatus(int netConnectionStatus) {
                this.netConnectionStatus = netConnectionStatus;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder speed(long speed) {
                this.speed = speed;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder netEnabled(@NonNull String netEnabled) {
                if (netEnabled == null) {
                    throw new NullPointerException("netEnabled is marked non-null but is null");
                }
                this.netEnabled = netEnabled;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder fullDuplex(@NonNull String fullDuplex) {
                if (fullDuplex == null) {
                    throw new NullPointerException("fullDuplex is marked non-null but is null");
                }
                this.fullDuplex = fullDuplex;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder macAddress(@NonNull String macAddress) {
                if (macAddress == null) {
                    throw new NullPointerException("macAddress is marked non-null but is null");
                }
                this.macAddress = macAddress;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipAddress(@NonNull String ipAddress) {
                if (ipAddress == null) {
                    throw new NullPointerException("ipAddress is marked non-null but is null");
                }
                this.ipAddress = ipAddress;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipSubnet(@NonNull String ipSubnet) {
                if (ipSubnet == null) {
                    throw new NullPointerException("ipSubnet is marked non-null but is null");
                }
                this.ipSubnet = ipSubnet;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder defaultIpGateway(@NonNull String defaultIpGateway) {
                if (defaultIpGateway == null) {
                    throw new NullPointerException("defaultIpGateway is marked non-null but is null");
                }
                this.defaultIpGateway = defaultIpGateway;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder mtu(long mtu) {
                this.mtu = mtu;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder bytesIncomingPerSec(long bytesIncomingPerSec) {
                this.bytesIncomingPerSec = bytesIncomingPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder bytesOutgoingPerSec(long bytesOutgoingPerSec) {
                this.bytesOutgoingPerSec = bytesOutgoingPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder packetsIncomingPerSec(long packetsIncomingPerSec) {
                this.packetsIncomingPerSec = packetsIncomingPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder packetsOutgoingPerSec(long packetsOutgoingPerSec) {
                this.packetsOutgoingPerSec = packetsOutgoingPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder packetsIncomingErrors(long packetsIncomingErrors) {
                this.packetsIncomingErrors = packetsIncomingErrors;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder packetsOutgoingErrors(long packetsOutgoingErrors) {
                this.packetsOutgoingErrors = packetsOutgoingErrors;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder bytesTotalPerSec(BigInteger bytesTotalPerSec) {
                this.bytesTotalPerSec = bytesTotalPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder perfTicksPerSec(BigInteger perfTicksPerSec) {
                this.perfTicksPerSec = perfTicksPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder timestamp(BigInteger timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder timestampTicksPerSec(BigInteger timestampTicksPerSec) {
                this.timestampTicksPerSec = timestampTicksPerSec;
                return this;
            }

            @Generated
            public NetworkInterfaceInfo build() {
                return new NetworkInterfaceInfo(this.name, this.availability, this.netConnectionStatus, this.speed, this.netEnabled, this.fullDuplex, this.macAddress, this.ipAddress, this.ipSubnet, this.defaultIpGateway, this.mtu, this.bytesIncomingPerSec, this.bytesOutgoingPerSec, this.packetsIncomingPerSec, this.packetsOutgoingPerSec, this.packetsIncomingErrors, this.packetsOutgoingErrors, this.bytesTotalPerSec, this.perfTicksPerSec, this.timestamp, this.timestampTicksPerSec);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.NetworkInterfaceInfo.NetworkInterfaceInfoBuilder(name=" + this.name + ", availability=" + this.availability + ", netConnectionStatus=" + this.netConnectionStatus + ", speed=" + this.speed + ", netEnabled=" + this.netEnabled + ", fullDuplex=" + this.fullDuplex + ", macAddress=" + this.macAddress + ", ipAddress=" + this.ipAddress + ", ipSubnet=" + this.ipSubnet + ", defaultIpGateway=" + this.defaultIpGateway + ", mtu=" + this.mtu + ", bytesIncomingPerSec=" + this.bytesIncomingPerSec + ", bytesOutgoingPerSec=" + this.bytesOutgoingPerSec + ", packetsIncomingPerSec=" + this.packetsIncomingPerSec + ", packetsOutgoingPerSec=" + this.packetsOutgoingPerSec + ", packetsIncomingErrors=" + this.packetsIncomingErrors + ", packetsOutgoingErrors=" + this.packetsOutgoingErrors + ", bytesTotalPerSec=" + String.valueOf(this.bytesTotalPerSec) + ", perfTicksPerSec=" + String.valueOf(this.perfTicksPerSec) + ", timestamp=" + String.valueOf(this.timestamp) + ", timestampTicksPerSec=" + String.valueOf(this.timestampTicksPerSec) + ")";
            }
        }
    }

    static class TcpipInterface {
        @NonNull
        private String name;
        private long bytesIncomingPerSec;
        private long bytesOutgoingPerSec;
        private long packetsIncomingPerSec;
        private long packetsOutgoingPerSec;
        private long packetsIncomingErrors;
        private long packetsOutgoingErrors;
        private BigInteger bytesTotalPerSec;
        private BigInteger perfTicksPerSec;
        private BigInteger timestamp;
        private BigInteger timestampTicksPerSec;

        @Generated
        public static TcpipInterfaceBuilder builder() {
            return new TcpipInterfaceBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getBytesIncomingPerSec() {
            return this.bytesIncomingPerSec;
        }

        @Generated
        public long getBytesOutgoingPerSec() {
            return this.bytesOutgoingPerSec;
        }

        @Generated
        public long getPacketsIncomingPerSec() {
            return this.packetsIncomingPerSec;
        }

        @Generated
        public long getPacketsOutgoingPerSec() {
            return this.packetsOutgoingPerSec;
        }

        @Generated
        public long getPacketsIncomingErrors() {
            return this.packetsIncomingErrors;
        }

        @Generated
        public long getPacketsOutgoingErrors() {
            return this.packetsOutgoingErrors;
        }

        @Generated
        public BigInteger getBytesTotalPerSec() {
            return this.bytesTotalPerSec;
        }

        @Generated
        public BigInteger getPerfTicksPerSec() {
            return this.perfTicksPerSec;
        }

        @Generated
        public BigInteger getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public BigInteger getTimestampTicksPerSec() {
            return this.timestampTicksPerSec;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setBytesIncomingPerSec(long bytesIncomingPerSec) {
            this.bytesIncomingPerSec = bytesIncomingPerSec;
        }

        @Generated
        public void setBytesOutgoingPerSec(long bytesOutgoingPerSec) {
            this.bytesOutgoingPerSec = bytesOutgoingPerSec;
        }

        @Generated
        public void setPacketsIncomingPerSec(long packetsIncomingPerSec) {
            this.packetsIncomingPerSec = packetsIncomingPerSec;
        }

        @Generated
        public void setPacketsOutgoingPerSec(long packetsOutgoingPerSec) {
            this.packetsOutgoingPerSec = packetsOutgoingPerSec;
        }

        @Generated
        public void setPacketsIncomingErrors(long packetsIncomingErrors) {
            this.packetsIncomingErrors = packetsIncomingErrors;
        }

        @Generated
        public void setPacketsOutgoingErrors(long packetsOutgoingErrors) {
            this.packetsOutgoingErrors = packetsOutgoingErrors;
        }

        @Generated
        public void setBytesTotalPerSec(BigInteger bytesTotalPerSec) {
            this.bytesTotalPerSec = bytesTotalPerSec;
        }

        @Generated
        public void setPerfTicksPerSec(BigInteger perfTicksPerSec) {
            this.perfTicksPerSec = perfTicksPerSec;
        }

        @Generated
        public void setTimestamp(BigInteger timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setTimestampTicksPerSec(BigInteger timestampTicksPerSec) {
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TcpipInterface)) {
                return false;
            }
            TcpipInterface other = (TcpipInterface)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBytesIncomingPerSec() != other.getBytesIncomingPerSec()) {
                return false;
            }
            if (this.getBytesOutgoingPerSec() != other.getBytesOutgoingPerSec()) {
                return false;
            }
            if (this.getPacketsIncomingPerSec() != other.getPacketsIncomingPerSec()) {
                return false;
            }
            if (this.getPacketsOutgoingPerSec() != other.getPacketsOutgoingPerSec()) {
                return false;
            }
            if (this.getPacketsIncomingErrors() != other.getPacketsIncomingErrors()) {
                return false;
            }
            if (this.getPacketsOutgoingErrors() != other.getPacketsOutgoingErrors()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            BigInteger this$bytesTotalPerSec = this.getBytesTotalPerSec();
            BigInteger other$bytesTotalPerSec = other.getBytesTotalPerSec();
            if (this$bytesTotalPerSec == null ? other$bytesTotalPerSec != null : !((Object)this$bytesTotalPerSec).equals(other$bytesTotalPerSec)) {
                return false;
            }
            BigInteger this$perfTicksPerSec = this.getPerfTicksPerSec();
            BigInteger other$perfTicksPerSec = other.getPerfTicksPerSec();
            if (this$perfTicksPerSec == null ? other$perfTicksPerSec != null : !((Object)this$perfTicksPerSec).equals(other$perfTicksPerSec)) {
                return false;
            }
            BigInteger this$timestamp = this.getTimestamp();
            BigInteger other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            BigInteger this$timestampTicksPerSec = this.getTimestampTicksPerSec();
            BigInteger other$timestampTicksPerSec = other.getTimestampTicksPerSec();
            return !(this$timestampTicksPerSec == null ? other$timestampTicksPerSec != null : !((Object)this$timestampTicksPerSec).equals(other$timestampTicksPerSec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TcpipInterface;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $bytesIncomingPerSec = this.getBytesIncomingPerSec();
            result = result * 59 + (int)($bytesIncomingPerSec >>> 32 ^ $bytesIncomingPerSec);
            long $bytesOutgoingPerSec = this.getBytesOutgoingPerSec();
            result = result * 59 + (int)($bytesOutgoingPerSec >>> 32 ^ $bytesOutgoingPerSec);
            long $packetsIncomingPerSec = this.getPacketsIncomingPerSec();
            result = result * 59 + (int)($packetsIncomingPerSec >>> 32 ^ $packetsIncomingPerSec);
            long $packetsOutgoingPerSec = this.getPacketsOutgoingPerSec();
            result = result * 59 + (int)($packetsOutgoingPerSec >>> 32 ^ $packetsOutgoingPerSec);
            long $packetsIncomingErrors = this.getPacketsIncomingErrors();
            result = result * 59 + (int)($packetsIncomingErrors >>> 32 ^ $packetsIncomingErrors);
            long $packetsOutgoingErrors = this.getPacketsOutgoingErrors();
            result = result * 59 + (int)($packetsOutgoingErrors >>> 32 ^ $packetsOutgoingErrors);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            BigInteger $bytesTotalPerSec = this.getBytesTotalPerSec();
            result = result * 59 + ($bytesTotalPerSec == null ? 43 : ((Object)$bytesTotalPerSec).hashCode());
            BigInteger $perfTicksPerSec = this.getPerfTicksPerSec();
            result = result * 59 + ($perfTicksPerSec == null ? 43 : ((Object)$perfTicksPerSec).hashCode());
            BigInteger $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            BigInteger $timestampTicksPerSec = this.getTimestampTicksPerSec();
            result = result * 59 + ($timestampTicksPerSec == null ? 43 : ((Object)$timestampTicksPerSec).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.TcpipInterface(name=" + this.getName() + ", bytesIncomingPerSec=" + this.getBytesIncomingPerSec() + ", bytesOutgoingPerSec=" + this.getBytesOutgoingPerSec() + ", packetsIncomingPerSec=" + this.getPacketsIncomingPerSec() + ", packetsOutgoingPerSec=" + this.getPacketsOutgoingPerSec() + ", packetsIncomingErrors=" + this.getPacketsIncomingErrors() + ", packetsOutgoingErrors=" + this.getPacketsOutgoingErrors() + ", bytesTotalPerSec=" + String.valueOf(this.getBytesTotalPerSec()) + ", perfTicksPerSec=" + String.valueOf(this.getPerfTicksPerSec()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", timestampTicksPerSec=" + String.valueOf(this.getTimestampTicksPerSec()) + ")";
        }

        @Generated
        public TcpipInterface(@NonNull String name, long bytesIncomingPerSec, long bytesOutgoingPerSec, long packetsIncomingPerSec, long packetsOutgoingPerSec, long packetsIncomingErrors, long packetsOutgoingErrors, BigInteger bytesTotalPerSec, BigInteger perfTicksPerSec, BigInteger timestamp, BigInteger timestampTicksPerSec) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.bytesIncomingPerSec = bytesIncomingPerSec;
            this.bytesOutgoingPerSec = bytesOutgoingPerSec;
            this.packetsIncomingPerSec = packetsIncomingPerSec;
            this.packetsOutgoingPerSec = packetsOutgoingPerSec;
            this.packetsIncomingErrors = packetsIncomingErrors;
            this.packetsOutgoingErrors = packetsOutgoingErrors;
            this.bytesTotalPerSec = bytesTotalPerSec;
            this.perfTicksPerSec = perfTicksPerSec;
            this.timestamp = timestamp;
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        protected TcpipInterface() {
        }

        @Generated
        public static class TcpipInterfaceBuilder {
            @Generated
            private String name;
            @Generated
            private long bytesIncomingPerSec;
            @Generated
            private long bytesOutgoingPerSec;
            @Generated
            private long packetsIncomingPerSec;
            @Generated
            private long packetsOutgoingPerSec;
            @Generated
            private long packetsIncomingErrors;
            @Generated
            private long packetsOutgoingErrors;
            @Generated
            private BigInteger bytesTotalPerSec;
            @Generated
            private BigInteger perfTicksPerSec;
            @Generated
            private BigInteger timestamp;
            @Generated
            private BigInteger timestampTicksPerSec;

            @Generated
            TcpipInterfaceBuilder() {
            }

            @Generated
            public TcpipInterfaceBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder bytesIncomingPerSec(long bytesIncomingPerSec) {
                this.bytesIncomingPerSec = bytesIncomingPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder bytesOutgoingPerSec(long bytesOutgoingPerSec) {
                this.bytesOutgoingPerSec = bytesOutgoingPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder packetsIncomingPerSec(long packetsIncomingPerSec) {
                this.packetsIncomingPerSec = packetsIncomingPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder packetsOutgoingPerSec(long packetsOutgoingPerSec) {
                this.packetsOutgoingPerSec = packetsOutgoingPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder packetsIncomingErrors(long packetsIncomingErrors) {
                this.packetsIncomingErrors = packetsIncomingErrors;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder packetsOutgoingErrors(long packetsOutgoingErrors) {
                this.packetsOutgoingErrors = packetsOutgoingErrors;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder bytesTotalPerSec(BigInteger bytesTotalPerSec) {
                this.bytesTotalPerSec = bytesTotalPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder perfTicksPerSec(BigInteger perfTicksPerSec) {
                this.perfTicksPerSec = perfTicksPerSec;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder timestamp(BigInteger timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public TcpipInterfaceBuilder timestampTicksPerSec(BigInteger timestampTicksPerSec) {
                this.timestampTicksPerSec = timestampTicksPerSec;
                return this;
            }

            @Generated
            public TcpipInterface build() {
                return new TcpipInterface(this.name, this.bytesIncomingPerSec, this.bytesOutgoingPerSec, this.packetsIncomingPerSec, this.packetsOutgoingPerSec, this.packetsIncomingErrors, this.packetsOutgoingErrors, this.bytesTotalPerSec, this.perfTicksPerSec, this.timestamp, this.timestampTicksPerSec);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.TcpipInterface.TcpipInterfaceBuilder(name=" + this.name + ", bytesIncomingPerSec=" + this.bytesIncomingPerSec + ", bytesOutgoingPerSec=" + this.bytesOutgoingPerSec + ", packetsIncomingPerSec=" + this.packetsIncomingPerSec + ", packetsOutgoingPerSec=" + this.packetsOutgoingPerSec + ", packetsIncomingErrors=" + this.packetsIncomingErrors + ", packetsOutgoingErrors=" + this.packetsOutgoingErrors + ", bytesTotalPerSec=" + String.valueOf(this.bytesTotalPerSec) + ", perfTicksPerSec=" + String.valueOf(this.perfTicksPerSec) + ", timestamp=" + String.valueOf(this.timestamp) + ", timestampTicksPerSec=" + String.valueOf(this.timestampTicksPerSec) + ")";
            }
        }
    }

    static class NetworkAdapterConfig {
        @NonNull
        private String ipAddress;
        @NonNull
        private String ipSubnet;
        @NonNull
        private String defaultIpGateway;
        @NonNull
        private String macAddress;
        private long mtu;

        @Generated
        public static NetworkAdapterConfigBuilder builder() {
            return new NetworkAdapterConfigBuilder();
        }

        @NonNull
        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @NonNull
        @Generated
        public String getIpSubnet() {
            return this.ipSubnet;
        }

        @NonNull
        @Generated
        public String getDefaultIpGateway() {
            return this.defaultIpGateway;
        }

        @NonNull
        @Generated
        public String getMacAddress() {
            return this.macAddress;
        }

        @Generated
        public long getMtu() {
            return this.mtu;
        }

        @Generated
        public void setIpAddress(@NonNull String ipAddress) {
            if (ipAddress == null) {
                throw new NullPointerException("ipAddress is marked non-null but is null");
            }
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setIpSubnet(@NonNull String ipSubnet) {
            if (ipSubnet == null) {
                throw new NullPointerException("ipSubnet is marked non-null but is null");
            }
            this.ipSubnet = ipSubnet;
        }

        @Generated
        public void setDefaultIpGateway(@NonNull String defaultIpGateway) {
            if (defaultIpGateway == null) {
                throw new NullPointerException("defaultIpGateway is marked non-null but is null");
            }
            this.defaultIpGateway = defaultIpGateway;
        }

        @Generated
        public void setMacAddress(@NonNull String macAddress) {
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            this.macAddress = macAddress;
        }

        @Generated
        public void setMtu(long mtu) {
            this.mtu = mtu;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkAdapterConfig)) {
                return false;
            }
            NetworkAdapterConfig other = (NetworkAdapterConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMtu() != other.getMtu()) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$ipSubnet = this.getIpSubnet();
            String other$ipSubnet = other.getIpSubnet();
            if (this$ipSubnet == null ? other$ipSubnet != null : !this$ipSubnet.equals(other$ipSubnet)) {
                return false;
            }
            String this$defaultIpGateway = this.getDefaultIpGateway();
            String other$defaultIpGateway = other.getDefaultIpGateway();
            if (this$defaultIpGateway == null ? other$defaultIpGateway != null : !this$defaultIpGateway.equals(other$defaultIpGateway)) {
                return false;
            }
            String this$macAddress = this.getMacAddress();
            String other$macAddress = other.getMacAddress();
            return !(this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkAdapterConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $mtu = this.getMtu();
            result = result * 59 + (int)($mtu >>> 32 ^ $mtu);
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $ipSubnet = this.getIpSubnet();
            result = result * 59 + ($ipSubnet == null ? 43 : $ipSubnet.hashCode());
            String $defaultIpGateway = this.getDefaultIpGateway();
            result = result * 59 + ($defaultIpGateway == null ? 43 : $defaultIpGateway.hashCode());
            String $macAddress = this.getMacAddress();
            result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.NetworkAdapterConfig(ipAddress=" + this.getIpAddress() + ", ipSubnet=" + this.getIpSubnet() + ", defaultIpGateway=" + this.getDefaultIpGateway() + ", macAddress=" + this.getMacAddress() + ", mtu=" + this.getMtu() + ")";
        }

        @Generated
        public NetworkAdapterConfig(@NonNull String ipAddress, @NonNull String ipSubnet, @NonNull String defaultIpGateway, @NonNull String macAddress, long mtu) {
            if (ipAddress == null) {
                throw new NullPointerException("ipAddress is marked non-null but is null");
            }
            if (ipSubnet == null) {
                throw new NullPointerException("ipSubnet is marked non-null but is null");
            }
            if (defaultIpGateway == null) {
                throw new NullPointerException("defaultIpGateway is marked non-null but is null");
            }
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            this.ipAddress = ipAddress;
            this.ipSubnet = ipSubnet;
            this.defaultIpGateway = defaultIpGateway;
            this.macAddress = macAddress;
            this.mtu = mtu;
        }

        @Generated
        protected NetworkAdapterConfig() {
        }

        @Generated
        public static class NetworkAdapterConfigBuilder {
            @Generated
            private String ipAddress;
            @Generated
            private String ipSubnet;
            @Generated
            private String defaultIpGateway;
            @Generated
            private String macAddress;
            @Generated
            private long mtu;

            @Generated
            NetworkAdapterConfigBuilder() {
            }

            @Generated
            public NetworkAdapterConfigBuilder ipAddress(@NonNull String ipAddress) {
                if (ipAddress == null) {
                    throw new NullPointerException("ipAddress is marked non-null but is null");
                }
                this.ipAddress = ipAddress;
                return this;
            }

            @Generated
            public NetworkAdapterConfigBuilder ipSubnet(@NonNull String ipSubnet) {
                if (ipSubnet == null) {
                    throw new NullPointerException("ipSubnet is marked non-null but is null");
                }
                this.ipSubnet = ipSubnet;
                return this;
            }

            @Generated
            public NetworkAdapterConfigBuilder defaultIpGateway(@NonNull String defaultIpGateway) {
                if (defaultIpGateway == null) {
                    throw new NullPointerException("defaultIpGateway is marked non-null but is null");
                }
                this.defaultIpGateway = defaultIpGateway;
                return this;
            }

            @Generated
            public NetworkAdapterConfigBuilder macAddress(@NonNull String macAddress) {
                if (macAddress == null) {
                    throw new NullPointerException("macAddress is marked non-null but is null");
                }
                this.macAddress = macAddress;
                return this;
            }

            @Generated
            public NetworkAdapterConfigBuilder mtu(long mtu) {
                this.mtu = mtu;
                return this;
            }

            @Generated
            public NetworkAdapterConfig build() {
                return new NetworkAdapterConfig(this.ipAddress, this.ipSubnet, this.defaultIpGateway, this.macAddress, this.mtu);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.NetworkAdapterConfig.NetworkAdapterConfigBuilder(ipAddress=" + this.ipAddress + ", ipSubnet=" + this.ipSubnet + ", defaultIpGateway=" + this.defaultIpGateway + ", macAddress=" + this.macAddress + ", mtu=" + this.mtu + ")";
            }
        }
    }

    static class NetworkAdapter {
        @NonNull
        private String name;
        @NonNull
        private String netEnabled;
        private int availability;
        private int netConnectionStatus;
        @NonNull
        private String fullDuplex;
        @NonNull
        private String macAddress;
        @NonNull
        private String index;
        private long speed;

        @Generated
        public static NetworkAdapterBuilder builder() {
            return new NetworkAdapterBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public String getNetEnabled() {
            return this.netEnabled;
        }

        @Generated
        public int getAvailability() {
            return this.availability;
        }

        @Generated
        public int getNetConnectionStatus() {
            return this.netConnectionStatus;
        }

        @NonNull
        @Generated
        public String getFullDuplex() {
            return this.fullDuplex;
        }

        @NonNull
        @Generated
        public String getMacAddress() {
            return this.macAddress;
        }

        @NonNull
        @Generated
        public String getIndex() {
            return this.index;
        }

        @Generated
        public long getSpeed() {
            return this.speed;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setNetEnabled(@NonNull String netEnabled) {
            if (netEnabled == null) {
                throw new NullPointerException("netEnabled is marked non-null but is null");
            }
            this.netEnabled = netEnabled;
        }

        @Generated
        public void setAvailability(int availability) {
            this.availability = availability;
        }

        @Generated
        public void setNetConnectionStatus(int netConnectionStatus) {
            this.netConnectionStatus = netConnectionStatus;
        }

        @Generated
        public void setFullDuplex(@NonNull String fullDuplex) {
            if (fullDuplex == null) {
                throw new NullPointerException("fullDuplex is marked non-null but is null");
            }
            this.fullDuplex = fullDuplex;
        }

        @Generated
        public void setMacAddress(@NonNull String macAddress) {
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            this.macAddress = macAddress;
        }

        @Generated
        public void setIndex(@NonNull String index) {
            if (index == null) {
                throw new NullPointerException("index is marked non-null but is null");
            }
            this.index = index;
        }

        @Generated
        public void setSpeed(long speed) {
            this.speed = speed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkAdapter)) {
                return false;
            }
            NetworkAdapter other = (NetworkAdapter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAvailability() != other.getAvailability()) {
                return false;
            }
            if (this.getNetConnectionStatus() != other.getNetConnectionStatus()) {
                return false;
            }
            if (this.getSpeed() != other.getSpeed()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$netEnabled = this.getNetEnabled();
            String other$netEnabled = other.getNetEnabled();
            if (this$netEnabled == null ? other$netEnabled != null : !this$netEnabled.equals(other$netEnabled)) {
                return false;
            }
            String this$fullDuplex = this.getFullDuplex();
            String other$fullDuplex = other.getFullDuplex();
            if (this$fullDuplex == null ? other$fullDuplex != null : !this$fullDuplex.equals(other$fullDuplex)) {
                return false;
            }
            String this$macAddress = this.getMacAddress();
            String other$macAddress = other.getMacAddress();
            if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
                return false;
            }
            String this$index = this.getIndex();
            String other$index = other.getIndex();
            return !(this$index == null ? other$index != null : !this$index.equals(other$index));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkAdapter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAvailability();
            result = result * 59 + this.getNetConnectionStatus();
            long $speed = this.getSpeed();
            result = result * 59 + (int)($speed >>> 32 ^ $speed);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $netEnabled = this.getNetEnabled();
            result = result * 59 + ($netEnabled == null ? 43 : $netEnabled.hashCode());
            String $fullDuplex = this.getFullDuplex();
            result = result * 59 + ($fullDuplex == null ? 43 : $fullDuplex.hashCode());
            String $macAddress = this.getMacAddress();
            result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
            String $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : $index.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.NetworkAdapter(name=" + this.getName() + ", netEnabled=" + this.getNetEnabled() + ", availability=" + this.getAvailability() + ", netConnectionStatus=" + this.getNetConnectionStatus() + ", fullDuplex=" + this.getFullDuplex() + ", macAddress=" + this.getMacAddress() + ", index=" + this.getIndex() + ", speed=" + this.getSpeed() + ")";
        }

        @Generated
        public NetworkAdapter(@NonNull String name, @NonNull String netEnabled, int availability, int netConnectionStatus, @NonNull String fullDuplex, @NonNull String macAddress, @NonNull String index, long speed) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (netEnabled == null) {
                throw new NullPointerException("netEnabled is marked non-null but is null");
            }
            if (fullDuplex == null) {
                throw new NullPointerException("fullDuplex is marked non-null but is null");
            }
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            if (index == null) {
                throw new NullPointerException("index is marked non-null but is null");
            }
            this.name = name;
            this.netEnabled = netEnabled;
            this.availability = availability;
            this.netConnectionStatus = netConnectionStatus;
            this.fullDuplex = fullDuplex;
            this.macAddress = macAddress;
            this.index = index;
            this.speed = speed;
        }

        @Generated
        protected NetworkAdapter() {
        }

        @Generated
        public static class NetworkAdapterBuilder {
            @Generated
            private String name;
            @Generated
            private String netEnabled;
            @Generated
            private int availability;
            @Generated
            private int netConnectionStatus;
            @Generated
            private String fullDuplex;
            @Generated
            private String macAddress;
            @Generated
            private String index;
            @Generated
            private long speed;

            @Generated
            NetworkAdapterBuilder() {
            }

            @Generated
            public NetworkAdapterBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder netEnabled(@NonNull String netEnabled) {
                if (netEnabled == null) {
                    throw new NullPointerException("netEnabled is marked non-null but is null");
                }
                this.netEnabled = netEnabled;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder availability(int availability) {
                this.availability = availability;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder netConnectionStatus(int netConnectionStatus) {
                this.netConnectionStatus = netConnectionStatus;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder fullDuplex(@NonNull String fullDuplex) {
                if (fullDuplex == null) {
                    throw new NullPointerException("fullDuplex is marked non-null but is null");
                }
                this.fullDuplex = fullDuplex;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder macAddress(@NonNull String macAddress) {
                if (macAddress == null) {
                    throw new NullPointerException("macAddress is marked non-null but is null");
                }
                this.macAddress = macAddress;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder index(@NonNull String index) {
                if (index == null) {
                    throw new NullPointerException("index is marked non-null but is null");
                }
                this.index = index;
                return this;
            }

            @Generated
            public NetworkAdapterBuilder speed(long speed) {
                this.speed = speed;
                return this;
            }

            @Generated
            public NetworkAdapter build() {
                return new NetworkAdapter(this.name, this.netEnabled, this.availability, this.netConnectionStatus, this.fullDuplex, this.macAddress, this.index, this.speed);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.NetworkAdapter.NetworkAdapterBuilder(name=" + this.name + ", netEnabled=" + this.netEnabled + ", availability=" + this.availability + ", netConnectionStatus=" + this.netConnectionStatus + ", fullDuplex=" + this.fullDuplex + ", macAddress=" + this.macAddress + ", index=" + this.index + ", speed=" + this.speed + ")";
            }
        }
    }

    static class CpuPerf {
        private long timestamp;
        private long idleTicks;
        private long stealTicks;
        private long systemTicks;
        private long userTicks;

        @Generated
        public static CpuPerfBuilder builder() {
            return new CpuPerfBuilder();
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getIdleTicks() {
            return this.idleTicks;
        }

        @Generated
        public long getStealTicks() {
            return this.stealTicks;
        }

        @Generated
        public long getSystemTicks() {
            return this.systemTicks;
        }

        @Generated
        public long getUserTicks() {
            return this.userTicks;
        }

        @Generated
        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setIdleTicks(long idleTicks) {
            this.idleTicks = idleTicks;
        }

        @Generated
        public void setStealTicks(long stealTicks) {
            this.stealTicks = stealTicks;
        }

        @Generated
        public void setSystemTicks(long systemTicks) {
            this.systemTicks = systemTicks;
        }

        @Generated
        public void setUserTicks(long userTicks) {
            this.userTicks = userTicks;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuPerf)) {
                return false;
            }
            CpuPerf other = (CpuPerf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            if (this.getIdleTicks() != other.getIdleTicks()) {
                return false;
            }
            if (this.getStealTicks() != other.getStealTicks()) {
                return false;
            }
            if (this.getSystemTicks() != other.getSystemTicks()) {
                return false;
            }
            return this.getUserTicks() == other.getUserTicks();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CpuPerf;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            long $idleTicks = this.getIdleTicks();
            result = result * 59 + (int)($idleTicks >>> 32 ^ $idleTicks);
            long $stealTicks = this.getStealTicks();
            result = result * 59 + (int)($stealTicks >>> 32 ^ $stealTicks);
            long $systemTicks = this.getSystemTicks();
            result = result * 59 + (int)($systemTicks >>> 32 ^ $systemTicks);
            long $userTicks = this.getUserTicks();
            result = result * 59 + (int)($userTicks >>> 32 ^ $userTicks);
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.CpuPerf(timestamp=" + this.getTimestamp() + ", idleTicks=" + this.getIdleTicks() + ", stealTicks=" + this.getStealTicks() + ", systemTicks=" + this.getSystemTicks() + ", userTicks=" + this.getUserTicks() + ")";
        }

        @Generated
        public CpuPerf(long timestamp, long idleTicks, long stealTicks, long systemTicks, long userTicks) {
            this.timestamp = timestamp;
            this.idleTicks = idleTicks;
            this.stealTicks = stealTicks;
            this.systemTicks = systemTicks;
            this.userTicks = userTicks;
        }

        @Generated
        protected CpuPerf() {
        }

        @Generated
        public static class CpuPerfBuilder {
            @Generated
            private long timestamp;
            @Generated
            private long idleTicks;
            @Generated
            private long stealTicks;
            @Generated
            private long systemTicks;
            @Generated
            private long userTicks;

            @Generated
            CpuPerfBuilder() {
            }

            @Generated
            public CpuPerfBuilder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public CpuPerfBuilder idleTicks(long idleTicks) {
                this.idleTicks = idleTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder stealTicks(long stealTicks) {
                this.stealTicks = stealTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder systemTicks(long systemTicks) {
                this.systemTicks = systemTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder userTicks(long userTicks) {
                this.userTicks = userTicks;
                return this;
            }

            @Generated
            public CpuPerf build() {
                return new CpuPerf(this.timestamp, this.idleTicks, this.stealTicks, this.systemTicks, this.userTicks);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.CpuPerf.CpuPerfBuilder(timestamp=" + this.timestamp + ", idleTicks=" + this.idleTicks + ", stealTicks=" + this.stealTicks + ", systemTicks=" + this.systemTicks + ", userTicks=" + this.userTicks + ")";
            }
        }
    }

    static class Cpu {
        @NonNull
        private String cpuVendor;
        @NonNull
        private String cpuName;
        private int numCores;
        private int numLogicalProcessors;
        private long cpuMaxSpeedMhz;

        @Generated
        public static CpuBuilder builder() {
            return new CpuBuilder();
        }

        @NonNull
        @Generated
        public String getCpuVendor() {
            return this.cpuVendor;
        }

        @NonNull
        @Generated
        public String getCpuName() {
            return this.cpuName;
        }

        @Generated
        public int getNumCores() {
            return this.numCores;
        }

        @Generated
        public int getNumLogicalProcessors() {
            return this.numLogicalProcessors;
        }

        @Generated
        public long getCpuMaxSpeedMhz() {
            return this.cpuMaxSpeedMhz;
        }

        @Generated
        public void setCpuVendor(@NonNull String cpuVendor) {
            if (cpuVendor == null) {
                throw new NullPointerException("cpuVendor is marked non-null but is null");
            }
            this.cpuVendor = cpuVendor;
        }

        @Generated
        public void setCpuName(@NonNull String cpuName) {
            if (cpuName == null) {
                throw new NullPointerException("cpuName is marked non-null but is null");
            }
            this.cpuName = cpuName;
        }

        @Generated
        public void setNumCores(int numCores) {
            this.numCores = numCores;
        }

        @Generated
        public void setNumLogicalProcessors(int numLogicalProcessors) {
            this.numLogicalProcessors = numLogicalProcessors;
        }

        @Generated
        public void setCpuMaxSpeedMhz(long cpuMaxSpeedMhz) {
            this.cpuMaxSpeedMhz = cpuMaxSpeedMhz;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cpu)) {
                return false;
            }
            Cpu other = (Cpu)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumCores() != other.getNumCores()) {
                return false;
            }
            if (this.getNumLogicalProcessors() != other.getNumLogicalProcessors()) {
                return false;
            }
            if (this.getCpuMaxSpeedMhz() != other.getCpuMaxSpeedMhz()) {
                return false;
            }
            String this$cpuVendor = this.getCpuVendor();
            String other$cpuVendor = other.getCpuVendor();
            if (this$cpuVendor == null ? other$cpuVendor != null : !this$cpuVendor.equals(other$cpuVendor)) {
                return false;
            }
            String this$cpuName = this.getCpuName();
            String other$cpuName = other.getCpuName();
            return !(this$cpuName == null ? other$cpuName != null : !this$cpuName.equals(other$cpuName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cpu;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumCores();
            result = result * 59 + this.getNumLogicalProcessors();
            long $cpuMaxSpeedMhz = this.getCpuMaxSpeedMhz();
            result = result * 59 + (int)($cpuMaxSpeedMhz >>> 32 ^ $cpuMaxSpeedMhz);
            String $cpuVendor = this.getCpuVendor();
            result = result * 59 + ($cpuVendor == null ? 43 : $cpuVendor.hashCode());
            String $cpuName = this.getCpuName();
            result = result * 59 + ($cpuName == null ? 43 : $cpuName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.Cpu(cpuVendor=" + this.getCpuVendor() + ", cpuName=" + this.getCpuName() + ", numCores=" + this.getNumCores() + ", numLogicalProcessors=" + this.getNumLogicalProcessors() + ", cpuMaxSpeedMhz=" + this.getCpuMaxSpeedMhz() + ")";
        }

        @Generated
        public Cpu(@NonNull String cpuVendor, @NonNull String cpuName, int numCores, int numLogicalProcessors, long cpuMaxSpeedMhz) {
            if (cpuVendor == null) {
                throw new NullPointerException("cpuVendor is marked non-null but is null");
            }
            if (cpuName == null) {
                throw new NullPointerException("cpuName is marked non-null but is null");
            }
            this.cpuVendor = cpuVendor;
            this.cpuName = cpuName;
            this.numCores = numCores;
            this.numLogicalProcessors = numLogicalProcessors;
            this.cpuMaxSpeedMhz = cpuMaxSpeedMhz;
        }

        @Generated
        protected Cpu() {
        }

        @Generated
        public static class CpuBuilder {
            @Generated
            private String cpuVendor;
            @Generated
            private String cpuName;
            @Generated
            private int numCores;
            @Generated
            private int numLogicalProcessors;
            @Generated
            private long cpuMaxSpeedMhz;

            @Generated
            CpuBuilder() {
            }

            @Generated
            public CpuBuilder cpuVendor(@NonNull String cpuVendor) {
                if (cpuVendor == null) {
                    throw new NullPointerException("cpuVendor is marked non-null but is null");
                }
                this.cpuVendor = cpuVendor;
                return this;
            }

            @Generated
            public CpuBuilder cpuName(@NonNull String cpuName) {
                if (cpuName == null) {
                    throw new NullPointerException("cpuName is marked non-null but is null");
                }
                this.cpuName = cpuName;
                return this;
            }

            @Generated
            public CpuBuilder numCores(int numCores) {
                this.numCores = numCores;
                return this;
            }

            @Generated
            public CpuBuilder numLogicalProcessors(int numLogicalProcessors) {
                this.numLogicalProcessors = numLogicalProcessors;
                return this;
            }

            @Generated
            public CpuBuilder cpuMaxSpeedMhz(long cpuMaxSpeedMhz) {
                this.cpuMaxSpeedMhz = cpuMaxSpeedMhz;
                return this;
            }

            @Generated
            public Cpu build() {
                return new Cpu(this.cpuVendor, this.cpuName, this.numCores, this.numLogicalProcessors, this.cpuMaxSpeedMhz);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.Cpu.CpuBuilder(cpuVendor=" + this.cpuVendor + ", cpuName=" + this.cpuName + ", numCores=" + this.numCores + ", numLogicalProcessors=" + this.numLogicalProcessors + ", cpuMaxSpeedMhz=" + this.cpuMaxSpeedMhz + ")";
            }
        }
    }

    static class LogicalDisk {
        @NonNull
        private String name;
        private long sizeBytes;
        private long freeSpaceBytes;
        private int driveType;

        @Generated
        public static LogicalDiskBuilder builder() {
            return new LogicalDiskBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getSizeBytes() {
            return this.sizeBytes;
        }

        @Generated
        public long getFreeSpaceBytes() {
            return this.freeSpaceBytes;
        }

        @Generated
        public int getDriveType() {
            return this.driveType;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setSizeBytes(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        @Generated
        public void setFreeSpaceBytes(long freeSpaceBytes) {
            this.freeSpaceBytes = freeSpaceBytes;
        }

        @Generated
        public void setDriveType(int driveType) {
            this.driveType = driveType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogicalDisk)) {
                return false;
            }
            LogicalDisk other = (LogicalDisk)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSizeBytes() != other.getSizeBytes()) {
                return false;
            }
            if (this.getFreeSpaceBytes() != other.getFreeSpaceBytes()) {
                return false;
            }
            if (this.getDriveType() != other.getDriveType()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogicalDisk;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $sizeBytes = this.getSizeBytes();
            result = result * 59 + (int)($sizeBytes >>> 32 ^ $sizeBytes);
            long $freeSpaceBytes = this.getFreeSpaceBytes();
            result = result * 59 + (int)($freeSpaceBytes >>> 32 ^ $freeSpaceBytes);
            result = result * 59 + this.getDriveType();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.LogicalDisk(name=" + this.getName() + ", sizeBytes=" + this.getSizeBytes() + ", freeSpaceBytes=" + this.getFreeSpaceBytes() + ", driveType=" + this.getDriveType() + ")";
        }

        @Generated
        public LogicalDisk(@NonNull String name, long sizeBytes, long freeSpaceBytes, int driveType) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.sizeBytes = sizeBytes;
            this.freeSpaceBytes = freeSpaceBytes;
            this.driveType = driveType;
        }

        @Generated
        protected LogicalDisk() {
        }

        @Generated
        public static class LogicalDiskBuilder {
            @Generated
            private String name;
            @Generated
            private long sizeBytes;
            @Generated
            private long freeSpaceBytes;
            @Generated
            private int driveType;

            @Generated
            LogicalDiskBuilder() {
            }

            @Generated
            public LogicalDiskBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public LogicalDiskBuilder sizeBytes(long sizeBytes) {
                this.sizeBytes = sizeBytes;
                return this;
            }

            @Generated
            public LogicalDiskBuilder freeSpaceBytes(long freeSpaceBytes) {
                this.freeSpaceBytes = freeSpaceBytes;
                return this;
            }

            @Generated
            public LogicalDiskBuilder driveType(int driveType) {
                this.driveType = driveType;
                return this;
            }

            @Generated
            public LogicalDisk build() {
                return new LogicalDisk(this.name, this.sizeBytes, this.freeSpaceBytes, this.driveType);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.LogicalDisk.LogicalDiskBuilder(name=" + this.name + ", sizeBytes=" + this.sizeBytes + ", freeSpaceBytes=" + this.freeSpaceBytes + ", driveType=" + this.driveType + ")";
            }
        }
    }

    static class PerfLogicalDisk {
        @NonNull
        private String name;
        private long diskReadsPerSec;
        private BigInteger diskReadBytesPerSec;
        private long diskSecPerRead;
        private long diskSecPerReadBase;
        private long diskWritesPerSec;
        private BigInteger diskWriteBytesPerSec;
        private long diskSecPerWrite;
        private long diskSecPerWriteBase;
        private BigInteger diskUtilizationPct;
        private BigInteger diskUtilizationPctBase;
        private long freeSpaceMb;
        private int percentFreeSpace;
        private int percentFreeSpaceBase;
        private BigInteger perfTicksPerSec;
        private BigInteger timestamp;
        private BigInteger timestampTicksPerSec;

        @Generated
        public static PerfLogicalDiskBuilder builder() {
            return new PerfLogicalDiskBuilder();
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getDiskReadsPerSec() {
            return this.diskReadsPerSec;
        }

        @Generated
        public BigInteger getDiskReadBytesPerSec() {
            return this.diskReadBytesPerSec;
        }

        @Generated
        public long getDiskSecPerRead() {
            return this.diskSecPerRead;
        }

        @Generated
        public long getDiskSecPerReadBase() {
            return this.diskSecPerReadBase;
        }

        @Generated
        public long getDiskWritesPerSec() {
            return this.diskWritesPerSec;
        }

        @Generated
        public BigInteger getDiskWriteBytesPerSec() {
            return this.diskWriteBytesPerSec;
        }

        @Generated
        public long getDiskSecPerWrite() {
            return this.diskSecPerWrite;
        }

        @Generated
        public long getDiskSecPerWriteBase() {
            return this.diskSecPerWriteBase;
        }

        @Generated
        public BigInteger getDiskUtilizationPct() {
            return this.diskUtilizationPct;
        }

        @Generated
        public BigInteger getDiskUtilizationPctBase() {
            return this.diskUtilizationPctBase;
        }

        @Generated
        public long getFreeSpaceMb() {
            return this.freeSpaceMb;
        }

        @Generated
        public int getPercentFreeSpace() {
            return this.percentFreeSpace;
        }

        @Generated
        public int getPercentFreeSpaceBase() {
            return this.percentFreeSpaceBase;
        }

        @Generated
        public BigInteger getPerfTicksPerSec() {
            return this.perfTicksPerSec;
        }

        @Generated
        public BigInteger getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public BigInteger getTimestampTicksPerSec() {
            return this.timestampTicksPerSec;
        }

        @Generated
        public void setName(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @Generated
        public void setDiskReadsPerSec(long diskReadsPerSec) {
            this.diskReadsPerSec = diskReadsPerSec;
        }

        @Generated
        public void setDiskReadBytesPerSec(BigInteger diskReadBytesPerSec) {
            this.diskReadBytesPerSec = diskReadBytesPerSec;
        }

        @Generated
        public void setDiskSecPerRead(long diskSecPerRead) {
            this.diskSecPerRead = diskSecPerRead;
        }

        @Generated
        public void setDiskSecPerReadBase(long diskSecPerReadBase) {
            this.diskSecPerReadBase = diskSecPerReadBase;
        }

        @Generated
        public void setDiskWritesPerSec(long diskWritesPerSec) {
            this.diskWritesPerSec = diskWritesPerSec;
        }

        @Generated
        public void setDiskWriteBytesPerSec(BigInteger diskWriteBytesPerSec) {
            this.diskWriteBytesPerSec = diskWriteBytesPerSec;
        }

        @Generated
        public void setDiskSecPerWrite(long diskSecPerWrite) {
            this.diskSecPerWrite = diskSecPerWrite;
        }

        @Generated
        public void setDiskSecPerWriteBase(long diskSecPerWriteBase) {
            this.diskSecPerWriteBase = diskSecPerWriteBase;
        }

        @Generated
        public void setDiskUtilizationPct(BigInteger diskUtilizationPct) {
            this.diskUtilizationPct = diskUtilizationPct;
        }

        @Generated
        public void setDiskUtilizationPctBase(BigInteger diskUtilizationPctBase) {
            this.diskUtilizationPctBase = diskUtilizationPctBase;
        }

        @Generated
        public void setFreeSpaceMb(long freeSpaceMb) {
            this.freeSpaceMb = freeSpaceMb;
        }

        @Generated
        public void setPercentFreeSpace(int percentFreeSpace) {
            this.percentFreeSpace = percentFreeSpace;
        }

        @Generated
        public void setPercentFreeSpaceBase(int percentFreeSpaceBase) {
            this.percentFreeSpaceBase = percentFreeSpaceBase;
        }

        @Generated
        public void setPerfTicksPerSec(BigInteger perfTicksPerSec) {
            this.perfTicksPerSec = perfTicksPerSec;
        }

        @Generated
        public void setTimestamp(BigInteger timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setTimestampTicksPerSec(BigInteger timestampTicksPerSec) {
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PerfLogicalDisk)) {
                return false;
            }
            PerfLogicalDisk other = (PerfLogicalDisk)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDiskReadsPerSec() != other.getDiskReadsPerSec()) {
                return false;
            }
            if (this.getDiskSecPerRead() != other.getDiskSecPerRead()) {
                return false;
            }
            if (this.getDiskSecPerReadBase() != other.getDiskSecPerReadBase()) {
                return false;
            }
            if (this.getDiskWritesPerSec() != other.getDiskWritesPerSec()) {
                return false;
            }
            if (this.getDiskSecPerWrite() != other.getDiskSecPerWrite()) {
                return false;
            }
            if (this.getDiskSecPerWriteBase() != other.getDiskSecPerWriteBase()) {
                return false;
            }
            if (this.getFreeSpaceMb() != other.getFreeSpaceMb()) {
                return false;
            }
            if (this.getPercentFreeSpace() != other.getPercentFreeSpace()) {
                return false;
            }
            if (this.getPercentFreeSpaceBase() != other.getPercentFreeSpaceBase()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            BigInteger this$diskReadBytesPerSec = this.getDiskReadBytesPerSec();
            BigInteger other$diskReadBytesPerSec = other.getDiskReadBytesPerSec();
            if (this$diskReadBytesPerSec == null ? other$diskReadBytesPerSec != null : !((Object)this$diskReadBytesPerSec).equals(other$diskReadBytesPerSec)) {
                return false;
            }
            BigInteger this$diskWriteBytesPerSec = this.getDiskWriteBytesPerSec();
            BigInteger other$diskWriteBytesPerSec = other.getDiskWriteBytesPerSec();
            if (this$diskWriteBytesPerSec == null ? other$diskWriteBytesPerSec != null : !((Object)this$diskWriteBytesPerSec).equals(other$diskWriteBytesPerSec)) {
                return false;
            }
            BigInteger this$diskUtilizationPct = this.getDiskUtilizationPct();
            BigInteger other$diskUtilizationPct = other.getDiskUtilizationPct();
            if (this$diskUtilizationPct == null ? other$diskUtilizationPct != null : !((Object)this$diskUtilizationPct).equals(other$diskUtilizationPct)) {
                return false;
            }
            BigInteger this$diskUtilizationPctBase = this.getDiskUtilizationPctBase();
            BigInteger other$diskUtilizationPctBase = other.getDiskUtilizationPctBase();
            if (this$diskUtilizationPctBase == null ? other$diskUtilizationPctBase != null : !((Object)this$diskUtilizationPctBase).equals(other$diskUtilizationPctBase)) {
                return false;
            }
            BigInteger this$perfTicksPerSec = this.getPerfTicksPerSec();
            BigInteger other$perfTicksPerSec = other.getPerfTicksPerSec();
            if (this$perfTicksPerSec == null ? other$perfTicksPerSec != null : !((Object)this$perfTicksPerSec).equals(other$perfTicksPerSec)) {
                return false;
            }
            BigInteger this$timestamp = this.getTimestamp();
            BigInteger other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            BigInteger this$timestampTicksPerSec = this.getTimestampTicksPerSec();
            BigInteger other$timestampTicksPerSec = other.getTimestampTicksPerSec();
            return !(this$timestampTicksPerSec == null ? other$timestampTicksPerSec != null : !((Object)this$timestampTicksPerSec).equals(other$timestampTicksPerSec));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PerfLogicalDisk;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $diskReadsPerSec = this.getDiskReadsPerSec();
            result = result * 59 + (int)($diskReadsPerSec >>> 32 ^ $diskReadsPerSec);
            long $diskSecPerRead = this.getDiskSecPerRead();
            result = result * 59 + (int)($diskSecPerRead >>> 32 ^ $diskSecPerRead);
            long $diskSecPerReadBase = this.getDiskSecPerReadBase();
            result = result * 59 + (int)($diskSecPerReadBase >>> 32 ^ $diskSecPerReadBase);
            long $diskWritesPerSec = this.getDiskWritesPerSec();
            result = result * 59 + (int)($diskWritesPerSec >>> 32 ^ $diskWritesPerSec);
            long $diskSecPerWrite = this.getDiskSecPerWrite();
            result = result * 59 + (int)($diskSecPerWrite >>> 32 ^ $diskSecPerWrite);
            long $diskSecPerWriteBase = this.getDiskSecPerWriteBase();
            result = result * 59 + (int)($diskSecPerWriteBase >>> 32 ^ $diskSecPerWriteBase);
            long $freeSpaceMb = this.getFreeSpaceMb();
            result = result * 59 + (int)($freeSpaceMb >>> 32 ^ $freeSpaceMb);
            result = result * 59 + this.getPercentFreeSpace();
            result = result * 59 + this.getPercentFreeSpaceBase();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            BigInteger $diskReadBytesPerSec = this.getDiskReadBytesPerSec();
            result = result * 59 + ($diskReadBytesPerSec == null ? 43 : ((Object)$diskReadBytesPerSec).hashCode());
            BigInteger $diskWriteBytesPerSec = this.getDiskWriteBytesPerSec();
            result = result * 59 + ($diskWriteBytesPerSec == null ? 43 : ((Object)$diskWriteBytesPerSec).hashCode());
            BigInteger $diskUtilizationPct = this.getDiskUtilizationPct();
            result = result * 59 + ($diskUtilizationPct == null ? 43 : ((Object)$diskUtilizationPct).hashCode());
            BigInteger $diskUtilizationPctBase = this.getDiskUtilizationPctBase();
            result = result * 59 + ($diskUtilizationPctBase == null ? 43 : ((Object)$diskUtilizationPctBase).hashCode());
            BigInteger $perfTicksPerSec = this.getPerfTicksPerSec();
            result = result * 59 + ($perfTicksPerSec == null ? 43 : ((Object)$perfTicksPerSec).hashCode());
            BigInteger $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            BigInteger $timestampTicksPerSec = this.getTimestampTicksPerSec();
            result = result * 59 + ($timestampTicksPerSec == null ? 43 : ((Object)$timestampTicksPerSec).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WindowsRawData.PerfLogicalDisk(name=" + this.getName() + ", diskReadsPerSec=" + this.getDiskReadsPerSec() + ", diskReadBytesPerSec=" + String.valueOf(this.getDiskReadBytesPerSec()) + ", diskSecPerRead=" + this.getDiskSecPerRead() + ", diskSecPerReadBase=" + this.getDiskSecPerReadBase() + ", diskWritesPerSec=" + this.getDiskWritesPerSec() + ", diskWriteBytesPerSec=" + String.valueOf(this.getDiskWriteBytesPerSec()) + ", diskSecPerWrite=" + this.getDiskSecPerWrite() + ", diskSecPerWriteBase=" + this.getDiskSecPerWriteBase() + ", diskUtilizationPct=" + String.valueOf(this.getDiskUtilizationPct()) + ", diskUtilizationPctBase=" + String.valueOf(this.getDiskUtilizationPctBase()) + ", freeSpaceMb=" + this.getFreeSpaceMb() + ", percentFreeSpace=" + this.getPercentFreeSpace() + ", percentFreeSpaceBase=" + this.getPercentFreeSpaceBase() + ", perfTicksPerSec=" + String.valueOf(this.getPerfTicksPerSec()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", timestampTicksPerSec=" + String.valueOf(this.getTimestampTicksPerSec()) + ")";
        }

        @Generated
        public PerfLogicalDisk(@NonNull String name, long diskReadsPerSec, BigInteger diskReadBytesPerSec, long diskSecPerRead, long diskSecPerReadBase, long diskWritesPerSec, BigInteger diskWriteBytesPerSec, long diskSecPerWrite, long diskSecPerWriteBase, BigInteger diskUtilizationPct, BigInteger diskUtilizationPctBase, long freeSpaceMb, int percentFreeSpace, int percentFreeSpaceBase, BigInteger perfTicksPerSec, BigInteger timestamp, BigInteger timestampTicksPerSec) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.diskReadsPerSec = diskReadsPerSec;
            this.diskReadBytesPerSec = diskReadBytesPerSec;
            this.diskSecPerRead = diskSecPerRead;
            this.diskSecPerReadBase = diskSecPerReadBase;
            this.diskWritesPerSec = diskWritesPerSec;
            this.diskWriteBytesPerSec = diskWriteBytesPerSec;
            this.diskSecPerWrite = diskSecPerWrite;
            this.diskSecPerWriteBase = diskSecPerWriteBase;
            this.diskUtilizationPct = diskUtilizationPct;
            this.diskUtilizationPctBase = diskUtilizationPctBase;
            this.freeSpaceMb = freeSpaceMb;
            this.percentFreeSpace = percentFreeSpace;
            this.percentFreeSpaceBase = percentFreeSpaceBase;
            this.perfTicksPerSec = perfTicksPerSec;
            this.timestamp = timestamp;
            this.timestampTicksPerSec = timestampTicksPerSec;
        }

        @Generated
        protected PerfLogicalDisk() {
        }

        @Generated
        public static class PerfLogicalDiskBuilder {
            @Generated
            private String name;
            @Generated
            private long diskReadsPerSec;
            @Generated
            private BigInteger diskReadBytesPerSec;
            @Generated
            private long diskSecPerRead;
            @Generated
            private long diskSecPerReadBase;
            @Generated
            private long diskWritesPerSec;
            @Generated
            private BigInteger diskWriteBytesPerSec;
            @Generated
            private long diskSecPerWrite;
            @Generated
            private long diskSecPerWriteBase;
            @Generated
            private BigInteger diskUtilizationPct;
            @Generated
            private BigInteger diskUtilizationPctBase;
            @Generated
            private long freeSpaceMb;
            @Generated
            private int percentFreeSpace;
            @Generated
            private int percentFreeSpaceBase;
            @Generated
            private BigInteger perfTicksPerSec;
            @Generated
            private BigInteger timestamp;
            @Generated
            private BigInteger timestampTicksPerSec;

            @Generated
            PerfLogicalDiskBuilder() {
            }

            @Generated
            public PerfLogicalDiskBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskReadsPerSec(long diskReadsPerSec) {
                this.diskReadsPerSec = diskReadsPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskReadBytesPerSec(BigInteger diskReadBytesPerSec) {
                this.diskReadBytesPerSec = diskReadBytesPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskSecPerRead(long diskSecPerRead) {
                this.diskSecPerRead = diskSecPerRead;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskSecPerReadBase(long diskSecPerReadBase) {
                this.diskSecPerReadBase = diskSecPerReadBase;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskWritesPerSec(long diskWritesPerSec) {
                this.diskWritesPerSec = diskWritesPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskWriteBytesPerSec(BigInteger diskWriteBytesPerSec) {
                this.diskWriteBytesPerSec = diskWriteBytesPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskSecPerWrite(long diskSecPerWrite) {
                this.diskSecPerWrite = diskSecPerWrite;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskSecPerWriteBase(long diskSecPerWriteBase) {
                this.diskSecPerWriteBase = diskSecPerWriteBase;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskUtilizationPct(BigInteger diskUtilizationPct) {
                this.diskUtilizationPct = diskUtilizationPct;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder diskUtilizationPctBase(BigInteger diskUtilizationPctBase) {
                this.diskUtilizationPctBase = diskUtilizationPctBase;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder freeSpaceMb(long freeSpaceMb) {
                this.freeSpaceMb = freeSpaceMb;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder percentFreeSpace(int percentFreeSpace) {
                this.percentFreeSpace = percentFreeSpace;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder percentFreeSpaceBase(int percentFreeSpaceBase) {
                this.percentFreeSpaceBase = percentFreeSpaceBase;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder perfTicksPerSec(BigInteger perfTicksPerSec) {
                this.perfTicksPerSec = perfTicksPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder timestamp(BigInteger timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public PerfLogicalDiskBuilder timestampTicksPerSec(BigInteger timestampTicksPerSec) {
                this.timestampTicksPerSec = timestampTicksPerSec;
                return this;
            }

            @Generated
            public PerfLogicalDisk build() {
                return new PerfLogicalDisk(this.name, this.diskReadsPerSec, this.diskReadBytesPerSec, this.diskSecPerRead, this.diskSecPerReadBase, this.diskWritesPerSec, this.diskWriteBytesPerSec, this.diskSecPerWrite, this.diskSecPerWriteBase, this.diskUtilizationPct, this.diskUtilizationPctBase, this.freeSpaceMb, this.percentFreeSpace, this.percentFreeSpaceBase, this.perfTicksPerSec, this.timestamp, this.timestampTicksPerSec);
            }

            @Generated
            public String toString() {
                return "WindowsRawData.PerfLogicalDisk.PerfLogicalDiskBuilder(name=" + this.name + ", diskReadsPerSec=" + this.diskReadsPerSec + ", diskReadBytesPerSec=" + String.valueOf(this.diskReadBytesPerSec) + ", diskSecPerRead=" + this.diskSecPerRead + ", diskSecPerReadBase=" + this.diskSecPerReadBase + ", diskWritesPerSec=" + this.diskWritesPerSec + ", diskWriteBytesPerSec=" + String.valueOf(this.diskWriteBytesPerSec) + ", diskSecPerWrite=" + this.diskSecPerWrite + ", diskSecPerWriteBase=" + this.diskSecPerWriteBase + ", diskUtilizationPct=" + String.valueOf(this.diskUtilizationPct) + ", diskUtilizationPctBase=" + String.valueOf(this.diskUtilizationPctBase) + ", freeSpaceMb=" + this.freeSpaceMb + ", percentFreeSpace=" + this.percentFreeSpace + ", percentFreeSpaceBase=" + this.percentFreeSpaceBase + ", perfTicksPerSec=" + String.valueOf(this.perfTicksPerSec) + ", timestamp=" + String.valueOf(this.timestamp) + ", timestampTicksPerSec=" + String.valueOf(this.timestampTicksPerSec) + ")";
            }
        }
    }
}

