/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Load;
import com.appdynamics.sim.agent.extensions.servers.model.PerfLoadAverageCalc;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import lombok.Generated;
import lombok.NonNull;

class WindowsLoad
extends Load<WindowsRawData> {
    private static final double AVERAGE_MULTIPLIER = 100.0;
    private static final double INTERVAL_1_MINUTE_IN_SECONDS = 60.0;
    private static final double INTERVAL_5_MINUTE_IN_SECONDS = 300.0;
    private static final double INTERVAL_15_MINUTE_IN_SECONDS = 900.0;
    private PerfLoadAverageCalc loadAverage1;
    private PerfLoadAverageCalc loadAverage5;
    private PerfLoadAverageCalc loadAverage15;
    private long samplingFrequencyMillis;
    private Provider<ServersMonitorConfig> serversMonitorConfig;
    private final RawDataFactory rawDataFactory;

    @Inject
    WindowsLoad(@NonNull Provider<ServersMonitorConfig> monitorConfig, @Sim @NonNull MetricsService metricsService, Predicate<ToggleableReporter<WindowsRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("WindowsLoad", metricsService, isDisabledPredicate);
        if (monitorConfig == null) {
            throw new NullPointerException("monitorConfig is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.serversMonitorConfig = monitorConfig;
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        if (rawData.getLoad() != null) {
            if (this.loadAverage1 == null || ((ServersMonitorConfig)this.serversMonitorConfig.get()).getSamplingInterval() != this.samplingFrequencyMillis) {
                this.samplingFrequencyMillis = ((ServersMonitorConfig)this.serversMonitorConfig.get()).getSamplingInterval();
                long samplingFrequencySeconds = this.samplingFrequencyMillis / 1000L;
                this.loadAverage1 = new PerfLoadAverageCalc(samplingFrequencySeconds, 60.0);
                this.loadAverage5 = new PerfLoadAverageCalc(samplingFrequencySeconds, 300.0);
                this.loadAverage15 = new PerfLoadAverageCalc(samplingFrequencySeconds, 900.0);
            }
            long pql = rawData.getLoad().getProcessorQueueLength();
            this.loadAverage1.calculate(pql);
            this.loadAverage5.calculate(pql);
            this.loadAverage15.calculate(pql);
        }
    }

    @Override
    public void report(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        if (rawData.getLoad() != null) {
            super.report(rawData, reportMetricsConfig);
        }
    }

    @Override
    protected RawDataLong getLoadAverage1() {
        double loadAverage = this.loadAverage1.getLoadAverage();
        return this.rawDataFactory.createLong(Long.valueOf(UnknownValueUtil.calculatedValueOrUnknown((long)loadAverage, Math.round(loadAverage * 100.0))));
    }

    @Override
    protected RawDataLong getLoadAverage5() {
        double loadAverage = this.loadAverage5.getLoadAverage();
        return this.rawDataFactory.createLong(Long.valueOf(UnknownValueUtil.calculatedValueOrUnknown((long)loadAverage, Math.round(loadAverage * 100.0))));
    }

    @Override
    protected RawDataLong getLoadAverage15() {
        double loadAverage = this.loadAverage15.getLoadAverage();
        return this.rawDataFactory.createLong(Long.valueOf(UnknownValueUtil.calculatedValueOrUnknown((long)loadAverage, Math.round(loadAverage * 100.0))));
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsLoad(super=" + super.toString() + ", loadAverage1=" + String.valueOf(this.getLoadAverage1()) + ", loadAverage5=" + String.valueOf(this.getLoadAverage5()) + ", loadAverage15=" + String.valueOf(this.getLoadAverage15()) + ", samplingFrequencyMillis=" + this.samplingFrequencyMillis + ", serversMonitorConfig=" + String.valueOf(this.serversMonitorConfig) + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ")";
    }
}

