/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import lombok.Generated;

class WindowsCpu
extends Cpu<WindowsRawData> {
    private final RawDataFactory factory;
    private WindowsRawData.Cpu cpu;

    @Inject
    private WindowsCpu(@Assisted String cpuId, @Sim MachineProperties machineProperties, RawDataItemUtil rawDataItemUtil, RawDataFactory factory) {
        super(cpuId, machineProperties, rawDataItemUtil);
        this.factory = factory;
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpu = rawData.getCpus().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.factory.createLong(Long.valueOf(this.cpu.getNumLogicalProcessors()));
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.factory.createLong(Long.valueOf(this.cpu.getNumCores()));
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.factory.createString(Optional.of((Object)this.cpu.getCpuVendor()));
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.factory.createString(Optional.of((Object)this.cpu.getCpuName()));
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        Optional value = Optional.of((Object)String.valueOf(this.cpu.getCpuMaxSpeedMhz()));
        return this.factory.createString(value);
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        return this.factory.createString(Optional.absent());
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsCpu(super=" + super.toString() + ", factory=" + String.valueOf(this.factory) + ", cpu=" + String.valueOf(this.cpu) + ")";
    }
}

