/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.agent.extensions.servers.util.WraparoundCalculator;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Set;
import lombok.Generated;

class PerfProcessValue {
    public static final BigInteger PERCENT = BigInteger.valueOf(100L);
    private ImmutableMap<Integer, BigInteger> previousPidToValue;
    private BigInteger previousInputBase;
    private final WraparoundCalculator wraparoundCalculator;
    private long lastCookedResult;

    long calculate(ImmutableMap<Integer, BigInteger> inputMap, BigInteger base, BigInteger multiplier, Set<Integer> filteredProcessIdSet) {
        BigInteger firstInput = (BigInteger)inputMap.values().asList().get(0);
        if (UnknownValueUtil.isUnknownValue(firstInput, base)) {
            this.lastCookedResult = UnknownValueUtil.getUnknownValue();
            return this.lastCookedResult;
        }
        if (this.previousInputBase != null) {
            if (base.equals(this.previousInputBase)) {
                return this.lastCookedResult;
            }
            BigInteger previousProcTime = BigInteger.ZERO;
            BigInteger currentProctime = BigInteger.ZERO;
            for (int pid : filteredProcessIdSet) {
                if (!inputMap.containsKey((Object)pid)) continue;
                currentProctime = currentProctime.add((BigInteger)inputMap.get((Object)pid));
                if (!this.previousPidToValue.containsKey((Object)pid)) continue;
                previousProcTime = previousProcTime.add((BigInteger)this.previousPidToValue.get((Object)pid));
            }
            BigInteger inputDifference = this.wraparoundCalculator.calculateDifference(currentProctime, previousProcTime);
            BigInteger baseDifference = this.wraparoundCalculator.calculateDifference(base, this.previousInputBase);
            this.lastCookedResult = multiplier.multiply(inputDifference).divide(baseDifference).longValue();
        }
        this.previousPidToValue = inputMap;
        this.previousInputBase = base;
        return this.lastCookedResult;
    }

    long calculate(ImmutableMap<Integer, BigInteger> inputMap, BigInteger base, BigInteger multiplier) {
        return this.calculate(inputMap, base, multiplier, (Set<Integer>)inputMap.keySet());
    }

    @Generated
    public String toString() {
        return "PerfProcessValue(previousPidToValue=" + String.valueOf(this.previousPidToValue) + ", previousInputBase=" + String.valueOf(this.previousInputBase) + ", wraparoundCalculator=" + String.valueOf(this.wraparoundCalculator) + ", lastCookedResult=" + this.getLastCookedResult() + ")";
    }

    @Generated
    public PerfProcessValue(WraparoundCalculator wraparoundCalculator) {
        this.wraparoundCalculator = wraparoundCalculator;
    }

    @Generated
    public long getLastCookedResult() {
        return this.lastCookedResult;
    }
}

