/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.transformer;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.TransformerConfig;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MonitoredProcessClassCommandLineTransformer<RAWDATA>
extends Transformer<MonitoredProcessClass<RAWDATA>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoredProcessClassCommandLineTransformer.class);
    static final String CONFIG_SUPPLIER_NAME = "ProcessCommandLineTransformer";
    private final Supplier<List<TransformerConfig>> transformerConfigsSupplier;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    MonitoredProcessClassCommandLineTransformer(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @Named(value="ProcessCommandLineTransformer") @NonNull Supplier<List<TransformerConfig>> transformerConfigsSupplier) {
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (transformerConfigsSupplier == null) {
            throw new NullPointerException("transformerConfigsSupplier is marked non-null but is null");
        }
        this.repetitiveLogger = repetitiveLogger;
        this.transformerConfigsSupplier = transformerConfigsSupplier;
    }

    @Override
    public void apply(@NonNull Collection<MonitoredProcessClass<RAWDATA>> components) {
        if (components == null) {
            throw new NullPointerException("components is marked non-null but is null");
        }
        List transformerConfigs = (List)this.transformerConfigsSupplier.get();
        if (transformerConfigs.isEmpty()) {
            return;
        }
        for (MonitoredProcessClass<RAWDATA> component : components) {
            List<SimProcessObservationDto> filteredObservations = component.getFilteredObservations();
            for (SimProcessObservationDto observation : filteredObservations) {
                String transformedCommandLine = observation.getCommandLine();
                for (TransformerConfig config : transformerConfigs) {
                    try {
                        transformedCommandLine = this.getTransformedCommandLine(transformedCommandLine, config);
                    }
                    catch (RuntimeException e) {
                        this.repetitiveLogger.warn(log, "Error executing command line transformer using the pattern: " + config.getPattern().pattern() + ". Reason: " + e.getMessage(), new Object[0]);
                        log.trace("Error executing transformer on command line: " + transformedCommandLine);
                    }
                }
                observation.setCommandLine(transformedCommandLine);
            }
        }
    }

    @VisibleForTesting
    String getTransformedCommandLine(String commandLine, TransformerConfig config) {
        StringBuilder transformedCommandLineBuilder = new StringBuilder();
        String remaining = commandLine;
        Optional prevRemaining = Optional.absent();
        while (remaining.length() > 0) {
            Matcher matcher = config.getPattern().matcher(remaining);
            if (matcher.find()) {
                int endIndex;
                Optional<MaskBoundaries> maskBoundariesOpt = this.getBoundariesForFirstMatchToBeMasked(matcher, config.getReplaceAtGroupNumbers());
                if (maskBoundariesOpt.isPresent()) {
                    MaskBoundaries maskBoundaries = (MaskBoundaries)maskBoundariesOpt.get();
                    String partBefore = remaining.substring(0, maskBoundaries.getStartIndex());
                    transformedCommandLineBuilder.append(partBefore);
                    transformedCommandLineBuilder.append(config.getReplaceWith());
                    endIndex = maskBoundaries.getEndIndex();
                } else {
                    endIndex = matcher.end();
                    String unmatchedPart = remaining.substring(0, endIndex);
                    transformedCommandLineBuilder.append(unmatchedPart);
                }
                remaining = remaining.substring(endIndex);
                if (prevRemaining.isPresent() && remaining.length() >= ((String)prevRemaining.get()).length()) {
                    this.repetitiveLogger.warn(log, "Skipping command line transformer with the pattern: " + config.getPattern().pattern(), new Object[0]);
                    log.trace("Transformer was skipped for command line:" + commandLine);
                    break;
                }
                prevRemaining = Optional.of((Object)remaining);
                continue;
            }
            transformedCommandLineBuilder.append(remaining);
            break;
        }
        return transformedCommandLineBuilder.toString();
    }

    private Optional<MaskBoundaries> getBoundariesForFirstMatchToBeMasked(Matcher matcher, List<Integer> groups) {
        Optional result;
        if (groups.isEmpty()) {
            int matchStartIndex = matcher.start();
            if (matchStartIndex >= 0) {
                int matchEndIndex = matcher.end();
                result = Optional.of((Object)new MaskBoundaries(matchStartIndex, matchEndIndex));
            } else {
                result = Optional.absent();
            }
        } else {
            result = this.getBoundariesForFirstMatchingGroupToBeMasked(matcher, groups);
        }
        return result;
    }

    private Optional<MaskBoundaries> getBoundariesForFirstMatchingGroupToBeMasked(Matcher matcher, List<Integer> groups) {
        for (int groupNumber : groups) {
            int matchStartIndex;
            if (groupNumber < 1 || groupNumber > matcher.groupCount() || (matchStartIndex = matcher.start(groupNumber)) < 0) continue;
            int matchEndIndex = matcher.end(groupNumber);
            return Optional.of((Object)new MaskBoundaries(matchStartIndex, matchEndIndex));
        }
        return Optional.absent();
    }

    private static class MaskBoundaries {
        private final int startIndex;
        private final int endIndex;

        @Generated
        public MaskBoundaries(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Generated
        public int getStartIndex() {
            return this.startIndex;
        }

        @Generated
        public int getEndIndex() {
            return this.endIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaskBoundaries)) {
                return false;
            }
            MaskBoundaries other = (MaskBoundaries)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartIndex() != other.getStartIndex()) {
                return false;
            }
            return this.getEndIndex() == other.getEndIndex();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MaskBoundaries;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartIndex();
            result = result * 59 + this.getEndIndex();
            return result;
        }

        @Generated
        public String toString() {
            return "MonitoredProcessClassCommandLineTransformer.MaskBoundaries(startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ")";
        }
    }
}

