/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolarisVolumesUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolarisVolumesUtil.class);
    private static final Pattern RPOOL_NAME = Pattern.compile("^(?i)rpool.*");
    private static final char SIZE_TB = 'T';
    private static final char SIZE_GB = 'G';
    private static final char SIZE_MB = 'M';
    private static final char SIZE_KB = 'K';
    private static final int KB_PER_MB = 1024;
    private static final int BYTES_PER_KB = 1024;
    private static final long NO_SIZE = 0L;

    private SolarisVolumesUtil() {
    }

    static Optional<String> getPartitionNameFromPath(@NonNull Optional<String> pathOpt) {
        if (pathOpt == null) {
            throw new NullPointerException("pathOpt is marked non-null but is null");
        }
        String path = (String)pathOpt.orNull();
        if (StringUtils.isEmpty((CharSequence)path)) {
            log.debug("Could not get partition name from path because the path is empty");
            return Optional.absent();
        }
        List<String> tokens = Arrays.asList(path.split("/"));
        int indexOfDsk = tokens.indexOf("dsk");
        if (indexOfDsk != -1 && tokens.size() > indexOfDsk + 1) {
            return Optional.of((Object)FilenameUtils.getBaseName((String)path));
        }
        return pathOpt;
    }

    static String getDiskLabelFromPartitionPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            log.debug("Could not get disk label from partition path because the path is empty");
            return path;
        }
        List<String> tokens = Arrays.asList(path.split("/"));
        int indexOfDsk = tokens.indexOf("dsk");
        if (indexOfDsk != -1 && tokens.size() > indexOfDsk + 1) {
            return tokens.get(indexOfDsk + 1);
        }
        return path;
    }

    static boolean isRpool(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return RPOOL_NAME.matcher(name.trim()).find();
    }

    static long getbytesFromData(@NonNull String data, String volumeName) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        String nonStringvalue = data.substring(0, data.length() - 1);
        if (StringUtils.isEmpty((CharSequence)data)) {
            log.debug("The value of writesPerSec was reported as empty", (Object)volumeName);
            return 0L;
        }
        char stringPart = data.charAt(data.length() - 1);
        if (Character.isLetter(stringPart)) {
            String numberPart = data.substring(0, data.length() - 1);
            double sizeDouble = Double.parseDouble(numberPart);
            switch (stringPart) {
                case 'T': {
                    sizeDouble *= 0.0;
                    break;
                }
                case 'G': {
                    sizeDouble *= 1.073741824E9;
                    break;
                }
                case 'M': {
                    sizeDouble *= 1048576.0;
                    break;
                }
                case 'K': {
                    sizeDouble *= 1024.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid size: " + stringPart);
                }
            }
            return Math.round(sizeDouble);
        }
        return Math.round(Double.parseDouble(data));
    }

    static long getKbsFromSize(@NonNull String size, String volumeName) {
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        if (StringUtils.isEmpty((CharSequence)size)) {
            log.debug("The size of {} was reported as empty", (Object)volumeName);
            return 0L;
        }
        char stringPart = size.charAt(size.length() - 1);
        if (!SolarisVolumesUtil.isRpool(volumeName)) {
            if (Character.isLetter(stringPart)) {
                log.debug("Size units cannot be specified for non rpools: {}", (Object)size);
            }
            return Math.round(Double.parseDouble(size));
        }
        if (Character.isLetter(stringPart)) {
            String numberPart = size.substring(0, size.length() - 1);
            double sizeDouble = Double.parseDouble(numberPart);
            switch (stringPart) {
                case 'T': {
                    sizeDouble *= 1.073741824E9;
                    break;
                }
                case 'G': {
                    sizeDouble *= 1048576.0;
                    break;
                }
                case 'M': {
                    sizeDouble *= 1024.0;
                    break;
                }
                case 'K': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid size: " + stringPart);
                }
            }
            return Math.round(sizeDouble);
        }
        return Math.round(Double.parseDouble(size) / 1024.0);
    }
}

