/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.collector.RawCollectorUtil;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisVolumesUtil;
import com.appdynamics.sim.agent.extensions.servers.util.NixUtils;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolarisRawCollector
implements RawCollector<SolarisRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolarisRawCollector.class);
    private static final String RUN_COLLECTOR = "run_collector";
    private static final SolarisRawData EMPTY_RAW_DATA = new SolarisRawData();
    private static final String CDROM_DISK_LABEL_REGEX = "c\\dt\\dd\\d";
    private static final String ZOMBIE_STATE = "Z";
    static final String UNKNOWN = "unknown";
    private final ObjectMapper objectMapper;
    private final ProcessClassIdCreator processClassIdCreator;
    private final Optional<RawCollectorUtil.ICollectorProcessBuilder> processBuilder;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final RawCollectorUtil rawCollectorUtil;

    @Inject
    SolarisRawCollector(ObjectMapper objectMapper, ProcessClassIdCreator processClassIdCreator, Optional<RawCollectorUtil.ICollectorProcessBuilder> collectorProcessBuilder, SimAgentRepetitiveLogger repetitiveLogger, RawCollectorUtil rawCollectorUtil) throws IOException {
        this.objectMapper = objectMapper;
        this.processBuilder = collectorProcessBuilder;
        this.processClassIdCreator = processClassIdCreator;
        this.repetitiveLogger = repetitiveLogger;
        this.rawCollectorUtil = rawCollectorUtil;
        this.objectMapper.registerModule((Module)new GuavaModule());
    }

    @Override
    public SolarisRawData collectRawData(Set<String> componentsToCollect, long maxCollectionTimeMillis) {
        Optional<SolarisRawData> rawDataOpt = Optional.absent();
        if (!this.processBuilder.isPresent()) {
            this.repetitiveLogger.error(log, "Process to collect raw data is not present - skipping collection", new Object[0]);
        } else {
            RawCollectorUtil.ICollectorProcessBuilder collectorProcessBuilder = (RawCollectorUtil.ICollectorProcessBuilder)this.processBuilder.get();
            ImmutableList collectorArguments = ImmutableList.of((Object)RUN_COLLECTOR);
            rawDataOpt = this.rawCollectorUtil.runCollector(SolarisRawData.class, collectorProcessBuilder, this.objectMapper, (Optional<List<String>>)Optional.of((Object)collectorArguments), maxCollectionTimeMillis);
        }
        SolarisRawData rawData = (SolarisRawData)rawDataOpt.or((Object)EMPTY_RAW_DATA);
        this.preProcess(rawData);
        return rawData;
    }

    private void preProcess(SolarisRawData rawData) {
        try {
            this.preProcessProcesses(rawData);
            this.preProcessPartitions(rawData);
            this.preProcessCpus(rawData);
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception during pre-processing: " + String.valueOf(e), new Object[0]);
        }
    }

    @VisibleForTesting
    void preProcessProcesses(SolarisRawData rawData) {
        this.removeZombieProcesses(rawData);
        ArrayListMultimap procData = ArrayListMultimap.create();
        for (Map.Entry<String, SolarisRawData.Process> processEntry : rawData.getProcesses().entrySet()) {
            try {
                SolarisRawData.Process process = processEntry.getValue();
                this.separateNameElapsedTimeCommand(process);
                ProcessClassIdCreator.ProcessClass processClass = this.processClassIdCreator.extractClass(process.getCommandLine(), process.getName());
                procData.put((Object)processClass.getProcessClassId(), (Object)new SolarisRawData.ProcessRawData(processClass, process));
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing process with id {}. The process will not be included in process raw data. " + String.valueOf(e), new Object[]{processEntry.getKey()});
            }
        }
        rawData.setProcData((ListMultimap<String, SolarisRawData.ProcessRawData>)procData);
    }

    @VisibleForTesting
    void preProcessPartitions(SolarisRawData rawData) {
        Map<String, SolarisRawData.Partition> partitions = rawData.getPartitions();
        HashMap<String, SolarisRawData.Partition> updatedPartitions = new HashMap<String, SolarisRawData.Partition>();
        Map<String, String> diskLabelToPartitionNameMap = this.getDiskLabelToPartitionNameMap(rawData);
        HashSet<String> diskLabelsFromPartitions = new HashSet<String>(rawData.getPartitions().keySet());
        for (String diskLabel : diskLabelsFromPartitions) {
            try {
                SolarisRawData.Partition partition = partitions.get(diskLabel);
                if (diskLabelToPartitionNameMap.containsKey(diskLabel)) {
                    updatedPartitions.put(diskLabelToPartitionNameMap.get(diskLabel), partition);
                    continue;
                }
                String cdromDiskLabel = diskLabel + "s2";
                if (diskLabel.matches(CDROM_DISK_LABEL_REGEX) && diskLabelToPartitionNameMap.containsKey(cdromDiskLabel)) {
                    updatedPartitions.put(diskLabelToPartitionNameMap.get(cdromDiskLabel), partition);
                    continue;
                }
                log.debug("Disk label does not match cdrom regular expression, and could not find corresponding partition name for disk label " + diskLabel);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing partition with disk label {}. The partition will be removed from collected data. " + String.valueOf(e), new Object[]{diskLabel});
            }
        }
        rawData.setPartitions(updatedPartitions);
    }

    @VisibleForTesting
    void preProcessCpus(SolarisRawData rawData) {
        Map<String, SolarisRawData.Cpu> unprocessedCpus = rawData.getCpus();
        rawData.setTotalNumLogicalProcessors(rawData.getCpus().size());
        HashMap<String, SolarisRawData.Cpu> preProcessedCpus = new HashMap<String, SolarisRawData.Cpu>();
        HashMap<String, Set<String>> chipIdsToProcessorIds = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> chipIdsToCoreIds = new HashMap<String, Set<String>>();
        for (SolarisRawData.Cpu cpu : unprocessedCpus.values()) {
            String chipId = cpu.getChipId();
            this.addToCpuMap(chipIdsToProcessorIds, chipId, cpu.getProcessorId());
            this.addToCpuMap(chipIdsToCoreIds, chipId, cpu.getCoreId());
        }
        for (Map.Entry entry : chipIdsToProcessorIds.entrySet()) {
            Set processorIdSet = (Set)entry.getValue();
            String chipId = (String)entry.getKey();
            try {
                long totalCurrentSpeed = 0L;
                boolean firstOne = true;
                SolarisRawData.Cpu processedCpu = null;
                for (String processorId : processorIdSet) {
                    if (firstOne) {
                        processedCpu = unprocessedCpus.get(String.valueOf(processorId));
                        firstOne = false;
                    }
                    totalCurrentSpeed += unprocessedCpus.get(String.valueOf(processorId)).getCurrentSpeedHz();
                }
                if (processedCpu == null) continue;
                int numLogicalProcessors = processorIdSet.size();
                processedCpu.setNumCores(((Set)chipIdsToCoreIds.get(chipId)).size());
                processedCpu.setNumLogicalProcessors(numLogicalProcessors);
                long currentSpeedHz = 0L;
                if (numLogicalProcessors != 0) {
                    currentSpeedHz = totalCurrentSpeed / (long)numLogicalProcessors;
                }
                processedCpu.setCurrentSpeedHz(currentSpeedHz);
                if (StringUtils.isBlank((CharSequence)processedCpu.getVendor())) {
                    processedCpu.setVendor(UNKNOWN);
                }
                preProcessedCpus.put(String.valueOf(chipId), processedCpu);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing cpu with chip id {}. The cpu will be removed from collected data. " + String.valueOf(e), new Object[]{chipId});
            }
        }
        rawData.setCpus(preProcessedCpus);
    }

    @VisibleForTesting
    void removeZombieProcesses(SolarisRawData rawData) {
        Map<String, SolarisRawData.Process> processMap = rawData.getProcesses();
        HashMap<String, SolarisRawData.Process> processedProcessMap = new HashMap<String, SolarisRawData.Process>();
        for (Map.Entry<String, SolarisRawData.Process> processEntry : processMap.entrySet()) {
            String processKey = processEntry.getKey();
            try {
                SolarisRawData.Process process = processEntry.getValue();
                if (process.getState().equals(ZOMBIE_STATE)) continue;
                processedProcessMap.put(processKey, process);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when removing defunct process {}. The process will be removed from collected data. " + String.valueOf(e), new Object[]{processKey});
            }
        }
        rawData.setProcesses(processedProcessMap);
    }

    private void addToCpuMap(Map<String, Set<String>> map, String mapKey, String setEntry) {
        if (map.containsKey(mapKey)) {
            map.get(mapKey).add(setEntry);
        } else {
            HashSet<String> newSet = new HashSet<String>();
            newSet.add(setEntry);
            map.put(mapKey, newSet);
        }
    }

    private void separateNameElapsedTimeCommand(SolarisRawData.Process process) {
        String nameElapsedTimeCommandLine = process.getNameElapsedTimeCommandLine();
        NixUtils.SeparatedCommEtimeArgs separatedCommEtimeArgs = NixUtils.separateCommEtimeArgs(nameElapsedTimeCommandLine);
        process.setName(separatedCommEtimeArgs.getCommand());
        process.setElapsedTime(separatedCommEtimeArgs.getElapsedTime());
        process.setCommandLine(separatedCommEtimeArgs.getArgs());
    }

    private Map<String, String> getDiskLabelToPartitionNameMap(SolarisRawData rawData) {
        HashMap<String, String> diskLabelToPartitionNameMap = new HashMap<String, String>();
        for (SolarisRawData.Volume volume : rawData.getVolumes().values()) {
            diskLabelToPartitionNameMap.put(SolarisVolumesUtil.getDiskLabelFromPartitionPath(volume.getName()), volume.getName());
        }
        return diskLabelToPartitionNameMap;
    }
}

