/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import lombok.Generated;

@VisibleForAssistedInject
public class SolarisCpu
extends Cpu<SolarisRawData> {
    private static final String CPU_MAX_SPEED_UNKNOWN = "unknown";
    private final RawDataFactory factory;
    private SolarisRawData.Cpu cpu;

    @Inject
    private SolarisCpu(@Assisted String cpuId, @Sim MachineProperties machineProperties, RawDataItemUtil rawDataItemUtil, RawDataFactory factory) {
        super(cpuId, machineProperties, rawDataItemUtil);
        this.factory = factory;
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpu = rawData.getCpus().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.factory.createLong(Long.valueOf(this.cpu.getNumLogicalProcessors()));
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.factory.createLong(Long.valueOf(this.cpu.getNumCores()));
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.factory.createString(Optional.of((Object)this.cpu.getVendor()));
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.factory.createString(Optional.of((Object)this.cpu.getModel()));
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        String maxSpeed = CPU_MAX_SPEED_UNKNOWN;
        String[] implementationWords = this.cpu.getImplementation().toLowerCase().split(" ");
        for (int i = 0; i < implementationWords.length; ++i) {
            if (!implementationWords[i].contains("mhz") || i <= 0) continue;
            maxSpeed = implementationWords[i - 1];
        }
        return this.factory.createString(Optional.of((Object)maxSpeed.toString()));
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        long value = CalculationUtils.hzToMhz(this.cpu.getCurrentSpeedHz());
        return this.factory.createString(Optional.of((Object)Long.toString(value)));
    }

    @Override
    @Generated
    public String toString() {
        return "SolarisCpu(super=" + super.toString() + ", factory=" + String.valueOf(this.factory) + ", cpu=" + String.valueOf(this.cpu) + ")";
    }
}

