/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarPartitionDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarVolumeDto;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.IntWraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterBulkCountWithTimestamp;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.math.BigInteger;
import java.util.Map;
import lombok.NonNull;

class SigarPartition
extends Partition<SigarRawData> {
    private final RawDataLong notImplemented;
    private final RawDataFactory rawDataFactory;
    private final PerfCounterBulkCountWithTimestamp readsPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp writesPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp readBytesPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp writeBytesPerSecCounter;
    private SigarPartitionDto partitionDto;
    private String volumeId;

    @Inject
    SigarPartition(@Assisted String partitionName, @NonNull RawDataFactory rawDataFactory, @Sim @NonNull MetricsService metricsService, IntWraparoundCalculator intWraparoundCalculator) {
        super(partitionName, metricsService, rawDataFactory);
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.notImplemented = rawDataFactory.createLong("Not Implemented");
        this.rawDataFactory = rawDataFactory;
        this.readsPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.writesPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.readBytesPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.writeBytesPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        String partitionName = this.getPartitionName();
        this.partitionDto = rawData.getDevNameToPartition().get(partitionName);
        long uptimeInSec = this.partitionDto.getUptimeInSec();
        this.readBytesPerSecCounter.calculate(BigInteger.valueOf(this.partitionDto.getDiskReadBytes()), uptimeInSec);
        this.writeBytesPerSecCounter.calculate(BigInteger.valueOf(this.partitionDto.getDiskWriteBytes()), uptimeInSec);
        this.readsPerSecCounter.calculate(BigInteger.valueOf(this.partitionDto.getDiskReads()), uptimeInSec);
        this.writesPerSecCounter.calculate(BigInteger.valueOf(this.partitionDto.getDiskWrites()), uptimeInSec);
        for (Map.Entry<String, SigarVolumeDto> entry : rawData.getMountPointToVolume().entrySet()) {
            SigarVolumeDto v = entry.getValue();
            if (!v.getDevName().equalsIgnoreCase(partitionName)) continue;
            this.volumeId = entry.getKey();
            break;
        }
    }

    @Override
    protected RawDataLong getReadCountPerSec() {
        return this.rawDataFactory.createLong(Long.valueOf(this.readsPerSecCounter.getLastCookedResult()));
    }

    @Override
    protected RawDataLong getReadKbPerSec() {
        long readKbPerSec = CalculationUtils.bytesToKilobytes(this.readBytesPerSecCounter.getLastCookedResult());
        return this.rawDataFactory.createLong(Long.valueOf(readKbPerSec));
    }

    @Override
    protected RawDataLong getWriteCountPerSec() {
        return this.rawDataFactory.createLong(Long.valueOf(this.writesPerSecCounter.getLastCookedResult()));
    }

    @Override
    protected RawDataLong getWriteKbPerSec() {
        long writeKbPerSec = CalculationUtils.bytesToKilobytes(this.writeBytesPerSecCounter.getLastCookedResult());
        return this.rawDataFactory.createLong(Long.valueOf(writeKbPerSec));
    }

    @Override
    protected RawDataLong getUtilization() {
        return this.notImplemented;
    }

    @Override
    protected RawDataLong getAvgReadTimeMillis() {
        return this.notImplemented;
    }

    @Override
    protected RawDataLong getAvgWriteTimeMillis() {
        return this.notImplemented;
    }

    @Override
    protected RawDataLong getSpaceAvailableKb() {
        return this.rawDataFactory.createLong(Long.valueOf(this.partitionDto.getSpaceAvail()));
    }

    @Override
    protected RawDataLong getSpaceUsedKb() {
        return this.rawDataFactory.createLong(Long.valueOf(this.partitionDto.getSpaceUsed()));
    }

    @Override
    public Optional<String> getVolumeId() {
        return Optional.fromNullable((Object)this.volumeId);
    }
}

