/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarOperatingSystemDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import lombok.NonNull;

class SigarOperatingSystem
extends OperatingSystem<SigarRawData> {
    private static final Optional<String> UNKNOWN_OS_TYPE = Optional.of((Object)"UNKNOWN");
    private static final Map<String, String> sigar2SimOsNameMap = ImmutableMap.of((Object)"Win32", (Object)"Windows", (Object)"Linux", (Object)"Linux", (Object)"Solaris", (Object)"Solaris", (Object)"AIX", (Object)"AIX", (Object)"MacOSX", (Object)"OSX");
    private SigarOperatingSystemDto operatingSystemDto;

    @Inject
    SigarOperatingSystem(@NonNull String osName, @Sim @NonNull MachineProperties machineProperties, @NonNull Predicate<ToggleableReporter<SigarRawData>> isDisabledPredicate, @NonNull RawDataFactory rawDataFactory) {
        super(osName, machineProperties, isDisabledPredicate, rawDataFactory);
        if (osName == null) {
            throw new NullPointerException("osName is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.operatingSystemDto = rawData.getOs();
    }

    @Override
    protected RawDataString getOsName() {
        String nativeOsName = this.translateSigarOsName(this.operatingSystemDto.getName());
        return this.rawDataFromString(nativeOsName);
    }

    @Override
    protected RawDataString getRelease() {
        return this.rawDataFromString(this.operatingSystemDto.getVersion());
    }

    @Override
    protected RawDataString getArchitecture() {
        return this.rawDataFromString(this.operatingSystemDto.getArch());
    }

    private RawDataString rawDataFromString(String value) {
        return this.rawDataFactory.createString(Optional.of((Object)value));
    }

    private String translateSigarOsName(String sigarOsName) {
        Optional<String> nativeOsName = Optional.fromNullable((Object)sigar2SimOsNameMap.get(sigarOsName));
        if (!nativeOsName.isPresent()) {
            nativeOsName = UNKNOWN_OS_TYPE;
        }
        return (String)nativeOsName.get();
    }
}

