/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.DependentMetricValueSupplier;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarProcessesDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.util.NixProcessStateUtil;
import com.appdynamics.sim.agent.extensions.servers.util.NixRawDataProcessClassSummingCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.processes.common.rest.SimProcessDtoState;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SigarMonitoredProcessClass
extends MonitoredProcessClass<SigarRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigarMonitoredProcessClass.class);
    private static final String UNKNOWN_VALUE = "Unknown";
    private static final double ONE_HUNDRED_PERCENT = 100.0;
    private final RawDataFactory factory;
    private final NixProcessStateUtil procStateUtil;
    private final NixRawDataProcessClassSummingCalculator cpuUsedPercent;
    private final NixRawDataProcessClassSummingCalculator majorFaultsRate;
    private final NixRawDataProcessClassSummingCalculator minorFaultsRate;
    private final RawDataItemUtil rawDataItemUtil;
    private final RawDataLong notImplementedLong;
    private final DependentMetricValueSupplier dependentMetricValueSupplier;
    private RawDataLong memoryUsedKb;
    private RawDataLong memoryUsedPercent;
    private RawDataLong numThreads;
    private RawDataLong virtualMemoryKb;
    private RawDataLong processCount;
    private RawDataLong numProcessors;
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessCpuMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessMemoryMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, SimProcessDtoState> currentProcessStateMetrics = new HashMap<RawDataLong, SimProcessDtoState>();
    private Map<RawDataLong, Pair<Long, Long>> pidToCpuTimeAndEpochTime = new HashMap<RawDataLong, Pair<Long, Long>>();
    private Map<RawDataLong, String> currentProcessCommandLineMap = new HashMap<RawDataLong, String>();

    @Inject
    SigarMonitoredProcessClass(@Assisted @NonNull String classId, @Sim @NonNull MetricsService metricsService, @NonNull Provider<ServersMonitorConfig> serversMonitorConfig, @NonNull RawDataFactory rawDataFactory, @NonNull ProcessProperties processProperties, @NonNull NixProcessStateUtil procStateUtil, @NonNull RawDataItemUtil rawDataItemUtil, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull DependentMetricValueSupplier dependentMetricValueSupplier, BootstrapConfiguration bootstrapConfiguration) {
        super(classId, metricsService, serversMonitorConfig, processProperties, repetitiveLogger, rawDataFactory);
        if (classId == null) {
            throw new NullPointerException("classId is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (serversMonitorConfig == null) {
            throw new NullPointerException("serversMonitorConfig is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (procStateUtil == null) {
            throw new NullPointerException("procStateUtil is marked non-null but is null");
        }
        if (rawDataItemUtil == null) {
            throw new NullPointerException("rawDataItemUtil is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (dependentMetricValueSupplier == null) {
            throw new NullPointerException("dependentMetricValueSupplier is marked non-null but is null");
        }
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.factory = rawDataFactory;
        this.procStateUtil = procStateUtil;
        this.cpuUsedPercent = new NixRawDataProcessClassSummingCalculator(this.factory, NixRawDataProcessClassSummingCalculator.CPU_USAGE_CALC);
        this.majorFaultsRate = new NixRawDataProcessClassSummingCalculator(this.factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
        this.minorFaultsRate = new NixRawDataProcessClassSummingCalculator(this.factory, NixRawDataProcessClassSummingCalculator.RATE_CALC);
        this.rawDataItemUtil = rawDataItemUtil;
        this.notImplementedLong = rawDataFactory.createLong("Not implemented");
        this.dependentMetricValueSupplier = dependentMetricValueSupplier;
    }

    @Override
    protected void updateMetrics(SigarRawData rawData, List<SimProcessObservationDto> filteredObservations) {
        Optional<Long> numLogicalCores = this.dependentMetricValueSupplier.getNumCpuLogicalCores();
        this.numProcessors = numLogicalCores.isPresent() ? this.factory.createLong((Long)numLogicalCores.get()) : this.notImplementedLong;
        List allProcsData = rawData.getProcesses().getProcData().get((Object)this.getClassId());
        if (allProcsData.isEmpty()) {
            return;
        }
        ImmutableSet.Builder filteredProcessIdSetBuilder = new ImmutableSet.Builder();
        for (SimProcessObservationDto simProcessObservationDto : filteredObservations) {
            filteredProcessIdSetBuilder.add((Object)this.factory.createLong(Long.valueOf(simProcessObservationDto.getProcessId())));
        }
        ImmutableSet filteredProcessIdSet = filteredProcessIdSetBuilder.build();
        ImmutableMap.Builder pidToCpuTimeMapBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder pidToMajorFaultMapBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder pidToMinorFaultMapBuilder = new ImmutableMap.Builder();
        this.memoryUsedKb = RawDataConstants.ZERO_LONG;
        this.numThreads = RawDataConstants.ZERO_LONG;
        this.virtualMemoryKb = RawDataConstants.ZERO_LONG;
        double memoryUsedPercentDbl = 0.0;
        RawDataLong cpuTimeInSeconds = this.factory.createLong(Long.valueOf(0L));
        for (SigarProcessesDto.ProcessRawData procData : allProcsData) {
            SigarProcessesDto.Process process = procData.getProcess();
            RawDataLong processId = this.factory.createLong(Long.valueOf(procData.getProcess().getPid()));
            try {
                cpuTimeInSeconds = process.getCpuTimeMillis().divide(RawDataConstants.MILLISECONDS_PER_SECOND);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn(ex.getMessage());
            }
            RawDataLong majorFaults = process.getMajorFault();
            RawDataLong minorFaults = process.getMinorFault();
            if (processId.isPresent() && filteredProcessIdSet.contains((Object)processId)) {
                this.memoryUsedKb = this.memoryUsedKb.add(this.rawDataItemUtil.bytesToKilobytes(process.getRssSizeBytes()));
                this.numThreads = this.numThreads.add(process.getThreadCount());
                this.virtualMemoryKb = this.virtualMemoryKb.add(this.rawDataItemUtil.bytesToKilobytes(process.getVirtualMemorySizeBytes()));
                try {
                    Optional<Long> totalMemoryBytesOpt = this.dependentMetricValueSupplier.getTotalMemoryBytes();
                    if (totalMemoryBytesOpt.isPresent()) {
                        double totalBytes = ((Long)totalMemoryBytesOpt.get()).longValue();
                        double processRssSize = process.getRssSizeBytes().isPresent() ? (double)process.getRssSizeBytes().get().longValue() : 0.0;
                        double processMemoryPercentage = 100.0 * (processRssSize / totalBytes);
                        memoryUsedPercentDbl += processMemoryPercentage;
                    }
                }
                catch (IllegalStateException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
            pidToCpuTimeMapBuilder.put((Object)processId, (Object)cpuTimeInSeconds);
            pidToMajorFaultMapBuilder.put((Object)processId, (Object)majorFaults);
            pidToMinorFaultMapBuilder.put((Object)processId, (Object)minorFaults);
        }
        this.memoryUsedPercent = this.factory.createLong(Long.valueOf(Math.round(memoryUsedPercentDbl)));
        this.processCount = this.factory.createLong(Long.valueOf(filteredObservations.size()));
        Optional<Long> uptimeOpt = rawData.getProcesses().getUptime();
        RawDataLong upTimeSecondsRawDataLong = uptimeOpt.isPresent() ? this.factory.createLong((Long)uptimeOpt.get()).divide(RawDataConstants.MILLISECONDS_PER_SECOND) : this.factory.createLong("Could not get system up time");
        this.cpuUsedPercent.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToCpuTimeMapBuilder.build(), upTimeSecondsRawDataLong, (Set<RawDataLong>)filteredProcessIdSet);
        this.majorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMajorFaultMapBuilder.build(), upTimeSecondsRawDataLong, (Set<RawDataLong>)filteredProcessIdSet);
        this.minorFaultsRate.calculate((ImmutableMap<RawDataLong, RawDataLong>)pidToMinorFaultMapBuilder.build(), upTimeSecondsRawDataLong, (Set<RawDataLong>)filteredProcessIdSet);
    }

    @Override
    protected ImmutableList<SimProcessObservationDto> getAllObservations(SigarRawData rawData) {
        List allProcData = rawData.getProcesses().getProcData().get((Object)this.getClassId());
        ImmutableList.Builder observationsBuilder = ImmutableList.builder();
        this.updateProcessMetricsMap(allProcData, rawData.getProcesses().getUptime());
        for (SigarProcessesDto.ProcessRawData processRawData : allProcData) {
            SigarProcessesDto.Process process = processRawData.getProcess();
            long elapsedTimeInMillis = 0L;
            try {
                if (process.getLiveTimeMillis().isPresent()) {
                    elapsedTimeInMillis = process.getLiveTimeMillis().get();
                }
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn(ex.getMessage());
            }
            SimProcessObservationDto observation = new SimProcessObservationDto(elapsedTimeInMillis, processRawData.getProcClass().getProcessClassId(), processRawData.getProcClass().getProcessClass(), process.getName().or(UNKNOWN_VALUE), process.getPid(), process.getParentPid().or(Long.valueOf(UnknownValueUtil.getUnknownValue())).longValue(), process.getCommandLine().or(UNKNOWN_VALUE), process.getUser().or(UNKNOWN_VALUE), this.procStateUtil.getProcessState(process.getState().or(UNKNOWN_VALUE)), Collections.emptyMap());
            observationsBuilder.add((Object)observation);
        }
        return observationsBuilder.build();
    }

    private void updateProcessMetricsMap(List<SigarProcessesDto.ProcessRawData> procData, Optional<Long> uptimeOpt) {
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newCpuData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newMemoryData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, String> newCommandLineMap = new HashMap<RawDataLong, String>();
        HashMap<RawDataLong, SimProcessDtoState> newStateData = new HashMap<RawDataLong, SimProcessDtoState>();
        for (SigarProcessesDto.ProcessRawData processRawData : procData) {
            SigarProcessesDto.Process process = processRawData.getProcess();
            RawDataLong pid = this.factory.createLong(Long.valueOf(process.getPid()));
            Long cpuTime = 0L;
            try {
                cpuTime = process.getCpuTimeMillis().divide(RawDataConstants.MILLISECONDS_PER_SECOND).get();
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                log.warn(ex.getMessage());
            }
            RawDataLong cpuUsage = null;
            if (uptimeOpt.isPresent()) {
                Long epochTime = this.factory.createLong((Long)uptimeOpt.get()).divide(RawDataConstants.MILLISECONDS_PER_SECOND).get();
                if (this.pidToCpuTimeAndEpochTime.get(pid) != null) {
                    Long oldCpuTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).first;
                    Long oldEpochTime = (Long)this.pidToCpuTimeAndEpochTime.get((Object)pid).second;
                    if (epochTime > oldEpochTime) {
                        long cpuTimeDifference = cpuTime - oldCpuTime;
                        long epochTimeDifference = epochTime - oldEpochTime;
                        cpuUsage = this.factory.createLong(Long.valueOf(Math.round(100.0 * (double)cpuTimeDifference / (double)epochTimeDifference)));
                    }
                }
                this.pidToCpuTimeAndEpochTime.put(pid, Pair.of(cpuTime, epochTime));
            }
            if (cpuUsage == null) continue;
            RawDataLong memoryUsage = null;
            double processRssSize = process.getRssSizeBytes().isPresent() ? (double)process.getRssSizeBytes().get().longValue() : 0.0;
            if (this.dependentMetricValueSupplier.getTotalMemoryBytes().isPresent()) {
                double totalBytes = ((Long)this.dependentMetricValueSupplier.getTotalMemoryBytes().get()).longValue();
                memoryUsage = this.factory.createLong(Long.valueOf(Math.round(100.0 * (processRssSize / totalBytes))));
            } else {
                memoryUsage = this.factory.createLong(Long.valueOf(0L));
            }
            cpuUsage = this.numProcessors.or(Long.valueOf(0L)) != 0L ? cpuUsage.divide(this.numProcessors) : cpuUsage;
            Double alpha = this.getAverageAlpha();
            Double expoMovingMemoryAverageValue = (double)memoryUsage.get().longValue() * 1.0;
            Double expoMovingCpuAverageValue = (double)cpuUsage.get().longValue() * 1.0;
            if (this.currentProcessMemoryMetrics.get(pid) != null) {
                Double oldMemoryUsage = this.currentProcessMemoryMetrics.get(pid).getSecond();
                Double oldCpuUsage = this.currentProcessCpuMetrics.get(pid).getSecond();
                expoMovingMemoryAverageValue = oldMemoryUsage + alpha * ((double)memoryUsage.get().longValue() - oldMemoryUsage);
                expoMovingCpuAverageValue = oldCpuUsage + alpha * ((double)cpuUsage.get().longValue() - oldCpuUsage);
            }
            newCpuData.put(pid, Pair.of(cpuUsage, expoMovingCpuAverageValue));
            newMemoryData.put(pid, Pair.of(memoryUsage, expoMovingMemoryAverageValue));
            newCommandLineMap.put(pid, process.getCommandLine().get());
            newStateData.put(pid, this.procStateUtil.getProcessState(process.getState().or(UNKNOWN_VALUE)));
            this.currentProcessStateMetrics.remove(pid);
        }
        this.currentProcessCpuMetrics = newCpuData;
        this.currentProcessMemoryMetrics = newMemoryData;
        this.currentProcessCommandLineMap = newCommandLineMap;
        this.currentProcessStateMetrics.keySet().stream().forEach(key -> newStateData.put((RawDataLong)key, SimProcessDtoState.TERMINATED));
        this.currentProcessStateMetrics = newStateData;
    }

    @Override
    protected RawDataLong getMemoryUsedKb() {
        return this.memoryUsedKb;
    }

    @Override
    protected RawDataLong getMemoryUsedPercent() {
        return this.memoryUsedPercent;
    }

    @Override
    protected RawDataLong getNumThreads() {
        return this.numThreads;
    }

    @Override
    protected RawDataLong getMajorFaultsRate() {
        return this.majorFaultsRate.getLastCookedResult();
    }

    @Override
    protected RawDataLong getMinorFaultsRate() {
        return this.minorFaultsRate.getLastCookedResult();
    }

    @Override
    protected RawDataLong getCpuUsedPercent() {
        RawDataLong calculatedCpuUsedPercent = this.cpuUsedPercent.getLastCookedResult();
        if (this.numProcessors.isPresent()) {
            return calculatedCpuUsedPercent.divide(this.numProcessors);
        }
        this.repetitiveLogger.warn(log, "Could not get number of cpu cores. Process cpu percentage not normalized", new Object[0]);
        return calculatedCpuUsedPercent;
    }

    @Override
    protected RawDataLong getVirtualMemoryKb() {
        return this.virtualMemoryKb;
    }

    @Override
    protected RawDataLong getProcessCount() {
        return this.processCount;
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessCpuMetrics() {
        return this.currentProcessCpuMetrics;
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessMemoryMetrics() {
        return this.currentProcessMemoryMetrics;
    }

    @Override
    public Map<RawDataLong, String> getCurrentProcessCommandLineMap() {
        return this.currentProcessCommandLineMap;
    }

    @Override
    public Map<RawDataLong, SimProcessDtoState> getCurrentProcessStateMetrics() {
        return this.currentProcessStateMetrics;
    }
}

